/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.orc.impl.AircompressorCodec;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;

public class SnappyCodec
extends AircompressorCodec
implements DirectDecompressionCodec {
    private static final HadoopShims SHIMS = HadoopShims.Factory.get();
    Boolean direct = null;

    SnappyCodec() {
        super(new SnappyCompressor(), new SnappyDecompressor());
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        super.decompress(in, out);
    }

    @Override
    public boolean isAvailable() {
        if (this.direct == null) {
            try {
                this.direct = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY) != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            catch (UnsatisfiedLinkError ule) {
                this.direct = false;
            }
        }
        return this.direct;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        HadoopShims.DirectDecompressor decompressShim = SHIMS.getDirectDecompressor(HadoopShims.DirectCompressionType.SNAPPY);
        decompressShim.decompress(in, out);
        out.flip();
    }
}

