/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.servicemonitor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.slider.server.servicemonitor.MonitorKeys;
import org.apache.slider.server.servicemonitor.ProbeStatus;

public abstract class Probe
implements MonitorKeys {
    protected final Configuration conf;
    private String name;
    public int successCount;
    public int failureCount;
    public long bootstrapStarted;
    public long bootstrapFinished;
    private boolean booted = false;

    public Probe(String name, Configuration conf) {
        this.name = name;
        this.conf = conf;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " {" + "successCount=" + this.successCount + ", failureCount=" + this.failureCount + '}';
    }

    public void init() throws IOException {
    }

    public abstract ProbeStatus ping(boolean var1);

    public void beginBootstrap() {
        this.bootstrapStarted = System.currentTimeMillis();
    }

    public void endBootstrap() {
        this.setBooted(true);
        this.bootstrapFinished = System.currentTimeMillis();
    }

    public boolean isBooted() {
        return this.booted;
    }

    public void setBooted(boolean booted) {
        this.booted = booted;
    }
}

