/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.management;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.slider.server.appmaster.management.MetricsKeys;
import org.apache.slider.server.services.workflow.ClosingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsBindingService
extends CompositeService
implements MetricsKeys {
    protected static final Logger log = LoggerFactory.getLogger(MetricsBindingService.class);
    private final MetricRegistry metrics;
    private String reportingDetails = "not started";

    public MetricsBindingService(String name, MetricRegistry metrics) {
        super(name);
        Preconditions.checkArgument((metrics != null ? 1 : 0) != 0, (Object)"Null metrics");
        this.metrics = metrics;
    }

    public MetricsBindingService(String name) {
        this(name, new MetricRegistry());
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        StringBuilder summary = new StringBuilder();
        Configuration conf = this.getConfig();
        summary.append("Reporting to JMX");
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).build();
        jmxReporter.start();
        this.addService((Service)new ClosingService<JmxReporter>(jmxReporter));
        if (conf.getBoolean("slider.metrics.ganglia.enabled", false)) {
            log.warn("Ganglia integration is not implemented");
        }
        if (conf.getBoolean("slider.metrics.logging.enabled", false)) {
            String logName = conf.getTrimmed("slider.metrics.logging.log.name", "org.apache.slider.metrics.log");
            int interval = conf.getInt("slider.metrics.logging.interval.minutes", 60);
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metrics).convertRatesTo(TimeUnit.SECONDS).outputTo(LoggerFactory.getLogger((String)logName)).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start((long)interval, TimeUnit.MINUTES);
            this.addService((Service)new ClosingService<Slf4jReporter>(reporter));
            summary.append(String.format(", SLF4J to log %s interval=%d", logName, interval));
        }
        this.reportingDetails = summary.toString();
        log.info(this.reportingDetails);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.reportingDetails;
    }
}

