/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.UsageException;

@Parameters(commandNames={"kdiag"}, commandDescription="Diagnose Kerberos problems")
public class ActionKDiagArgs
extends AbstractActionArgs {
    @Parameter(names={"--fail"}, description="return an exit code if the diagnostics failed")
    public boolean fail = true;
    @Parameter(names={"--services"}, variableArity=true, description=" list of services to check")
    public List<String> services = new ArrayList<String>();
    @Parameter(names={"--out", "-o"}, description="output file for report")
    public File out;
    @Parameter(names={"--keytab"}, description="keytab to use")
    public File keytab;
    @Parameter(names={"--principal"}, description="principal to log in from a keytab")
    public String principal;

    @Override
    public String getActionName() {
        return "kdiag";
    }

    @Override
    public int getMinParams() {
        return 0;
    }

    @Override
    public boolean getHadoopServicesRequired() {
        return false;
    }

    @Override
    public boolean disableSecureLogin() {
        return true;
    }

    @Override
    public void validate() throws BadCommandArgumentsException, UsageException {
        super.validate();
        if (this.keytab != null && SliderUtils.isUnset(this.principal)) {
            throw new UsageException("Missing argument --principal", new Object[0]);
        }
        if (this.keytab == null && SliderUtils.isSet(this.principal)) {
            throw new UsageException("Missing argument --keytab", new Object[0]);
        }
    }
}

