/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oozie.util.MultiFileReader;
import org.apache.oozie.util.TimestampedMessageParser;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;

public class XLogStreamer {
    private static XLog LOG = XLog.getLog(XLogStreamer.class);
    private String logFile;
    private String logPath;
    private XLogFilter logFilter;
    private long logRotation;
    public static final Pattern gzTimePattern = Pattern.compile(".*-(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)-(\\d\\d)\\.gz");

    public XLogStreamer(XLogFilter logFilter, String logPath, String logFile, long logRotationSecs) {
        this.logFilter = logFilter;
        if (logFile == null) {
            logFile = "oozie-app.log";
        }
        this.logFile = logFile;
        this.logPath = logPath;
        this.logRotation = logRotationSecs * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamLog(Writer writer, Date startTime, Date endTime, int bufferLen) throws IOException {
        try (BufferedReader reader = new BufferedReader(this.getReader(startTime, endTime));){
            if (this.logFilter.isDebugMode()) {
                writer.write(this.logFilter.getDebugMessage());
            }
            new TimestampedMessageParser(reader, this.logFilter).processRemaining(writer, bufferLen);
        }
    }

    private MultiFileReader getReader(Date startTime, Date endTime) throws IOException {
        this.logFilter.calculateAndValidateDateRange(startTime, endTime);
        return new MultiFileReader(this.getFileList(this.logFilter.getStartDate(), this.logFilter.getEndDate()));
    }

    public BufferedReader makeReader(Date startTime, Date endTime) throws IOException {
        return new BufferedReader(this.getReader(startTime, endTime));
    }

    private ArrayList<File> getFileList(Date startTime, Date endTime) throws IOException {
        long startTimeMillis = 0L;
        if (startTime != null) {
            startTimeMillis = startTime.getTime();
        }
        long endTimeMillis = endTime == null ? System.currentTimeMillis() : endTime.getTime();
        File dir = new File(this.logPath);
        return this.getFileList(dir, startTimeMillis, endTimeMillis, this.logRotation, this.logFile);
    }

    private ArrayList<File> getFileList(File dir, long startTime, long endTime, long logRotationTime, String logFile) {
        String[] children = dir.list();
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        if (children == null) {
            return new ArrayList<File>();
        }
        for (int i = 0; i < children.length; ++i) {
            String fileName = children[i];
            if (!fileName.startsWith(logFile) && !fileName.equals(logFile)) continue;
            File file = new File(dir.getAbsolutePath(), fileName);
            if (fileName.endsWith(".gz")) {
                long gzFileCreationTime = this.getGZFileCreationTime(fileName, startTime, endTime);
                if (gzFileCreationTime == -1L) continue;
                fileList.add(new FileInfo(file, gzFileCreationTime));
                continue;
            }
            long modTime = file.lastModified();
            if (modTime < startTime || modTime / logRotationTime > endTime / logRotationTime + 1L) continue;
            fileList.add(new FileInfo(file, modTime));
        }
        Collections.sort(fileList);
        ArrayList<File> files = new ArrayList<File>(fileList.size());
        for (FileInfo info : fileList) {
            files.add(info.getFile());
        }
        return files;
    }

    private long getGZFileCreationTime(String fileName, long startTime, long endTime) {
        long returnVal = -1L;
        if (fileName.equals("oozie.log.gz")) {
            LOG.warn("oozie.log has been GZipped, which is unexpected");
            returnVal = 0L;
        } else {
            Matcher m = gzTimePattern.matcher(fileName);
            if (m.matches() && m.groupCount() == 4) {
                int year = Integer.parseInt(m.group(1));
                int month = Integer.parseInt(m.group(2));
                int day = Integer.parseInt(m.group(3));
                int hour = Integer.parseInt(m.group(4));
                int minute = 0;
                Calendar calendarEntry = Calendar.getInstance();
                calendarEntry.set(year, month - 1, day, hour, minute);
                long logFileStartTime = calendarEntry.getTimeInMillis();
                long milliSecondsPerHour = 3600000L;
                long logFileEndTime = logFileStartTime + milliSecondsPerHour;
                if (startTime >= logFileStartTime && startTime <= logFileEndTime || endTime >= logFileStartTime && endTime <= logFileEndTime || startTime <= logFileStartTime && endTime >= logFileEndTime) {
                    returnVal = logFileStartTime;
                }
            } else {
                LOG.debug("Filename " + fileName + " does not match the expected format");
                returnVal = -1L;
            }
        }
        return returnVal;
    }

    public class FileInfo
    implements Comparable<FileInfo> {
        File file;
        long modTime;

        public FileInfo(File file, long modTime) {
            this.file = file;
            this.modTime = modTime;
        }

        public File getFile() {
            return this.file;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = this.modTime - fileInfo.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

