/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.atomic.PromotedToLock;
import org.apache.curator.retry.RetryNTimes;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;

public class ZKUUIDService
extends UUIDService {
    public static final String CONF_PREFIX = "oozie.service.ZKUUIDService.";
    public static final String CONF_SEQUENCE_MAX = "oozie.service.ZKUUIDService.jobid.sequence.max";
    public static final String LOCKS_NODE = "/SEQUENCE_LOCK";
    public static final String ZK_SEQUENCE_PATH = "/job_id_sequence";
    public static final long RESET_VALUE = 0L;
    public static final int RETRY_COUNT = 3;
    private static final XLog LOG = XLog.getLog(ZKUUIDService.class);
    private ZKUtils zk;
    private static Long maxSequence = 9999990L;
    DistributedAtomicLong atomicIdGenerator;
    public static final ThreadLocal<SimpleDateFormat> dt = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyMMddHHmmssSSS");
        }
    };

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            PromotedToLock.Builder lockBuilder = PromotedToLock.builder().lockPath(this.getPromotedLock()).retryPolicy(ZKUUIDService.getRetryPolicy()).timeout(Service.lockTimeout, TimeUnit.MILLISECONDS);
            this.atomicIdGenerator = new DistributedAtomicLong(this.zk.getClient(), ZK_SEQUENCE_PATH, ZKUUIDService.getRetryPolicy(), lockBuilder.build());
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    protected String createSequence() {
        String localStartTime = this.startTime;
        long id = 0L;
        try {
            id = this.getZKSequence();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting jobId, switching to old UUIDService", e);
            id = super.getCounter();
            localStartTime = dt.get().format(new Date());
        }
        return this.appendTimeToSequence(id, localStartTime);
    }

    protected synchronized long getZKSequence() throws Exception {
        long id = this.getDistributedSequence();
        if (id >= maxSequence) {
            this.resetSequence();
            id = this.getDistributedSequence();
        }
        return id;
    }

    private long getDistributedSequence() throws Exception {
        if (this.atomicIdGenerator == null) {
            throw new Exception("Sequence generator can't be null. Path : /job_id_sequence");
        }
        AtomicValue value = null;
        try {
            value = this.atomicIdGenerator.increment();
            return (long)value;
        }
        catch (Exception e) {
            throw new Exception("Exception incrementing UID for session ", e);
        }
        finally {
            if (value != null && value.succeeded()) {
                return (Long)value.preValue();
            }
            throw new Exception("Exception incrementing UID for session ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSequence() throws Exception {
        for (int i = 0; i < 3; ++i) {
            LockToken lock;
            block15: {
                AtomicValue value;
                block14: {
                    value = this.atomicIdGenerator.get();
                    if (value.succeeded() && (Long)value.postValue() < maxSequence) {
                        return;
                    }
                    lock = null;
                    try {
                        lock = Services.get().get(MemoryLocksService.class).getWriteLock(ZKUUIDService.class.getName(), lockTimeout);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (lock != null) break block14;
                    LOG.info("Lock is held by other system, will sleep and try again");
                    Thread.sleep(1000L);
                    if (lock == null) continue;
                    lock.release();
                    continue;
                }
                value = this.atomicIdGenerator.get();
                if (!value.succeeded() || (Long)value.postValue() >= maxSequence) break block15;
                if (lock != null) {
                    lock.release();
                }
                return;
            }
            try {
                this.atomicIdGenerator.forceSet(Long.valueOf(0L));
            }
            catch (Exception e) {
                LOG.info("Exception while resetting sequence, will try again");
                if (lock == null) continue;
                lock.release();
                continue;
            }
            try {
                this.resetStartTime();
                return;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        throw new Exception("Can't reset ID sequence in ZK. Retried 3 times");
    }

    @Override
    public void destroy() {
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    public String getPromotedLock() {
        if (ZKUtils.getZKNameSpace().startsWith("/")) {
            return ZKUtils.getZKNameSpace() + LOCKS_NODE;
        }
        return "/" + ZKUtils.getZKNameSpace() + LOCKS_NODE;
    }

    @VisibleForTesting
    static void setMaxSequence(long sequence) {
        maxSequence = sequence;
    }

    private static RetryPolicy getRetryPolicy() {
        return new RetryNTimes(25, 200);
    }
}

