/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.ChildReaper;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.utils.ThreadUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.event.listener.ZKConnectionListener;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;

public class ZKLocksService
extends MemoryLocksService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private static XLog LOG = XLog.getLog(ZKLocksService.class);
    public static final String LOCKS_NODE = "/locks";
    private ConcurrentMap<String, InterProcessReadWriteLock> zkLocks = new MapMaker().weakValues().makeMap();
    private static final String REAPING_LEADER_PATH = "/services/locksChildReaperLeaderPath";
    public static final String REAPING_THRESHOLD = "oozie.service.ZKLocksService.locks.reaper.threshold";
    public static final String REAPING_THREADS = "oozie.service.ZKLocksService.locks.reaper.threads";
    private ChildReaper reaper = null;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            this.reaper = new ChildReaper(this.zk.getClient(), LOCKS_NODE, Reaper.Mode.REAP_UNTIL_GONE, ZKLocksService.getExecutorService(), ConfigurationService.getInt(services.getConf(), REAPING_THRESHOLD) * 1000, REAPING_LEADER_PATH);
            this.reaper.start();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        if (this.reaper != null && ZKConnectionListener.getZKConnectionState() != ConnectionState.LOST) {
            try {
                this.reaper.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing childReaper", e);
            }
        }
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("locks", "locks", new Instrumentation.Variable<Integer>(){

            @Override
            public Integer getValue() {
                return ZKLocksService.this.zkLocks.size();
            }
        });
    }

    @Override
    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        return this.acquireLock(resource, MemoryLocksService.Type.READ, wait);
    }

    @Override
    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        return this.acquireLock(resource, MemoryLocksService.Type.WRITE, wait);
    }

    private LockToken acquireLock(String resource, MemoryLocksService.Type type, long wait) throws InterruptedException {
        InterProcessReadWriteLock newLock;
        InterProcessReadWriteLock lockEntry = (InterProcessReadWriteLock)this.zkLocks.get(resource);
        if (lockEntry == null && (lockEntry = this.zkLocks.putIfAbsent(resource, newLock = new InterProcessReadWriteLock(this.zk.getClient(), "/locks/" + resource))) == null) {
            lockEntry = newLock;
        }
        InterProcessMutex lock = type.equals((Object)MemoryLocksService.Type.READ) ? lockEntry.readLock() : lockEntry.writeLock();
        ZKLockToken token = null;
        try {
            if (wait == -1L) {
                lock.acquire();
                token = new ZKLockToken(lockEntry, type);
            } else if (lock.acquire(wait, TimeUnit.MILLISECONDS)) {
                token = new ZKLockToken(lockEntry, type);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while acquiring lock", ex);
        }
        return token;
    }

    @VisibleForTesting
    public ConcurrentMap<String, InterProcessReadWriteLock> getLocks() {
        return this.zkLocks;
    }

    private static ScheduledExecutorService getExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool((int)ConfigurationService.getInt(REAPING_THREADS), (String)"ZKLocksChildReaper");
    }

    class ZKLockToken
    implements LockToken {
        private final InterProcessReadWriteLock lockEntry;
        private final MemoryLocksService.Type type;

        private ZKLockToken(InterProcessReadWriteLock lockEntry, MemoryLocksService.Type type) {
            this.lockEntry = lockEntry;
            this.type = type;
        }

        @Override
        public void release() {
            try {
                switch (this.type) {
                    case WRITE: {
                        this.lockEntry.writeLock().release();
                        break;
                    }
                    case READ: {
                        this.lockEntry.readLock().release();
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not release lock: " + ex.getMessage()), ex);
            }
        }
    }
}

