/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.SLAAlertsXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.ServiceException;

public abstract class BundleSLAAlertsXCommand
extends SLAAlertsXCommand {
    private String actions;
    private String dates;
    private String childIds;

    public BundleSLAAlertsXCommand(String jobId, String actions, String dates, String childIds) {
        super(jobId, "SLA.command", "SLA.command");
        this.actions = actions;
        this.dates = dates;
        this.childIds = childIds;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    protected Set<String> getCoordJobsFromBundle(String id, String coords) throws CommandException {
        List<CoordinatorJobBean> coordJobs;
        HashSet<String> jobs = new HashSet<String>();
        try {
            coordJobs = coords == null ? CoordJobQueryExecutor.getInstance().getList(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOBS_WITH_PARENT_ID, id) : CoordJobQueryExecutor.getInstance().getList(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOBS_FOR_BUNDLE_BY_APPNAME_ID, Arrays.asList(coords.split(",")), id);
        }
        catch (XException e) {
            throw new CommandException(e);
        }
        for (CoordinatorJobBean jobBean : coordJobs) {
            jobs.add(jobBean.getId());
        }
        return jobs;
    }

    protected String getCoordJobs() {
        return this.childIds;
    }

    protected String getActions() {
        return this.actions;
    }

    protected String getDates() {
        return this.dates;
    }

    @Override
    protected boolean isJobRequest() {
        return true;
    }

    @Override
    protected boolean executeSlaCommand() throws ServiceException, CommandException {
        StringBuffer report = new StringBuffer();
        Set<String> coordJobs = this.getCoordJobsFromBundle(this.getJobId(), this.getCoordJobs());
        if (coordJobs.isEmpty()) {
            throw new CommandException(ErrorCode.E1026, "No record found");
        }
        for (String job : coordJobs) {
            try {
                this.executeCoordCommand(job, this.getActions(), this.getDates());
            }
            catch (Exception e) {
                String errorMsg = "SLA command for coord job " + job + " failed. Error message is  : " + e.getMessage();
                this.LOG.error((Object)errorMsg, e);
                report.append(errorMsg).append(System.getProperty("line.separator"));
            }
        }
        if (!report.toString().isEmpty()) {
            throw new CommandException(ErrorCode.E1026, report.toString());
        }
        return true;
    }

    protected abstract void executeCoordCommand(String var1, String var2, String var3) throws ServiceException, CommandException;
}

