/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.MRStats;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class SqoopActionExecutor
extends JavaActionExecutor {
    public static final String OOZIE_ACTION_EXTERNAL_STATS_WRITE = "oozie.action.external.stats.write";
    private static final String SQOOP_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.SqoopMain";
    static final String SQOOP_ARGS = "oozie.sqoop.args";

    public SqoopActionExecutor() {
        super("sqoop");
    }

    @Override
    public List<Class> getLauncherClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            classes.add(Class.forName(SQOOP_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", SQOOP_MAIN_CLASS_NAME);
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        String[] args;
        super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        try {
            Element e = actionXml.getChild("configuration", ns);
            if (e != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                SqoopActionExecutor.checkForDisallowedProps(inlineConf, "inline configuration");
                XConfiguration.copy(inlineConf, actionConf);
            }
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
        if (actionXml.getChild("command", ns) != null) {
            String command = actionXml.getChild("command", ns).getTextTrim();
            StringTokenizer st = new StringTokenizer(command, " ");
            ArrayList<String> l = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                l.add(st.nextToken());
            }
            args = l.toArray(new String[l.size()]);
        } else {
            List eArgs = actionXml.getChildren("arg", ns);
            args = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                args[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        this.setSqoopCommand(actionConf, args);
        return actionConf;
    }

    private void setSqoopCommand(Configuration conf, String[] args) {
        MapReduceMain.setStrings((Configuration)conf, (String)SQOOP_ARGS, (String[])args);
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        super.end(context, action);
        JobClient jobClient = null;
        boolean exception = false;
        try {
            if (action.getStatus() == WorkflowAction.Status.OK) {
                Element actionXml = XmlUtils.parseXml(action.getConf());
                JobConf jobConf = this.createBaseHadoopConf(context, actionXml);
                jobClient = this.createJobClient(context, jobConf);
                Counters counters = null;
                String externalIds = action.getExternalChildIDs();
                if (externalIds != null && !externalIds.trim().isEmpty()) {
                    String[] jobIds;
                    for (String jobId : jobIds = externalIds.split(",")) {
                        RunningJob runningJob = jobClient.getJob(JobID.forName((String)jobId));
                        if (runningJob == null) {
                            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "SQOOP001", "Unknown hadoop job [{0}] associated with action [{1}].  Failing this action!", action.getExternalId(), action.getId());
                        }
                        Counters taskCounters = runningJob.getCounters();
                        if (taskCounters != null) {
                            if (counters == null) {
                                counters = taskCounters;
                                continue;
                            }
                            counters.incrAllCounters(taskCounters);
                            continue;
                        }
                        XLog.getLog(this.getClass()).warn("Could not find Hadoop Counters for job: [{0}]", jobId);
                    }
                }
                if (counters != null) {
                    MRStats stats = new MRStats(counters);
                    String statsJsonString = stats.toJSON();
                    context.setVar("hadoop.counters", statsJsonString);
                    if (Boolean.parseBoolean(this.evaluateConfigurationProperty(actionXml, OOZIE_ACTION_EXTERNAL_STATS_WRITE, "true")) && statsJsonString.getBytes().length <= SqoopActionExecutor.getMaxExternalStatsSize()) {
                        context.setExecutionStats(statsJsonString);
                        this.LOG.debug("Printing stats for sqoop action as a JSON string : [{0}]", statsJsonString);
                    }
                } else {
                    context.setVar("hadoop.counters", "");
                    XLog.getLog(this.getClass()).warn("Can't find any associated Hadoop job counters");
                }
            }
        }
        catch (Exception ex) {
            exception = true;
            throw this.convertException(ex);
        }
        finally {
            if (jobClient != null) {
                try {
                    jobClient.close();
                }
                catch (Exception e) {
                    if (exception) {
                        this.LOG.error((Object)"JobClient error: ", e);
                    }
                    throw this.convertException(e);
                }
            }
        }
    }

    private String evaluateConfigurationProperty(Element actionConf, String key, String defaultValue) throws ActionExecutorException {
        try {
            Namespace ns;
            Element e;
            if (actionConf != null && (e = actionConf.getChild("configuration", ns = actionConf.getNamespace())) != null) {
                String strConf = XmlUtils.prettyPrint(e).toString();
                XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
                return inlineConf.get(key, defaultValue);
            }
            return defaultValue;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "sqoop";
    }
}

