/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.vfs.model;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseEntity;
import org.pentaho.di.plugins.fileopensave.api.providers.File;

public class VFSFile
extends BaseEntity
implements File {
    public static String TYPE = "file";
    private String connection;

    public String getType() {
        return TYPE;
    }

    public String getProvider() {
        return "vfs";
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public static VFSFile create(String parent, FileObject fileObject, String connection) {
        VFSFile vfsFile = new VFSFile();
        vfsFile.setName(fileObject.getName().getBaseName());
        vfsFile.setPath(fileObject.getName().getFriendlyURI());
        vfsFile.setParent(parent);
        vfsFile.setConnection(connection);
        vfsFile.setRoot("VFS Connections");
        vfsFile.setCanEdit(true);
        try {
            vfsFile.setDate(new Date(fileObject.getContent().getLastModifiedTime()));
        }
        catch (FileSystemException ignored) {
            vfsFile.setDate(new Date());
        }
        return vfsFile;
    }

    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getConnection(), this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFSFile)) {
            return false;
        }
        VFSFile compare = (VFSFile)((Object)obj);
        return compare.getProvider().equals(this.getProvider()) && compare.getConnection().equals(this.getConnection()) && (compare.getPath() == null && this.getPath() == null || compare.getPath().equals(this.getPath()));
    }
}

