/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.providers.local;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.plugins.fileopensave.api.providers.BaseFileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileExistsException;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalDirectory;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalFile;
import org.pentaho.di.plugins.fileopensave.providers.local.model.LocalTree;

public class LocalFileProvider
extends BaseFileProvider<LocalFile> {
    public static final String NAME = "Local";
    public static final String TYPE = "local";

    public Class<LocalFile> getFileClass() {
        return LocalFile.class;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public Tree getTree() {
        LocalTree localTree = new LocalTree(NAME);
        String home = System.getProperty("user.home");
        String user = System.getProperty("user.dir");
        LocalFile localFile = new LocalFile();
        localFile.setPath("/");
        localTree.setFiles(this.getFiles(localFile, (String)null));
        return localTree;
    }

    public List<LocalFile> getFiles(LocalFile file, String filters) {
        ArrayList<LocalFile> files = new ArrayList<LocalFile>();
        try {
            Files.list(Paths.get(file.getPath(), new String[0])).forEach(path -> {
                String name = path.getFileName().toString();
                try {
                    if (Files.isDirectory(path, new LinkOption[0]) && !Files.isHidden(path)) {
                        files.add(LocalDirectory.create(file.getPath(), path));
                    } else if (!Files.isHidden(path) && Utils.matches((String)name, (String)filters)) {
                        files.add(LocalFile.create(file.getPath(), path));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }

    public boolean isAvailable() {
        return true;
    }

    public List<LocalFile> delete(List<LocalFile> files) {
        ArrayList<LocalFile> deletedFiles = new ArrayList<LocalFile>();
        for (LocalFile file : files) {
            try {
                Files.delete(Paths.get(file.getPath(), new String[0]));
                deletedFiles.add(file);
            }
            catch (IOException iOException) {}
        }
        return deletedFiles;
    }

    public LocalFile add(LocalFile folder) throws FileException {
        Path folderPath = Paths.get(folder.getPath(), new String[0]);
        if (Files.exists(folderPath, new LinkOption[0])) {
            throw new FileExistsException();
        }
        try {
            Path newPath = Files.createDirectories(Paths.get(folder.getPath(), new String[0]), new FileAttribute[0]);
            LocalDirectory localDirectory = new LocalDirectory();
            localDirectory.setName(newPath.getFileName().toString());
            localDirectory.setPath(newPath.getFileName().toString());
            localDirectory.setDate(new Date(Files.getLastModifiedTime(newPath, new LinkOption[0]).toMillis()));
            localDirectory.setRoot(NAME);
            localDirectory.setCanAddChildren(true);
            localDirectory.setCanEdit(true);
            return localDirectory;
        }
        catch (IOException e) {
            return null;
        }
    }

    public LocalFile rename(LocalFile file, String newPath, boolean overwrite) throws FileException {
        return this.doMove(file.getPath(), newPath, overwrite);
    }

    public LocalFile move(LocalFile file, String toPath, boolean overwrite) throws FileException {
        return this.doMove(file.getPath(), toPath, overwrite);
    }

    private LocalFile doMove(String path, String newPath, Boolean overwrite) throws FileException {
        try {
            Path movePath = overwrite != false ? Files.move(Paths.get(path, new String[0]), Paths.get(newPath, new String[0]), StandardCopyOption.REPLACE_EXISTING) : Files.move(Paths.get(path, new String[0]), Paths.get(newPath, new String[0]), new CopyOption[0]);
            if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
                return LocalDirectory.create(movePath.getParent().toString(), movePath);
            }
            return LocalFile.create(movePath.getParent().toString(), movePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public LocalFile copy(LocalFile file, String toPath, boolean overwrite) throws FileException {
        try {
            Path newPath = Files.copy(Paths.get(file.getPath(), new String[0]), Paths.get(toPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            if (Files.isDirectory(newPath, new LinkOption[0])) {
                return LocalDirectory.create(newPath.getParent().toString(), newPath);
            }
            return LocalFile.create(newPath.getParent().toString(), newPath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean fileExists(LocalFile dir, String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public InputStream readFile(LocalFile file) {
        try {
            return new BufferedInputStream(new FileInputStream(new File(file.getPath())));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public LocalFile writeFile(InputStream inputStream, LocalFile destDir, String path, boolean overwrite) throws FileException {
        try {
            Files.copy(inputStream, Paths.get(path, new String[0]), new CopyOption[0]);
            return LocalFile.create(destDir.getPath(), Paths.get(path, new String[0]));
        }
        catch (FileAlreadyExistsException e) {
            throw new FileExistsException();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isSame(org.pentaho.di.plugins.fileopensave.api.providers.File file1, org.pentaho.di.plugins.fileopensave.api.providers.File file2) {
        return file1.getProvider().equals(file2.getProvider());
    }

    public String getNewName(LocalFile destDir, String newPath) {
        String extension = Utils.getExtension((String)newPath);
        String parent = Utils.getParent((String)newPath);
        String name = Utils.getName((String)newPath).replace("." + extension, "");
        int i = 1;
        String testName = newPath;
        while (Files.exists(Paths.get(testName, new String[0]), new LinkOption[0])) {
            testName = Utils.isValidExtension((String)extension) ? parent + name + " " + i + "." + extension : newPath + " " + i;
            ++i;
        }
        return testName;
    }

    public LocalFile getParent(LocalFile file) {
        return null;
    }
}

