/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.extension;

import java.util.function.Supplier;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.plugins.fileopensave.controllers.RepositoryBrowserController;
import org.pentaho.di.plugins.fileopensave.dialog.FileOpenSaveDialog;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.FileDialogOperation;
import org.pentaho.di.ui.spoon.Spoon;

@ExtensionPoint(id="FileOpenSaveNewExtensionPoint", extensionPointId="SpoonOpenSaveNew", description="Open the new file browser")
public class FileOpenSaveExtensionPoint
implements ExtensionPointInterface {
    private static final String TRANSFORMATION = "transformation";
    private static final String REPOSITORY = "repository";
    private static final int WIDTH = Const.isOSX() || Const.isLinux() ? 930 : 947;
    private static final int HEIGHT = Const.isOSX() || Const.isLinux() ? 618 : 626;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        FileDialogOperation fileDialogOperation = (FileDialogOperation)o;
        FileOpenSaveDialog repositoryOpenSaveDialog = new FileOpenSaveDialog(this.spoonSupplier.get().getShell(), WIDTH, HEIGHT);
        String path = fileDialogOperation.getPath() != null ? fileDialogOperation.getPath() : fileDialogOperation.getStartDir();
        String connection = fileDialogOperation.getConnection();
        String provider = fileDialogOperation.getProvider();
        String command = fileDialogOperation.getCommand();
        String title = fileDialogOperation.getTitle();
        String filter = fileDialogOperation.getFilter();
        String origin = fileDialogOperation.getOrigin();
        String filename = fileDialogOperation.getFilename();
        String type = fileDialogOperation.getFileType();
        if (provider == null) {
            provider = connection != null ? "vfs" : (this.spoonSupplier.get().rep != null ? REPOSITORY : "local");
        }
        repositoryOpenSaveDialog.open(path, connection, provider, command, title, filter, origin, filename, type);
        if (repositoryOpenSaveDialog.getProvider() != null && repositoryOpenSaveDialog.getProvider().equalsIgnoreCase(REPOSITORY)) {
            RepositoryObject repositoryObject = new RepositoryObject();
            repositoryObject.setObjectId(repositoryOpenSaveDialog::getObjectId);
            repositoryObject.setName(repositoryOpenSaveDialog.getName());
            repositoryObject.setRepositoryDirectory(this.getRepository().findDirectory(repositoryOpenSaveDialog.getParentPath()));
            if (repositoryOpenSaveDialog.getType() != null) {
                repositoryObject.setObjectType(repositoryOpenSaveDialog.getType().equals(TRANSFORMATION) ? RepositoryObjectType.TRANSFORMATION : RepositoryObjectType.JOB);
            }
            fileDialogOperation.setRepositoryObject((RepositoryObjectInterface)repositoryObject);
            fileDialogOperation.setProvider(repositoryOpenSaveDialog.getProvider());
        } else {
            if (command.equals(FileDialogOperation.OPEN)) {
                fileDialogOperation.setPath(repositoryOpenSaveDialog.getPath());
            } else {
                fileDialogOperation.setPath(repositoryOpenSaveDialog.getParentPath());
            }
            fileDialogOperation.setFilename(repositoryOpenSaveDialog.getName());
            fileDialogOperation.setConnection(repositoryOpenSaveDialog.getConnection());
            fileDialogOperation.setProvider(repositoryOpenSaveDialog.getProvider());
        }
    }

    private Repository getRepository() {
        return RepositoryBrowserController.repository != null ? RepositoryBrowserController.repository : this.spoonSupplier.get().getRepository();
    }
}

