/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.controllers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Result;
import org.pentaho.di.plugins.fileopensave.api.providers.Tree;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileExistsException;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.InvalidFileProviderException;
import org.pentaho.di.plugins.fileopensave.cache.FileCache;

public class FileController {
    protected final FileCache fileCache;
    private final List<FileProvider> fileProviders;

    public FileController(FileCache fileCache, List<FileProvider> fileProviders) {
        this.fileCache = fileCache;
        this.fileProviders = fileProviders;
    }

    public boolean clearCache(File file) {
        return this.fileCache.clear(file);
    }

    public FileProvider getFileProvider(String provider) throws InvalidFileProviderException {
        return this.fileProviders.stream().filter(fileProvider1 -> fileProvider1.getType().equalsIgnoreCase(provider) && fileProvider1.isAvailable()).findFirst().orElseThrow(InvalidFileProviderException::new);
    }

    public List<Tree> load() {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (FileProvider fileProvider : this.fileProviders) {
            if (!fileProvider.isAvailable()) continue;
            trees.add(fileProvider.getTree());
        }
        return trees;
    }

    public List<File> getFiles(File file, String filters, Boolean useCache) {
        try {
            FileProvider fileProvider = this.getFileProvider(file.getProvider());
            if (this.fileCache.containsKey(file) && useCache.booleanValue()) {
                return this.fileCache.getFiles(file);
            }
            List files = fileProvider.getFiles(file, filters);
            this.fileCache.setFiles(file, files);
            return files;
        }
        catch (InvalidFileProviderException e) {
            return Collections.emptyList();
        }
    }

    public Boolean fileExists(File dir, String path) {
        try {
            FileProvider fileProvider = this.getFileProvider(dir.getProvider());
            return fileProvider.fileExists(dir, path);
        }
        catch (FileException | InvalidFileProviderException e) {
            return null;
        }
    }

    public Result getNewName(File destDir, String newPath) {
        try {
            FileProvider fileProvider = this.getFileProvider(destDir.getProvider());
            return Result.success((String)"", (Object)fileProvider.getNewName(destDir, newPath));
        }
        catch (FileException | InvalidFileProviderException e) {
            return null;
        }
    }

    public Result delete(List<File> files) {
        try {
            FileProvider fileProvider = this.getFileProvider(files.get(0).getProvider());
            List deletedFiles = fileProvider.delete(files);
            for (File file : deletedFiles) {
                this.fileCache.removeFile(fileProvider.getParent(file), file);
            }
            return Result.success((String)"", (Object)deletedFiles);
        }
        catch (FileException | InvalidFileProviderException e) {
            return null;
        }
    }

    public Result add(File folder) {
        try {
            FileProvider fileProvider = this.getFileProvider(folder.getProvider());
            File newFile = fileProvider.add(folder);
            if (newFile != null) {
                this.fileCache.addFile(fileProvider.getParent(folder), newFile);
            }
            return Result.success((String)"", (Object)newFile);
        }
        catch (FileExistsException fee) {
            return Result.fileCollision((String)"", (Object)folder);
        }
        catch (FileException | InvalidFileProviderException fe) {
            return Result.error((String)"", (Object)folder);
        }
    }

    public Result rename(File file, String newPath, boolean overwrite) {
        try {
            FileProvider fileProvider = this.getFileProvider(file.getProvider());
            File newFile = fileProvider.rename(file, newPath, overwrite);
            if (newFile != null) {
                this.fileCache.move(fileProvider.getParent(file), file, fileProvider.getParent(newFile), newFile);
            }
            return Result.success((String)"", (Object)newFile);
        }
        catch (FileException | InvalidFileProviderException e) {
            return null;
        }
    }

    public Result moveFile(File file, File destDir, String newPath, boolean overwrite) {
        try {
            FileProvider fileProvider = this.getFileProvider(file.getProvider());
            File newFile = fileProvider.isSame(file, destDir) ? fileProvider.move(file, newPath, overwrite) : this.moveBetweenProviders(file, destDir, newPath, overwrite);
            if (newFile != null) {
                FileProvider newFileProvider = this.getFileProvider(newFile.getProvider());
                this.fileCache.move(fileProvider.getParent(file), file, newFileProvider.getParent(newFile), newFile);
                return Result.success((String)"Move file complete", (Object)newFile);
            }
        }
        catch (FileException | InvalidFileProviderException e) {
            return Result.error((String)"Unable to move file", (Object)file);
        }
        return Result.error((String)"Unable to move file", (Object)file);
    }

    public Result copyFile(File file, File destDir, String path, Boolean overwrite) {
        try {
            FileProvider fileProvider = this.getFileProvider(file.getProvider());
            File newFile = fileProvider.isSame(file, destDir) ? fileProvider.copy(file, path, overwrite.booleanValue()) : this.copyFileBetweenProviders(file, destDir, path, overwrite);
            if (newFile != null) {
                FileProvider newFileProvider = this.getFileProvider(newFile.getProvider());
                this.fileCache.addFile(newFileProvider.getParent(newFile), newFile);
                return Result.success((String)"Copy file complete", (Object)newFile);
            }
        }
        catch (FileException | InvalidFileProviderException e) {
            return Result.error((String)"Unable to copy file", (Object)file);
        }
        return Result.error((String)"Unable to copy file", (Object)file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File copyFileBetweenProviders(File file, File destDir, String path, boolean overwrite) {
        try {
            FileProvider fromFileProvider = this.getFileProvider(file.getProvider());
            FileProvider toFileProvider = this.getFileProvider(destDir.getProvider());
            path = toFileProvider.sanitizeName(destDir, path);
            try (InputStream inputStream = fromFileProvider.readFile(file);){
                File file2 = toFileProvider.writeFile(inputStream, destDir, path, overwrite);
                return file2;
            }
            catch (IOException e) {
                return null;
            }
        }
        catch (FileException | InvalidFileProviderException throwable6) {
            return null;
        }
    }

    public File moveBetweenProviders(File file, File destDir, String path, boolean overwrite) {
        File newFile = this.copyFileBetweenProviders(file, destDir, path, overwrite);
        if (newFile != null) {
            this.delete(Collections.singletonList(file));
        }
        return newFile;
    }
}

