/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v3.sourcegen;

import ca.uhn.hl7v3.sourcegen.AttributeDefinition;
import ca.uhn.hl7v3.sourcegen.CMPAttributeGenerator;
import ca.uhn.hl7v3.sourcegen.ClassDefinition;
import ca.uhn.hl7v3.sourcegen.SourceGenerator;

public class CMPClassGenerator {
    CMPAttributeGenerator attGen = new CMPAttributeGenerator();

    public String makeRemoteCode(ClassDefinition cls) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMPackage());
        code.append("; \r\n\r\n");
        code.append("import ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append(".*; \r\n");
        code.append("import java.rmi.RemoteException; \r\n");
        code.append("import javax.ejb.*; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment(cls.getDescription(), 0));
        code.append("public interface ");
        code.append(cls.getName());
        code.append(" extends ");
        if (cls.getSuperClass() == null) {
            code.append("EJBObject");
        } else {
            code.append(cls.getSuperClass());
        }
        code.append(" { \r\n\r\n");
        AttributeDefinition[] atts = cls.getAttributes();
        int i = 0;
        while (i < atts.length) {
            code.append(this.attGen.makeRemoteCode(atts[i]));
            code.append("\r\n");
            ++i;
        }
        code.append("}\r\n");
        return code.toString();
    }

    public String makeHomeCode(ClassDefinition cls) {
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMPackage());
        code.append("; \r\n\r\n");
        code.append("import javax.ejb.*; \r\n");
        code.append("import java.rmi.RemoteException; \r\n");
        code.append("\r\n");
        code.append("/** Home interface for the RIM '");
        code.append(cls.getName());
        code.append("' Entity Bean. */ \r\n");
        code.append("public interface ");
        code.append(cls.getName());
        code.append("Home extends EJBHome { \r\n");
        code.append("    public ");
        code.append(cls.getName());
        code.append(" create(String UID) throws CreateException, RemoteException; \r\n");
        code.append("    public ");
        code.append(cls.getName());
        code.append(" findByPrimaryKey(String UID) throws FinderException, RemoteException; \r\n");
        code.append("} \r\n");
        return code.toString();
    }

    public String makeBeanCode(ClassDefinition cls) {
        AttributeDefinition[] atts = cls.getAttributes();
        StringBuffer code = new StringBuffer();
        code.append("package ");
        code.append(SourceGenerator.getRIMPackage());
        code.append("; \r\n\r\n");
        code.append("import javax.ejb.*; \r\n");
        code.append("import java.rmi.RemoteException; \r\n");
        code.append("import ");
        code.append(SourceGenerator.getRIMDataTypePackage());
        code.append(".*; \r\n\r\n");
        code.append(SourceGenerator.makeJavaDocComment("Container-Managed Entity Bean for the RIM class '" + cls.getName() + "'. " + cls.getDescription(), 0));
        code.append("public class ");
        code.append(cls.getName());
        code.append("Bean extends ");
        if (cls.getSuperClass() == null) {
            code.append("RIMClass");
        } else {
            code.append(cls.getSuperClass());
            code.append("Bean");
        }
        code.append(" { \r\n\r\n");
        int i = 0;
        while (i < atts.length) {
            code.append(this.attGen.makeBeanAttribute(atts[i]));
            ++i;
        }
        code.append("\r\n");
        i = 0;
        while (i < atts.length) {
            code.append(this.attGen.makeBeanCode(atts[i]));
            code.append("\r\n");
            ++i;
        }
        code.append("} \r\n");
        return code.toString();
    }

    public static void main(String[] args) {
        ClassDefinition cls = new ClassDefinition();
        cls.setDescription("Entities are physical things or organizations and groupings of physical things. A physical thing is anything that has extent in space, and has mass. This hierarchy encompasses human beings, organizations, living organisms, devices, pharmaceutical substances, etc. This does not include events/acts/actions, the definition of things, the roles that things can play (e.g. patient, provider), nor the relationships among things.");
        cls.setIsAbstract(false);
        cls.setName("Entity");
        AttributeDefinition[] atts = new AttributeDefinition[2];
        atts[0] = new AttributeDefinition();
        atts[0].setDataType("CE");
        atts[0].setName("cd");
        atts[0].setDescription("This is the main classifying attribute of the Entity class and all of its subclasses.  This code indicates what kind of Entity is meant using a code from one of several coding systems depending on the class of entities, such as living subjects (typed by animal and plant taxonomies), chemical substance (e.g., IUPAC code), organizations, insurance company, government agency, hospital, park, lake, syringe, etc. Note that the entity type code may be so fine grained that some types may only have one known instance.  Types with an extension of one instance are very similar to names. An example is the CDC vaccine manufacturer code, which is modeled as a concept vocabulary, when in fact each concept refers to only one instance. However, type codes SHOULD NOT normally be so fine grained as of overlap with instance identification.");
        atts[1] = new AttributeDefinition();
        atts[1].setDataType("CE");
        atts[1].setName("class_cd");
        atts[1].setDescription("A code specifying on a high, technical, and tightly controlled level the kind of entity. This code is similar in nature as the names of the classes derived from entity in a refined message information model (R-MIM.)");
        cls.setAttributes(atts);
        CMPClassGenerator cgen = new CMPClassGenerator();
        System.out.println(cgen.makeRemoteCode(cls));
        System.out.println(cgen.makeBeanCode(cls));
        System.out.println(cgen.makeHomeCode(cls));
    }
}

