/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.format;

import java.util.ArrayList;

public class AvroSpec {
    public static final String TYPE_RECORD = "record";
    public static final String DOC = "doc";
    public static final String FIELDS_NODE = "fields";
    public static final String NAMESPACE_NODE = "namespace";
    public static final String NAME_NODE = "name";
    public static final String TYPE_NODE = "type";
    public static final String DEFAULT_NODE = "default";
    public static final String LOGICAL_TYPE = "logicalType";
    public static final String DECIMAL_PRECISION = "precision";
    public static final String DECIMAL_SCALE = "scale";
    public static final int DEFAULT_DECIMAL_PRECISION = 10;
    public static final int DEFAULT_DECIMAL_SCALE = 0;

    public static enum DataType {
        NULL(0, true, "null", null, "Null"),
        BOOLEAN(1, true, "boolean", null, "Boolean"),
        INTEGER(2, true, "int", null, "Integer"),
        LONG(3, true, "long", null, "Long"),
        FLOAT(4, true, "float", null, "Float"),
        DOUBLE(5, true, "double", null, "Double"),
        BYTES(6, true, "bytes", null, "Bytes"),
        STRING(7, true, "string", null, "String"),
        RECORD(8, false, "record", null, "Record"),
        ENUM(9, false, "enum", null, "Enum"),
        ARRAY(10, false, "array", null, "Array"),
        MAP(11, false, "map", null, "Map"),
        FIXED(12, false, "fixed", null, "Fixed"),
        DECIMAL(13, false, "bytes", "decimal", "Decimal"),
        DATE(14, false, "int", "date", "Date"),
        TIME_MILLIS(15, false, "int", "time-millis", "Time"),
        TIME_MICROS(16, false, "long", "time-micros", "Time In Microseconds"),
        TIMESTAMP_MILLIS(17, false, "long", "timestamp-millis", "Timestamp"),
        TIMESTAMP_MICROS(18, false, "long", "timestamp-micros", "Timestamp In Microseconds"),
        DURATION(19, false, "fixed", "duration", "Duration"),
        DECIMAL_FIXED(20, false, "fixed", "decimal", "Decimal Fixed");

        private final int id;
        private final boolean isPrimitive;
        private final String baseType;
        private final String logicalType;
        private final String name;
        private static final ArrayList<DataType> enumValues;

        private DataType(int id, boolean isPrimitiveType, String baseType, String logicalType, String name) {
            this.id = id;
            this.isPrimitive = isPrimitiveType;
            this.baseType = baseType;
            this.logicalType = logicalType;
            this.name = name;
        }

        public static DataType getDataType(int id) {
            return enumValues.get(id);
        }

        public int getId() {
            return this.id;
        }

        public boolean isPrimitiveType() {
            return this.isPrimitive;
        }

        public boolean isComplexType() {
            return !this.isPrimitive && this.logicalType == null;
        }

        public boolean isLogicalType() {
            return this.logicalType != null;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public String getLogicalType() {
            return this.logicalType;
        }

        public String getType() {
            return this.isLogicalType() ? this.logicalType : this.baseType;
        }

        public String getName() {
            return this.name;
        }

        static {
            enumValues = new ArrayList();
            for (DataType dataType : DataType.values()) {
                enumValues.add(dataType.getId(), dataType);
            }
        }
    }
}

