/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.spark;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WinProcess {
    private int pid;
    private WinNT.HANDLE handle;
    private static final int PROCESS_QUERY_INFORMATION = 1024;
    private static final int PROCESS_SUSPEND_RESUME = 2048;
    private static final int PROCESS_TERMINATE = 1;
    private static final int PROCESS_SYNCHRONIZE = 0x100000;

    WinProcess(int pid) throws IOException {
        this.handle = Kernel32.INSTANCE.OpenProcess(0x100C01, false, pid);
        if (this.handle == null) {
            throw new IOException("OpenProcess failed: " + Kernel32Util.formatMessageFromLastErrorCode((int)Kernel32.INSTANCE.GetLastError()));
        }
        this.pid = pid;
    }

    public void terminate() {
        Kernel32.INSTANCE.TerminateProcess(this.handle, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WinProcess> getChildProcesses() throws IOException {
        ArrayList<WinProcess> processList = new ArrayList<WinProcess>();
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        pidList.add(this.pid);
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary(Kernel32.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = kernel32.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (kernel32.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                int parentPID = processEntry.th32ParentProcessID.intValue();
                if (!pidList.contains(parentPID)) continue;
                int childPID = processEntry.th32ProcessID.intValue();
                pidList.add(childPID);
                processList.add(new WinProcess(childPID));
            }
        }
        finally {
            kernel32.CloseHandle(snapshot);
        }
        return processList;
    }

    public String killChildProcesses() throws IOException {
        List<WinProcess> children;
        StringBuilder builder = new StringBuilder();
        if (Platform.isWindows() && !(children = this.getChildProcesses()).isEmpty()) {
            for (WinProcess child : children) {
                builder.append(child.getWinProcessPID() + " ");
                child.terminate();
            }
        }
        return builder.toString().trim();
    }

    public static int getPID(Process proc) {
        int pid = -1;
        try {
            if (proc.getClass().getName().equals("java.lang.Win32Process") || proc.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field f = proc.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(proc);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handl));
                pid = kernel.GetProcessId(handle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pid;
    }

    public int getWinProcessPID() {
        return this.pid;
    }
}

