/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.lifecycle;

import java.util.function.Supplier;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ConnectionProvider;
import org.pentaho.di.connections.LookupFilter;
import org.pentaho.di.connections.ui.tree.ConnectionFolderProvider;
import org.pentaho.di.connections.vfs.VFSLookupFilter;
import org.pentaho.di.connections.vfs.providers.other.OtherConnectionDetailsProvider;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

@LifecyclePlugin(id="VFSConnectionLifecycleListener")
public class ConnectionLifecycleListener
implements LifecycleListener {
    private static final String OTHER = "other";
    private static final String FTP_SCHEMA = "ftp";
    private static final String HTTP_SCHEMA = "http";
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;
    private MetastoreLocator metastoreLocator;

    public ConnectionLifecycleListener(MetastoreLocator metastoreLocator) {
        this.metastoreLocator = metastoreLocator;
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        Spoon spoon = this.spoonSupplier.get();
        if (spoon != null) {
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_TRANSFORMATIONS, (TreeFolderProvider)new ConnectionFolderProvider(this.metastoreLocator));
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_JOBS, (TreeFolderProvider)new ConnectionFolderProvider(this.metastoreLocator));
        }
        this.connectionManagerSupplier.get().addConnectionProvider(OTHER, (ConnectionProvider)new OtherConnectionDetailsProvider());
        VFSLookupFilter vfsLookupFilter = new VFSLookupFilter();
        vfsLookupFilter.addKeyLookup(FTP_SCHEMA, OTHER);
        vfsLookupFilter.addKeyLookup(HTTP_SCHEMA, OTHER);
        this.connectionManagerSupplier.get().addLookupFilter((LookupFilter)vfsLookupFilter);
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
    }
}

