/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.ui.endpoints;

import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.ui.dialog.ConnectionDialog;
import org.pentaho.di.connections.ui.tree.ConnectionFolderProvider;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class ConnectionEndpoints {
    private static Class<?> PKG = ConnectionDialog.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private ConnectionManager connectionManager = ConnectionManager.getInstance();
    public static final String HELP_URL = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Help", (String[])new String[0]));

    public ConnectionEndpoints(MetastoreLocator metastoreLocator) {
        this.connectionManager.setMetastoreSupplier(() -> ((MetastoreLocator)metastoreLocator).getMetastore());
    }

    @GET
    @Path(value="/types")
    @Produces(value={"application/json"})
    public Response getTypes() {
        return Response.ok((Object)this.connectionManager.getItems()).build();
    }

    @GET
    @Path(value="/connection/{scheme}")
    @Produces(value={"application/json"})
    public Response getFields(@PathParam(value="scheme") String scheme) {
        return Response.ok((Object)this.connectionManager.createConnectionDetails(scheme)).build();
    }

    @GET
    @Path(value="/connection")
    @Consumes(value={"application/json"})
    public Response getConnection(@QueryParam(value="name") String name) {
        return Response.ok((Object)this.connectionManager.getConnectionDetails(name)).build();
    }

    @GET
    @Path(value="/connection/exists")
    @Consumes(value={"application/json"})
    public Response getConnectionExists(@QueryParam(value="name") String name) {
        return Response.ok((Object)String.valueOf(this.connectionManager.exists(name))).build();
    }

    @PUT
    @Path(value="/connection")
    @Consumes(value={"application/json"})
    public Response createConnection(ConnectionDetails connectionDetails, @QueryParam(value="name") String name) {
        boolean saved = this.connectionManager.save(connectionDetails);
        if (saved) {
            this.connectionManager.delete(name);
            this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> this.spoonSupplier.get().refreshTree(ConnectionFolderProvider.STRING_VFS_CONNECTIONS));
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/test")
    @Consumes(value={"application/json"})
    public Response testConnection(ConnectionDetails connectionDetails) {
        boolean valid = this.connectionManager.test(connectionDetails);
        if (valid) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/help")
    public Response help() {
        this.spoonSupplier.get().getShell().getDisplay().asyncExec(() -> HelpUtils.openHelpDialog((Shell)this.spoonSupplier.get().getDisplay().getActiveShell(), (String)BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Title", (String[])new String[0]), (String)HELP_URL, (String)BaseMessages.getString(PKG, (String)"ConnectionDialog.help.dialog.Header", (String[])new String[0])));
        return Response.ok().build();
    }
}

