/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.plugins.common.ui.StateChangeListener;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class NamedClusterComposite
extends Composite {
    private static final String NAMED_CLUSTER_DFS_SCHEME = "named.cluster.dfs.scheme.";
    private static Class<?> PKG = NamedClusterComposite.class;
    private PropsUI props;
    private GridData gridData = new GridData();
    private GridData numberGridData = new GridData();
    private GridData labelGridData = new GridData();
    private GridData userNameLabelGridData = new GridData();
    private GridData userNameGridData = new GridData();
    private GridData passwordLabelGridData = new GridData();
    private GridData passwordGridData = new GridData();
    private GridData portLabelGridData = new GridData();
    private static final int ONE_COLUMN = 1;
    private static final int TWO_COLUMNS = 2;
    private static final int TEXT_FLAGS = 18436;
    private static final int PASSWORD_FLAGS = 0x404804;
    private static final String KETTLE_HADOOP_CLUSTER_GATEWAY_CONNECTION = "KETTLE_HADOOP_CLUSTER_GATEWAY_CONNECTION";
    private Text nameOfNamedCluster;
    private Composite compositeSwitcher;
    private Composite gatewayComposite;
    private Composite noGatewayComposite;
    private Label jtHostLabel;
    private TextVar jtHostNameText;
    private Label jtPortLabel;
    private TextVar jtPortText;
    private Group hdfsGroup;
    private Label hdfsHostLabel;
    private TextVar hdfsHostText;
    private Label hdfsPortLabel;
    private TextVar hdfsPortText;
    private Label hdfsUsernameLabel;
    private TextVar hdfsUsernameText;
    private Label hdfsPasswordLabel;
    private TextVar hdfsPasswordText;
    private ArrayList<String> schemeValues = new ArrayList();
    private ArrayList<String> schemeNames = new ArrayList();
    private StateChangeListener stateChangeListener;

    public NamedClusterComposite(Composite parent, NamedCluster namedCluster, PropsUI props, NamedClusterService namedClusterService) {
        super(parent, 0);
        props.setLook((Control)this);
        this.props = props;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        this.setLayout((Layout)formLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.setLayoutData(fd);
        this.gridData.widthHint = 270;
        this.numberGridData.widthHint = 80;
        this.labelGridData.widthHint = 270;
        this.portLabelGridData.widthHint = 80;
        this.userNameLabelGridData.widthHint = 165;
        this.userNameGridData.widthHint = 165;
        this.passwordLabelGridData.widthHint = 185;
        this.passwordGridData.widthHint = 185;
        Composite confUI = this.createHeadOfNamedClusterDialog(this, namedCluster);
        Label topSeparator = new Label((Composite)this, 258);
        topSeparator.setLayoutData((Object)this.createFormDataAndAttachTopControl((Control)confUI));
        this.compositeSwitcher = new Composite((Composite)this, 0);
        this.compositeSwitcher.setLayoutData((Object)this.createFormDataAndAttachTopControl((Control)topSeparator));
        StackLayout compositeLayout = new StackLayout();
        this.compositeSwitcher.setLayout((Layout)compositeLayout);
        this.gatewayComposite = new Composite(this.compositeSwitcher, 0);
        props.setLook((Control)this.gatewayComposite);
        GridLayout gatewayCompositeLayout = new GridLayout(1, false);
        gatewayCompositeLayout.marginHeight = 0;
        gatewayCompositeLayout.marginWidth = 0;
        this.gatewayComposite.setLayout((Layout)gatewayCompositeLayout);
        this.gatewayComposite.setSize(this.gatewayComposite.computeSize(-1, -1));
        this.createGatewayGroup(this.gatewayComposite, namedCluster);
        this.noGatewayComposite = new Composite(this.compositeSwitcher, 0);
        props.setLook((Control)this.noGatewayComposite);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.noGatewayComposite.setLayout((Layout)gl);
        this.noGatewayComposite.setSize(this.noGatewayComposite.computeSize(-1, -1));
        this.createStorageGroup(this.noGatewayComposite, namedCluster, namedClusterService);
        this.createHdfsGroup(this.noGatewayComposite, namedCluster);
        this.createJobTrackerGroup(this.noGatewayComposite, namedCluster);
        this.createZooKeeperGroup(this.noGatewayComposite, namedCluster);
        this.createOozieGroup(this.noGatewayComposite, namedCluster);
        this.createKafkaGroup(this.noGatewayComposite, namedCluster);
        this.setHdfsAndJobTrackerState(namedCluster);
        compositeLayout.topControl = namedCluster.isUseGateway() ? this.gatewayComposite : this.noGatewayComposite;
        this.compositeSwitcher.layout();
        this.nameOfNamedCluster.forceFocus();
    }

    public void setStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    private FormData createFormDataAndAttachTopControl(Control topControl) {
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(topControl, 10);
        return fd;
    }

    private Composite createHeadOfNamedClusterDialog(Composite parentComposite, final NamedCluster namedCluster) {
        Composite mainRowComposite = new Composite(parentComposite, 0);
        GridLayout mainRowLayout = new GridLayout(1, false);
        mainRowLayout.marginWidth = 0;
        mainRowLayout.marginTop = -10;
        mainRowComposite.setLayout((Layout)mainRowLayout);
        this.props.setLook((Control)mainRowComposite);
        Composite nameUICluster = new Composite(mainRowComposite, 0);
        this.props.setLook((Control)nameUICluster);
        GridLayout nameUILayout = new GridLayout(1, false);
        nameUILayout.marginWidth = 0;
        nameUILayout.marginTop = 0;
        nameUICluster.setLayout((Layout)nameUILayout);
        this.createLabel(nameUICluster, BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.Name", (String[])new String[0]), this.labelGridData);
        this.nameOfNamedCluster = new Text(nameUICluster, 18436);
        this.nameOfNamedCluster.setText(String.valueOf(namedCluster.getName()));
        this.nameOfNamedCluster.setLayoutData((Object)this.gridData);
        this.props.setLook((Control)this.nameOfNamedCluster);
        this.nameOfNamedCluster.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                namedCluster.setName(NamedClusterComposite.this.nameOfNamedCluster.getText());
                NamedClusterComposite.this.stateChanged();
            }
        });
        if (this.shouldRenderGatewayCheckbox(namedCluster)) {
            Composite gatewayUIComposite = new Composite(mainRowComposite, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            gatewayUIComposite.setLayout((Layout)layout);
            this.props.setLook((Control)gatewayUIComposite);
            final Button gatewayButton = new Button(gatewayUIComposite, 32);
            gatewayButton.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.NamedCluster.GatewayCheckBoxTitle", (String[])new String[0]));
            this.props.setLook((Control)gatewayButton);
            gatewayButton.setSelection(namedCluster.isUseGateway());
            gatewayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    namedCluster.setUseGateway(gatewayButton.getSelection());
                    StackLayout layout = (StackLayout)NamedClusterComposite.this.compositeSwitcher.getLayout();
                    layout.topControl = namedCluster.isUseGateway() ? NamedClusterComposite.this.gatewayComposite : NamedClusterComposite.this.noGatewayComposite;
                    NamedClusterComposite.this.compositeSwitcher.layout();
                    NamedClusterComposite.this.stateChanged();
                }
            });
        }
        return mainRowComposite;
    }

    private Label createLabel(Composite parent, String text, GridData gd) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)gd);
        this.props.setLook((Control)label);
        return label;
    }

    private TextVar createTextVar(final NamedCluster c, Composite parent, String val, GridData gd, int flags, final Callback cb) {
        final TextVar textVar = new TextVar((VariableSpace)c, parent, flags);
        textVar.setText(StringUtils.isEmpty((String)val) ? "" : val);
        textVar.setLayoutData((Object)gd);
        this.props.setLook((Control)textVar);
        textVar.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                cb.invoke(c, textVar, textVar.getText());
            }
        });
        return textVar;
    }

    private Composite createGroup(Composite parent, String groupLabel) {
        Group group = new Group(parent, 0);
        group.setText(groupLabel);
        group.setLayout((Layout)new RowLayout(512));
        this.props.setLook((Control)group);
        GridData groupGridData = new GridData();
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalAlignment = 4;
        group.setLayoutData((Object)groupGridData);
        Composite pp = new Composite((Composite)group, 0);
        this.props.setLook((Control)pp);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = -10;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginTop = -10;
        gridLayout.marginBottom = -5;
        pp.setLayout((Layout)gridLayout);
        return pp;
    }

    private Composite createTwoColumnsContainer(Composite parentComposite) {
        Composite twoColumnsComposite = new Composite(parentComposite, 0);
        this.props.setLook((Control)twoColumnsComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        twoColumnsComposite.setLayout((Layout)gridLayout);
        return twoColumnsComposite;
    }

    private void createStorageGroup(Composite parentComposite, final NamedCluster cluster, NamedClusterService namedClusterService) {
        Map properties = namedClusterService.getProperties();
        for (String key : properties.keySet()) {
            if (!key.startsWith(NAMED_CLUSTER_DFS_SCHEME)) continue;
            this.schemeValues.add(key.substring(key.lastIndexOf(".") + 1));
            this.schemeNames.add((String)properties.get(key));
        }
        if (!this.schemeValues.contains(cluster.getStorageScheme())) {
            this.schemeValues.add(cluster.getStorageScheme());
            this.schemeNames.add(cluster.getStorageScheme());
        }
        Composite container = new Composite(parentComposite, 0);
        this.props.setLook((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 5;
        container.setLayout((Layout)gridLayout);
        this.createLabel(container, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Storage", (String[])new String[0]), this.labelGridData);
        final CCombo storageCombo = new CCombo(container, 2048);
        storageCombo.setItems(this.schemeNames.toArray(new String[this.schemeNames.size()]));
        storageCombo.select(this.schemeValues.indexOf(cluster.getStorageScheme()));
        this.props.setLook((Control)storageCombo);
        storageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int index = storageCombo.getSelectionIndex();
                if (index == -1) {
                    index = 0;
                }
                cluster.setStorageScheme((String)NamedClusterComposite.this.schemeValues.get(index));
                NamedClusterComposite.this.setHdfsAndJobTrackerState(cluster);
            }
        });
        storageCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String uiInputText = storageCombo.getText();
                if (NamedClusterComposite.this.schemeNames.contains(uiInputText)) {
                    int selectedIndex = NamedClusterComposite.this.schemeNames.indexOf(uiInputText);
                    cluster.setStorageScheme((String)NamedClusterComposite.this.schemeValues.get(selectedIndex));
                    storageCombo.select(selectedIndex);
                } else if (NamedClusterComposite.this.schemeValues.contains(uiInputText)) {
                    int selectedIndex = NamedClusterComposite.this.schemeValues.indexOf(uiInputText);
                    cluster.setStorageScheme((String)NamedClusterComposite.this.schemeValues.get(selectedIndex));
                    storageCombo.select(selectedIndex);
                } else {
                    NamedClusterComposite.this.schemeNames.add(uiInputText);
                    NamedClusterComposite.this.schemeValues.add(uiInputText);
                    storageCombo.setItems(NamedClusterComposite.this.schemeNames.toArray(new String[NamedClusterComposite.this.schemeNames.size()]));
                    cluster.setStorageScheme(uiInputText);
                }
                NamedClusterComposite.this.setHdfsAndJobTrackerState(cluster);
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void createHdfsGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.HDFS", (String[])new String[0]));
        this.hdfsGroup = (Group)pp.getParent();
        Composite hdfsRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(hdfsRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(hdfsRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.hdfsHostLabel = this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hdfsHostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsHost(value);
            }
        };
        this.hdfsHostText = this.createTextVar(c, hostUIComposite, c.getHdfsHost(), this.gridData, 18436, hdfsHostCB);
        this.hdfsPortLabel = this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback hdfsPortCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPort(value);
            }
        };
        this.hdfsPortText = this.createTextVar(c, portUIComposite, c.getHdfsPort(), this.numberGridData, 18436, hdfsPortCB);
        Composite hdfsCredentialsRowComposite = this.createTwoColumnsContainer(pp);
        Composite usernameUIComposite = new Composite(hdfsCredentialsRowComposite, 0);
        this.props.setLook((Control)usernameUIComposite);
        usernameUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite passwordUIComposite = new Composite(hdfsCredentialsRowComposite, 0);
        this.props.setLook((Control)passwordUIComposite);
        passwordUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.hdfsUsernameLabel = this.createLabel(usernameUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Username", (String[])new String[0]), this.userNameLabelGridData);
        Callback hdfsUsernameCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsUsername(value);
            }
        };
        this.hdfsUsernameText = this.createTextVar(c, usernameUIComposite, c.getHdfsUsername(), this.userNameGridData, 18436, hdfsUsernameCB);
        this.hdfsPasswordLabel = this.createLabel(passwordUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Password", (String[])new String[0]), this.passwordLabelGridData);
        Callback hdfsPasswordCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setHdfsPassword(value);
            }
        };
        this.hdfsPasswordText = this.createTextVar(c, passwordUIComposite, c.getHdfsPassword(), this.passwordGridData, 0x404804, hdfsPasswordCB);
    }

    private void createJobTrackerGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.JobTracker", (String[])new String[0]));
        Composite jobTrackerRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(jobTrackerRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(jobTrackerRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.jtHostLabel = this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerHost(value);
            }
        };
        this.jtHostNameText = this.createTextVar(c, hostUIComposite, c.getJobTrackerHost(), this.gridData, 18436, hostCB);
        this.jtPortLabel = this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setJobTrackerPort(value);
            }
        };
        this.jtPortText = this.createTextVar(c, portUIComposite, c.getJobTrackerPort(), this.numberGridData, 18436, portCB);
    }

    private void createZooKeeperGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.ZooKeeper", (String[])new String[0]));
        Composite zooKeeperRowComposite = this.createTwoColumnsContainer(pp);
        Composite hostUIComposite = new Composite(zooKeeperRowComposite, 0);
        this.props.setLook((Control)hostUIComposite);
        hostUIComposite.setLayout((Layout)new GridLayout(1, false));
        Composite portUIComposite = new Composite(zooKeeperRowComposite, 0);
        this.props.setLook((Control)portUIComposite);
        portUIComposite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(hostUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Hostname", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperHost(value);
            }
        };
        this.createTextVar(c, hostUIComposite, c.getZooKeeperHost(), this.gridData, 18436, hostCB);
        this.createLabel(portUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Port", (String[])new String[0]), this.portLabelGridData);
        Callback portCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setZooKeeperPort(value);
            }
        };
        this.createTextVar(c, portUIComposite, c.getZooKeeperPort(), this.numberGridData, 18436, portCB);
    }

    private void createOozieGroup(Composite parentComposite, NamedCluster namedCluster) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Oozie", (String[])new String[0]));
        Composite container = new Composite(pp, 0);
        this.props.setLook((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        container.setLayout((Layout)gridLayout);
        this.createLabel(container, BaseMessages.getString(PKG, (String)"NamedClusterDialog.URL", (String[])new String[0]), this.labelGridData);
        Callback hostCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setOozieUrl(value);
            }
        };
        this.createTextVar(namedCluster, container, namedCluster.getOozieUrl(), this.gridData, 18436, hostCB);
    }

    private void createGatewayGroup(Composite parentComposite, NamedCluster c) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Gateway", (String[])new String[0]));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        Composite gatewayUrlUIComposite = new Composite(pp, 0);
        this.props.setLook((Control)gatewayUrlUIComposite);
        gatewayUrlUIComposite.setLayout((Layout)gridLayout);
        this.createLabel(gatewayUrlUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.GatewayUrl", (String[])new String[0]), this.labelGridData);
        Callback gatewayUrlCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setGatewayUrl(value);
                NamedClusterComposite.this.stateChanged();
            }
        };
        GridData gd = new GridData();
        gd.widthHint = 365;
        this.createTextVar(c, gatewayUrlUIComposite, c.getGatewayUrl(), gd, 18436, gatewayUrlCB);
        Composite gatewayCredentialsRowComposite = this.createTwoColumnsContainer(pp);
        Composite usernameUIComposite = new Composite(gatewayCredentialsRowComposite, 0);
        this.props.setLook((Control)usernameUIComposite);
        GridLayout userNamelayout = new GridLayout(1, false);
        usernameUIComposite.setLayout((Layout)userNamelayout);
        Composite passwordUIComposite = new Composite(gatewayCredentialsRowComposite, 0);
        this.props.setLook((Control)passwordUIComposite);
        GridLayout passwordLayout = new GridLayout(1, false);
        passwordUIComposite.setLayout((Layout)passwordLayout);
        this.createLabel(usernameUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Username", (String[])new String[0]), this.userNameLabelGridData);
        Callback gatewayUsernameCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setGatewayUsername(value);
                NamedClusterComposite.this.stateChanged();
            }
        };
        this.createTextVar(c, usernameUIComposite, c.getGatewayUsername(), this.userNameGridData, 18436, gatewayUsernameCB);
        this.createLabel(passwordUIComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Password", (String[])new String[0]), this.passwordLabelGridData);
        Callback gatewayPasswordCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setGatewayPassword(value);
                NamedClusterComposite.this.stateChanged();
            }
        };
        this.createTextVar(c, passwordUIComposite, c.getGatewayPassword(), this.passwordGridData, 0x404804, gatewayPasswordCB);
    }

    private void createKafkaGroup(Composite parentComposite, NamedCluster namedCluster) {
        Composite pp = this.createGroup(parentComposite, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Kafka.GroupTitle", (String[])new String[0]));
        Composite container = new Composite(pp, 0);
        this.props.setLook((Control)container);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        container.setLayout((Layout)gridLayout);
        this.createLabel(container, BaseMessages.getString(PKG, (String)"NamedClusterDialog.Kafka.BootstrapServers.Label", (String[])new String[0]), this.labelGridData);
        Callback bootstrapServersCB = new Callback(){

            @Override
            public void invoke(NamedCluster nc, TextVar textVar, String value) {
                nc.setKafkaBootstrapServers(value);
            }
        };
        this.createTextVar(namedCluster, container, namedCluster.getKafkaBootstrapServers(), this.gridData, 18436, bootstrapServersCB);
    }

    private void setHdfsAndJobTrackerState(NamedCluster cluster) {
        boolean state = !cluster.isMapr();
        this.jtHostLabel.setEnabled(state);
        this.jtHostNameText.setEnabled(state);
        this.jtPortLabel.setEnabled(state);
        this.jtPortText.setEnabled(state);
        this.hdfsHostLabel.setEnabled(state);
        this.hdfsHostText.setEnabled(state);
        this.hdfsPortLabel.setEnabled(state);
        this.hdfsPortText.setEnabled(state);
        this.hdfsUsernameLabel.setEnabled(state);
        this.hdfsUsernameText.setEnabled(state);
        this.hdfsPasswordLabel.setEnabled(state);
        this.hdfsPasswordText.setEnabled(state);
        String storageName = cluster.getStorageScheme();
        if (!Utils.isEmpty(this.schemeNames) && !Utils.isEmpty(this.schemeValues)) {
            storageName = this.schemeNames.get(this.schemeValues.indexOf(storageName));
        }
        this.hdfsGroup.setText(storageName);
    }

    private boolean shouldRenderGatewayCheckbox(NamedCluster namedCluster) {
        return Boolean.valueOf(namedCluster.getVariable(KETTLE_HADOOP_CLUSTER_GATEWAY_CONNECTION));
    }

    private void stateChanged() {
        if (this.stateChangeListener != null) {
            this.stateChangeListener.stateModified();
        }
    }

    private static interface Callback {
        public void invoke(NamedCluster var1, TextVar var2, String var3);
    }
}

