/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDomainStatusMessage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.services.interfaces.IRDO;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IPluginDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IStatusMessageDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.responses.IterablePluginOperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.StringOperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.base.OperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.base.StatusMessageDTO;

@Path(value="services")
public class MarketplaceService {
    private IRDO RDO;
    private IPluginDTOMapper pluginDTOMapper;
    private IStatusMessageDTOMapper statusMessageDTOMapper;

    public MarketplaceService(IRDO rdo, IPluginDTOMapper pluginDTOMapper, IStatusMessageDTOMapper statusMessageDTOMapper) {
        this.RDO = rdo;
        this.pluginDTOMapper = pluginDTOMapper;
        this.statusMessageDTOMapper = statusMessageDTOMapper;
    }

    @GET
    @Path(value="/hello")
    @Produces(value={"application/json"})
    public StringOperationResultDTO hello() {
        StringOperationResultDTO result = new StringOperationResultDTO();
        result.string = "Hello World from Marketplace!";
        result.statusMessage.code = "OK_CODE";
        result.statusMessage.message = "OK_MESSAGE";
        return result;
    }

    @GET
    @Path(value="/plugins")
    @Produces(value={"application/json"})
    public IterablePluginOperationResultDTO getPlugins(@Context HttpServletResponse response) {
        ArrayList<IPlugin> plugins = new ArrayList<IPlugin>(this.RDO.getPluginService().getPlugins().values());
        Collections.sort(plugins, new Comparator<IPlugin>(){

            @Override
            public int compare(IPlugin plugin1, IPlugin plugin2) {
                return plugin1.getRank() - plugin2.getRank();
            }
        });
        IterablePluginOperationResultDTO result = new IterablePluginOperationResultDTO();
        result.plugins = this.pluginDTOMapper.toDTOs(plugins);
        result.statusMessage.code = "OK_CODE";
        result.statusMessage.message = "OK_MESSAGE";
        response.addHeader("Cache-Control", "no-cache, no-store");
        return result;
    }

    @POST
    @Path(value="/plugin/{pluginId}/{versionBranch}")
    @Produces(value={"application/json"})
    public OperationResultDTO installPlugin(@PathParam(value="pluginId") String pluginId, @PathParam(value="versionBranch") String versionBranch) {
        OperationResultDTO result = new OperationResultDTO();
        IDomainStatusMessage statusMessage = this.RDO.getPluginService().installPlugin(pluginId, versionBranch);
        result.statusMessage = (StatusMessageDTO)this.statusMessageDTOMapper.toDTO(statusMessage);
        return result;
    }

    @DELETE
    @Path(value="/plugin/{pluginId}")
    @Produces(value={"application/json"})
    public OperationResultDTO uninstallPlugin(@PathParam(value="pluginId") String pluginId) {
        OperationResultDTO result = new OperationResultDTO();
        IDomainStatusMessage statusMessage = this.RDO.getPluginService().uninstallPlugin(pluginId);
        result.statusMessage = (StatusMessageDTO)this.statusMessageDTOMapper.toDTO(statusMessage);
        return result;
    }
}

