/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.di.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class MenuHandler
extends AbstractXulEventHandler {
    public static final String MARKETPLACE_MENU_EVENT_HANDLER = "marketplaceMenuEventHandler";
    public static String WEB_CLIENT_PATH = "/marketplace/web/main.html";
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static Class<?> PKG = MenuHandler.class;
    private Spoon spoon;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Spoon getSpoon() {
        if (this.spoon == null) {
            return Spoon.getInstance();
        }
        return this.spoon;
    }

    public void setSpoon(Spoon spoon) {
        this.spoon = spoon;
    }

    public Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    protected Log getLogger() {
        return this.logger;
    }

    public MenuHandler() {
        this.setName(MARKETPLACE_MENU_EVENT_HANDLER);
    }

    public String getMarketplaceURL() {
        return "http://localhost:" + this.getOsgiServicePort() + WEB_CLIENT_PATH;
    }

    public String getMarketplaceTabLabel() {
        String tabLabel = "Marketplace";
        return tabLabel;
    }

    public void openMarketplace() {
        try {
            Spoon spoon = this.getSpoon();
            URL url = new URL(this.getMarketplaceURL());
            spoon.addSpoonBrowser(this.getMarketplaceTabLabel(), url.toString(), false);
        }
        catch (MalformedURLException e) {
            this.getLogger().error((Object)("Error on marketplace URL: " + WEB_CLIENT_PATH), (Throwable)e);
        }
    }
}

