/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

class PcmlStruct
extends PcmlDocNode {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5539999574454926624L;
    private static final String[] STRUCTATTRIBUTES = new String[]{"name", "usage", "count", "minvrm", "maxvrm", "offset", "offsetfrom", "outputsize"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 8;
    private int m_Count;
    private String m_CountId;
    private int m_Offset;
    private String m_OffsetId;
    private boolean m_OffsetfromFixed;
    private int m_Offsetfrom;
    private String m_OffsetfromId;
    private String m_Minvrm;
    private int m_MinvrmInt;
    private String m_Maxvrm;
    private int m_MaxvrmInt;
    private int m_Outputsize;
    private String m_OutputsizeId;

    PcmlStruct() {
    }

    public PcmlStruct(PcmlAttributeList pcmlAttributeList) {
        super(pcmlAttributeList);
        this.setNodeType(3);
        this.setCount(this.getAttributeValue("count"));
        this.setOffset(this.getAttributeValue("offset"));
        this.setOffsetfrom(this.getAttributeValue("offsetfrom"));
        this.setOutputsize(this.getAttributeValue("outputsize"));
        this.setMinvrm(this.getAttributeValue("minvrm"));
        this.setMaxvrm(this.getAttributeValue("maxvrm"));
    }

    String[] getAttributeList() {
        return STRUCTATTRIBUTES;
    }

    int getCount(PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.resolveIntegerValue(this.getCount(), this.getCountId(), pcmlDimensions);
    }

    final int getXPCMLCount(PcmlDimensions pcmlDimensions) throws PcmlException {
        try {
            int n = this.resolveIntegerValue(this.getCount(), this.getCountId(), pcmlDimensions);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    PcmlDimensions getDimensions(PcmlDimensions pcmlDimensions) throws PcmlException {
        PcmlDimensions pcmlDimensions2 = null;
        PcmlNode pcmlNode = this.getParent();
        pcmlDimensions2 = pcmlNode instanceof PcmlData ? ((PcmlData)pcmlNode).getDimensions(pcmlDimensions) : (pcmlNode instanceof PcmlStruct ? ((PcmlStruct)pcmlNode).getDimensions(pcmlDimensions) : new PcmlDimensions(this.getNbrOfDimensions()));
        if (this.isArray()) {
            int n = this.getCount(pcmlDimensions);
            pcmlDimensions2.add(n);
        }
        return pcmlDimensions2;
    }

    long[] getDimensionTimestamps(PcmlDimensions pcmlDimensions) throws PcmlException {
        long[] lArray;
        Integer n = null;
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            n = pcmlDimensions.integerAt(pcmlDimensions.size() - 1);
            pcmlDimensions.remove();
        }
        long[] lArray2 = pcmlNode instanceof PcmlData ? ((PcmlData)pcmlNode).getDimensionTimestamps(pcmlDimensions) : (pcmlNode instanceof PcmlStruct ? ((PcmlStruct)pcmlNode).getDimensionTimestamps(pcmlDimensions) : new long[]{});
        if (n != null) {
            int n2;
            pcmlDimensions.add(n);
            lArray = new long[lArray2.length + 1];
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                lArray[n2] = lArray2[n2];
            }
            lArray[n2] = this.resolveDimensionTimestamp(pcmlDimensions);
            if (n2 > 0) {
                lArray[n2] = Math.max(lArray[n2], lArray[n2 - 1]);
            }
        } else {
            lArray = lArray2;
        }
        return lArray;
    }

    int getNbrOfDimensions() {
        int n = 0;
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            ++n;
        }
        if (pcmlNode instanceof PcmlData) {
            n += ((PcmlData)pcmlNode).getNbrOfDimensions();
        } else if (pcmlNode instanceof PcmlStruct) {
            n += ((PcmlStruct)pcmlNode).getNbrOfDimensions();
        }
        return n;
    }

    int getOffset(PcmlDimensions pcmlDimensions) throws PcmlException {
        return this.resolveIntegerValue(this.getOffset(), this.getOffsetId(), pcmlDimensions);
    }

    public final int getOffset() {
        return this.m_Offset;
    }

    public final String getOffsetId() {
        return this.resolveRelativeName(this.m_OffsetId);
    }

    public final String getUnqualifiedOffsetId() {
        return this.m_OffsetId;
    }

    private final boolean isOffsetfromFixed() {
        return this.m_OffsetfromFixed;
    }

    final int getOffsetfrom() {
        if (this.isOffsetfromFixed()) {
            return this.m_Offsetfrom;
        }
        return -1;
    }

    final String getOffsetfromId() {
        return this.resolveRelativeName(this.m_OffsetfromId);
    }

    public final String getUnqualifiedOffsetfromId() {
        return this.m_OffsetfromId;
    }

    int getOutputsize(PcmlDimensions pcmlDimensions) throws PcmlException {
        boolean bl;
        int n;
        int n2 = 0;
        n2 = this.resolveIntegerValue(this.getOutputsize(), this.getOutputsizeId(), pcmlDimensions);
        if (n2 > 0) {
            return n2;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n = 1;
            bl = false;
        }
        for (int i = 0; i < n; ++i) {
            if (bl) {
                pcmlDimensions.add(i);
            }
            Enumeration enumeration = this.getChildren();
            block5: while (enumeration.hasMoreElements()) {
                PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                switch (pcmlDocNode.getNodeType()) {
                    case 3: {
                        n2 += ((PcmlStruct)pcmlDocNode).getOutputsize(pcmlDimensions);
                        continue block5;
                    }
                    case 4: {
                        n2 += ((PcmlData)pcmlDocNode).getOutputsize(pcmlDimensions);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), this.getNameForException()});
            }
            if (!bl) continue;
            pcmlDimensions.remove();
        }
        return n2;
    }

    boolean isArray() {
        if (this.getCount() > 0) {
            return true;
        }
        return this.getCountId() != null;
    }

    boolean isInArray() {
        PcmlNode pcmlNode = this.getParent();
        if (this.isArray()) {
            return true;
        }
        if (pcmlNode instanceof PcmlData) {
            return ((PcmlData)pcmlNode).isArray();
        }
        if (pcmlNode instanceof PcmlStruct) {
            return ((PcmlStruct)pcmlNode).isArray();
        }
        return false;
    }

    public int getCount() {
        return this.m_Count;
    }

    public String getCountId() {
        return this.resolveRelativeName(this.m_CountId);
    }

    public final String getUnqualifiedCountId() {
        return this.m_CountId;
    }

    public final int getMaxvrm() {
        return this.m_MaxvrmInt;
    }

    public final String getMaxvrmString() {
        return this.m_Maxvrm;
    }

    public final int getMinvrm() {
        return this.m_MinvrmInt;
    }

    public final String getMinvrmString() {
        return this.m_Minvrm;
    }

    public final int getOutputsize() {
        return this.m_Outputsize;
    }

    public final String getOutputsizeId() {
        return this.resolveRelativeName(this.m_OutputsizeId);
    }

    public final String getUnqualifiedOutputsizeId() {
        return this.m_OutputsizeId;
    }

    private void setCount(String string) {
        if (string == null || string.equals("")) {
            this.m_Count = 0;
            this.m_CountId = null;
            return;
        }
        try {
            this.m_Count = Integer.parseInt(string);
            this.m_CountId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Count = 0;
            this.m_CountId = string;
        }
    }

    private void setMaxvrm(String string) {
        this.m_MaxvrmInt = Integer.MAX_VALUE;
        if (string == null || string.equals("")) {
            this.m_Maxvrm = null;
            return;
        }
        this.m_Maxvrm = string;
    }

    private void setMinvrm(String string) {
        this.m_MinvrmInt = Integer.MIN_VALUE;
        if (string == null || string.equals("")) {
            this.m_Minvrm = null;
            return;
        }
        this.m_Minvrm = string;
    }

    private void setOffset(String string) {
        if (string == null || string.equals("")) {
            this.m_Offset = 0;
            this.m_OffsetId = null;
            return;
        }
        try {
            this.m_Offset = Integer.parseInt(string);
            this.m_OffsetId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Offset = 0;
            this.m_OffsetId = string;
        }
    }

    private void setOffsetfrom(String string) {
        this.m_OffsetfromFixed = true;
        if (string == null || string.equals("")) {
            this.m_Offsetfrom = -1;
            this.m_OffsetfromId = null;
            return;
        }
        try {
            this.m_Offsetfrom = Integer.parseInt(string);
            this.m_OffsetfromId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Offsetfrom = 0;
            this.m_OffsetfromId = string;
        }
    }

    private void setOutputsize(String string) {
        if (string == null || string.equals("")) {
            this.m_Outputsize = 0;
            return;
        }
        try {
            this.m_Outputsize = Integer.parseInt(string);
            this.m_OutputsizeId = null;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_Outputsize = 0;
            this.m_OutputsizeId = string;
        }
    }

    protected void checkAttributes() {
        PcmlDocNode pcmlDocNode;
        super.checkAttributes();
        if (this.m_CountId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_CountId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_CountId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Count < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("count", this.m_Count), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OffsetId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_OffsetId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Offset < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("offset", this.m_Offset), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_OffsetfromId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OffsetfromId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("offsetfrom", this.m_OffsetfromId), this.getNameForException()});
            } else {
                String string;
                String string2 = this.getQualifiedName();
                if (string2.equals("")) {
                    string2 = this.getNameForException();
                }
                if (!string2.startsWith((string = pcmlDocNode.getQualifiedName()) + ".")) {
                    this.getDoc().addPcmlSpecificationError("OFFSETFROM_NOT_FOUND", new Object[]{this.m_OffsetfromId, this.getNameForException()});
                }
            }
        } else if (this.m_Offsetfrom < -1) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("offsetfrom", this.m_Offsetfrom), this.getBracketedTagName(), this.getNameForException()});
        }
        if (this.m_Minvrm != null) {
            this.m_MinvrmInt = PcmlData.validateVRM(this.m_Minvrm);
            if (this.m_MinvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("minvrm", this.m_Minvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_Maxvrm != null) {
            this.m_MaxvrmInt = PcmlData.validateVRM(this.m_Maxvrm);
            if (this.m_MaxvrmInt <= 0) {
                this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("maxvrm", this.m_Maxvrm), this.getBracketedTagName(), this.getNameForException()});
            }
        }
        if (this.m_OutputsizeId != null) {
            pcmlDocNode = this.resolveRelativeNode(this.m_OutputsizeId);
            if (pcmlDocNode == null) {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_NOT_FOUND", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), this.getNameForException()});
            } else if (pcmlDocNode instanceof PcmlData) {
                if (((PcmlData)pcmlDocNode).getDataType() != 2) {
                    this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_NODETYPE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), pcmlDocNode.getQualifiedName(), "<data>", this.getNameForException()});
                }
            } else {
                this.getDoc().addPcmlSpecificationError("ATTR_REF_WRONG_DATATYPE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_OutputsizeId), pcmlDocNode.getQualifiedName(), "type=\"int\"", this.getNameForException()});
            }
        } else if (this.m_Outputsize < 0) {
            this.getDoc().addPcmlSpecificationError("BAD_ATTRIBUTE_VALUE", new Object[]{PcmlDocNode.makeQuotedAttr("outputsize", this.m_Outputsize), this.getBracketedTagName(), this.getNameForException()});
        }
    }

    boolean isSupportedAtHostVRM() throws PcmlException {
        int n = this.getAs400VRM();
        if (this.getMinvrm() > n) {
            return false;
        }
        return this.getMaxvrm() >= n;
    }

    int toBytes(OutputStream outputStream, int n, PcmlDimensions pcmlDimensions) throws PcmlException {
        boolean bl;
        int n2;
        int n3 = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n2 = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n2 = 1;
            bl = false;
        }
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                pcmlDimensions.add(i);
            }
            Enumeration enumeration = this.getChildren();
            block5: while (enumeration.hasMoreElements()) {
                PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                switch (pcmlDocNode.getNodeType()) {
                    case 3: {
                        n3 += ((PcmlStruct)pcmlDocNode).toBytes(outputStream, n + n3, pcmlDimensions);
                        continue block5;
                    }
                    case 4: {
                        n3 += ((PcmlData)pcmlDocNode).toBytes(outputStream, n + n3, pcmlDimensions);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), this.getNameForException()});
            }
            if (!bl) continue;
            pcmlDimensions.remove();
        }
        return n3;
    }

    int parseBytes(byte[] byArray, int n, Hashtable hashtable, PcmlDimensions pcmlDimensions) throws PcmlException {
        String string;
        boolean bl;
        int n2;
        int n3 = 0;
        if (!this.isSupportedAtHostVRM()) {
            return 0;
        }
        if (this.isArray() && pcmlDimensions.size() < this.getNbrOfDimensions()) {
            n2 = this.getCount(pcmlDimensions);
            bl = true;
        } else {
            n2 = 1;
            bl = false;
        }
        int n4 = 0;
        int n5 = this.getOffset(pcmlDimensions);
        if (n5 > 0) {
            Integer n6 = null;
            string = this.getOffsetfromId();
            if (string != null) {
                n6 = (Integer)hashtable.get(string);
                if (n6 == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{string, this.getNameForException()});
                }
            } else {
                n6 = this.getOffsetfrom() >= 0 ? new Integer(this.getOffsetfrom()) : (Integer)hashtable.get(((PcmlDocNode)this.getParent()).getQualifiedName());
            }
            if (n6 instanceof Integer) {
                n5 += n6.intValue();
            }
            if (n5 > n) {
                n4 = n5 - n;
            }
        }
        for (int i = 0; i < n2; ++i) {
            string = this.getQualifiedName();
            if (!string.equals("")) {
                hashtable.put(string, new Integer(n + n4 + n3));
            }
            if (bl) {
                pcmlDimensions.add(i);
            }
            Enumeration enumeration = this.getChildren();
            block5: while (enumeration.hasMoreElements()) {
                PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
                switch (pcmlDocNode.getNodeType()) {
                    case 3: {
                        PcmlStruct pcmlStruct = (PcmlStruct)pcmlDocNode;
                        n3 += pcmlStruct.parseBytes(byArray, n + n4 + n3, hashtable, pcmlDimensions);
                        continue block5;
                    }
                    case 4: {
                        PcmlData pcmlData = (PcmlData)pcmlDocNode;
                        n3 += pcmlData.parseBytes(byArray, n + n4 + n3, hashtable, pcmlDimensions);
                        continue block5;
                    }
                }
                throw new PcmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), this.getNameForException()});
            }
            if (bl) {
                pcmlDimensions.remove();
            }
            if (string.equals("")) continue;
            hashtable.remove(string);
        }
        return n3 + n4;
    }

    private int resolveIntegerValue(int n, String string, PcmlDimensions pcmlDimensions) throws PcmlException {
        if (string != null) {
            PcmlNode pcmlNode = this.getDoc().getElement(string);
            if (pcmlNode instanceof PcmlData) {
                PcmlData pcmlData = (PcmlData)pcmlNode;
                Object object = pcmlData.getValue(pcmlDimensions);
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (object == null) {
                    throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{pcmlData.getNameForException()});
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), pcmlData.getNameForException()});
            }
            if (pcmlNode == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
        }
        return n;
    }

    private long resolveDimensionTimestamp(PcmlDimensions pcmlDimensions) throws PcmlException {
        String string = this.getCountId();
        if (string != null) {
            PcmlNode pcmlNode = this.getDoc().getElement(string);
            if (pcmlNode instanceof PcmlData) {
                return ((PcmlData)pcmlNode).getTimestamp(pcmlDimensions);
            }
            if (pcmlNode == null) {
                throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{string, "<data>"});
            }
            throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{string, "<data>"});
        }
        return Long.MIN_VALUE;
    }
}

