/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.Vector;

abstract class PermissionAccess {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    AS400 as400_;
    private int ccsid_;
    private boolean gotCcsid_;
    private static final int DEFAULT_LENGTH = 600;

    public PermissionAccess(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
    }

    public abstract void addUser(String var1, UserPermission var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, PropertyVetoException, UnknownHostException;

    protected abstract String expandQuotes(String var1);

    public AS400 getSystem() {
        return this.as400_;
    }

    public Vector getAuthority(String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException, PropertyVetoException {
        Vector<Object> vector = new Vector<Object>();
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName("QSYS", "QSYRTVUA", "PGM");
        ProgramParameter[] programParameterArray = new ProgramParameter[8];
        int n = this.as400_.getVRM();
        programParameterArray = this.getParameters(600, string, n >= 328448);
        ProgramCall programCall = new ProgramCall(this.as400_);
        programCall.setProgram(qSYSObjectPathName.getPath(), programParameterArray);
        if (!programCall.run()) {
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray = programParameterArray[2].getOutputData();
        byte[] byArray2 = programParameterArray[0].getOutputData();
        RecordFormat recordFormat = this.getFeedbackRecordFormat();
        Record record = new Record(recordFormat);
        record.setContents(byArray);
        Integer n2 = (Integer)record.getField("BytesAvailable");
        Integer n3 = (Integer)record.getField("BytesReturn");
        int n4 = n2;
        int n5 = n3;
        if (n4 > n5) {
            programParameterArray = this.getParameters(n4 + 400, string, n >= 328448);
            programCall.setProgram(qSYSObjectPathName.getPath(), programParameterArray);
            if (!programCall.run()) {
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            byArray = programParameterArray[2].getOutputData();
            byArray2 = programParameterArray[0].getOutputData();
            record.setContents(byArray);
        }
        String string2 = ((String)record.getField("owner")).trim();
        String string3 = ((String)record.getField("primaryGroup")).trim();
        String string4 = ((String)record.getField("authorizationList")).trim();
        String string5 = ((String)record.getField("sensitivityLevel")).trim();
        Integer n6 = new Integer(this.getIntValue(string5));
        vector.addElement(string2);
        vector.addElement(string3);
        vector.addElement(string4);
        vector.addElement(n6);
        Integer n7 = (Integer)record.getField("usersNumber");
        Integer n8 = (Integer)record.getField("userEntryLength");
        int n9 = n7;
        int n10 = n8;
        RecordFormat recordFormat2 = this.getUserRecordFormat();
        for (int i = 0; i < n9; ++i) {
            Record record2 = recordFormat2.getNewRecord(byArray2, i * n10);
            UserPermission userPermission = this.getUserPermission(record2);
            vector.addElement(userPermission);
        }
        return vector;
    }

    boolean getBooleanValue(String string) {
        return string.equals("1");
    }

    private int getCcsid() {
        if (!this.gotCcsid_) {
            this.ccsid_ = this.as400_.getCcsid();
            this.gotCcsid_ = true;
        }
        return this.ccsid_;
    }

    private RecordFormat getFeedbackRecordFormat() {
        int n;
        BinaryFieldDescription[] binaryFieldDescriptionArray = new BinaryFieldDescription[6];
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        AS400Text aS400Text = new AS400Text(10, this.getCcsid(), this.as400_);
        binaryFieldDescriptionArray[0] = new BinaryFieldDescription(aS400Bin4, "fbBytesReturn");
        binaryFieldDescriptionArray[1] = new BinaryFieldDescription(aS400Bin4, "fbBytesAvailable");
        binaryFieldDescriptionArray[2] = new BinaryFieldDescription(aS400Bin4, "BytesReturn");
        binaryFieldDescriptionArray[3] = new BinaryFieldDescription(aS400Bin4, "BytesAvailable");
        binaryFieldDescriptionArray[4] = new BinaryFieldDescription(aS400Bin4, "usersNumber");
        binaryFieldDescriptionArray[5] = new BinaryFieldDescription(aS400Bin4, "userEntryLength");
        CharacterFieldDescription[] characterFieldDescriptionArray = new CharacterFieldDescription[]{new CharacterFieldDescription(aS400Text, "owner"), new CharacterFieldDescription(aS400Text, "primaryGroup"), new CharacterFieldDescription(aS400Text, "authorizationList"), new CharacterFieldDescription(new AS400Text(1, this.getCcsid(), this.as400_), "sensitivityLevel")};
        RecordFormat recordFormat = new RecordFormat();
        for (n = 0; n < 6; ++n) {
            recordFormat.addFieldDescription(binaryFieldDescriptionArray[n]);
        }
        for (n = 0; n < 4; ++n) {
            recordFormat.addFieldDescription(characterFieldDescriptionArray[n]);
        }
        return recordFormat;
    }

    int getIntValue(String string) {
        return Integer.parseInt(string);
    }

    ProgramParameter[] getParameters(int n, String string, boolean bl) throws UnsupportedEncodingException {
        Object object;
        ProgramParameter[] programParameterArray = new ProgramParameter[8];
        programParameterArray[0] = new ProgramParameter(n);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n));
        programParameterArray[2] = new ProgramParameter(55);
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(55));
        AS400Text aS400Text = new AS400Text(8, this.getCcsid(), this.as400_);
        programParameterArray[4] = new ProgramParameter(aS400Text.toBytes("RTUA0100"));
        if (!bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "PermissionAccess creating QSYRTVUA parameters using job CCSID.");
            }
            if (string.toUpperCase().startsWith("/QDLS/")) {
                string = string.toUpperCase();
                try {
                    string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
                }
                catch (Exception exception) {
                    Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
                }
            }
            object = CharConverter.stringToByteArray(this.getCcsid(), this.as400_, string);
            programParameterArray[5] = new ProgramParameter((byte[])object);
            programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(((Object)object).length));
        } else {
            int n2;
            if (Trace.traceOn_) {
                Trace.log(1, "PermissionAccess creating QSYRTVUA parameters using UTF-16 (CCSID 1200).");
            }
            if (((String)(object = string.toUpperCase())).startsWith("/QDLS/")) {
                string = object;
                try {
                    string = CharConverter.convertIFSQSYSPathnameToJobPathname(string, this.as400_.getCcsid());
                }
                catch (Exception exception) {
                    Trace.log(4, "Unable to convert QDLS pathname to correct job CCSID.", (Throwable)exception);
                }
            }
            byte[] byArray = null;
            try {
                byArray = CharConverter.stringToByteArray(1200, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (Trace.traceOn_) {
                    Trace.log(4, "PermissionAccess could not load converter table for CCSID 1200. Manually converting path name.");
                }
                n2 = string.length();
                byArray = new byte[n2 * 2];
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    byArray[i * 2] = (byte)(c >> 8);
                    byArray[i * 2 + 1] = (byte)c;
                }
            }
            byte[] byArray2 = new byte[32 + byArray.length];
            BinaryConverter.intToByteArray(1200, byArray2, 0);
            BinaryConverter.intToByteArray(2, byArray2, 12);
            BinaryConverter.intToByteArray(byArray.length, byArray2, 16);
            n2 = 47;
            byArray2[20] = (byte)(n2 >> 8);
            byArray2[21] = (byte)n2;
            System.arraycopy(byArray, 0, byArray2, 32, byArray.length);
            programParameterArray[5] = new ProgramParameter(byArray2);
            programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(-1));
        }
        object = new byte[32];
        programParameterArray[7] = new ProgramParameter((byte[])object, 0);
        return programParameterArray;
    }

    RecordFormat getUserRecordFormat() {
        CharacterFieldDescription[] characterFieldDescriptionArray = new CharacterFieldDescription[16];
        AS400Text aS400Text = new AS400Text(1, this.getCcsid(), this.as400_);
        AS400Text aS400Text2 = new AS400Text(10, this.getCcsid(), this.as400_);
        characterFieldDescriptionArray[0] = new CharacterFieldDescription(aS400Text2, "profileName");
        characterFieldDescriptionArray[1] = new CharacterFieldDescription(aS400Text, "userOrGroup");
        characterFieldDescriptionArray[2] = new CharacterFieldDescription(aS400Text2, "dataAuthority");
        characterFieldDescriptionArray[3] = new CharacterFieldDescription(aS400Text, "autListMgt");
        characterFieldDescriptionArray[4] = new CharacterFieldDescription(aS400Text, "objMgt");
        characterFieldDescriptionArray[5] = new CharacterFieldDescription(aS400Text, "objExistence");
        characterFieldDescriptionArray[6] = new CharacterFieldDescription(aS400Text, "objAlter");
        characterFieldDescriptionArray[7] = new CharacterFieldDescription(aS400Text, "objRef");
        characterFieldDescriptionArray[8] = new CharacterFieldDescription(aS400Text2, "reserved1");
        characterFieldDescriptionArray[9] = new CharacterFieldDescription(aS400Text, "objOperational");
        characterFieldDescriptionArray[10] = new CharacterFieldDescription(aS400Text, "dataRead");
        characterFieldDescriptionArray[11] = new CharacterFieldDescription(aS400Text, "dataAdd");
        characterFieldDescriptionArray[12] = new CharacterFieldDescription(aS400Text, "dataUpdate");
        characterFieldDescriptionArray[13] = new CharacterFieldDescription(aS400Text, "dataDelete");
        characterFieldDescriptionArray[14] = new CharacterFieldDescription(aS400Text, "dataExecute");
        characterFieldDescriptionArray[15] = new CharacterFieldDescription(aS400Text2, "reserved2");
        RecordFormat recordFormat = new RecordFormat();
        for (int i = 0; i < 16; ++i) {
            recordFormat.addFieldDescription(characterFieldDescriptionArray[i]);
        }
        return recordFormat;
    }

    public abstract UserPermission getUserPermission(Record var1) throws UnsupportedEncodingException;

    public abstract void removeUser(String var1, String var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setAuthority(String var1, UserPermission var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setAuthorizationList(String var1, String var2, String var3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public abstract void setFromAuthorizationList(String var1, boolean var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public void setOwner(String string, String string2, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        string = string.toUpperCase();
        CommandCall commandCall = new CommandCall(this.as400_);
        String string3 = bl ? "*YES" : "*NO";
        String string4 = "CHGOWN OBJ(" + this.expandQuotes(string) + ") " + "NEWOWN(" + string2 + ") " + "RVKOLDAUT(" + string3 + ")";
        commandCall.setCommand(string4);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public void setPrimaryGroup(String string, String string2, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException {
        string = string.toUpperCase();
        CommandCall commandCall = new CommandCall(this.as400_);
        String string3 = bl ? "*YES" : "*NO";
        String string4 = "CHGPGP OBJ(" + this.expandQuotes(string) + ") " + "NEWPGP(" + string2 + ") " + "RVKOLDAUT(" + string3 + ")";
        commandCall.setCommand(string4);
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public abstract void setSensitivity(String var1, int var2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ServerStartupException, UnknownHostException, PropertyVetoException;

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
    }
}

