/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class DDMRequestDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";

    DDMRequestDataStream() {
        this.setContinueOnError(false);
        this.setIsChained(false);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(false);
        this.setType(1);
    }

    DDMRequestDataStream(int n) {
        super(n);
        this.setContinueOnError(false);
        this.setIsChained(false);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(false);
        this.setType(1);
    }

    DDMRequestDataStream(int n, boolean bl, boolean bl2, boolean bl3) {
        super(n);
        this.setContinueOnError(bl);
        this.setIsChained(bl2);
        this.setGDSId((byte)-48);
        this.setHasSameRequestCorrelation(bl3);
        this.setType(1);
    }

    static DDMRequestDataStream getRequestCMMUOW() {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(15);
        dDMRequestDataStream.set16bit(9, 6);
        dDMRequestDataStream.set16bit(4186, 8);
        dDMRequestDataStream.set16bit(5, 10);
        dDMRequestDataStream.set16bit(4533, 12);
        dDMRequestDataStream.data_[14] = -15;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestEXCSAT(String string, AS400ImplRemote aS400ImplRemote) throws IOException {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(117);
        dDMRequestDataStream.set16bit(111, 6);
        dDMRequestDataStream.set16bit(4161, 8);
        dDMRequestDataStream.set16bit(11, 10);
        dDMRequestDataStream.set16bit(4423, 12);
        dDMRequestDataStream.set16bit(7, 14);
        dDMRequestDataStream.set16bit(9, 16);
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
        converterImplRemote.stringToByteArray("QAS", dDMRequestDataStream.data_, 18);
        dDMRequestDataStream.set16bit(96, 21);
        dDMRequestDataStream.set16bit(5124, 23);
        dDMRequestDataStream.set16bit(5123, 25);
        dDMRequestDataStream.set16bit(3, 27);
        dDMRequestDataStream.set16bit(5155, 29);
        dDMRequestDataStream.set16bit(3, 31);
        dDMRequestDataStream.set16bit(5125, 33);
        dDMRequestDataStream.set16bit(3, 35);
        dDMRequestDataStream.set16bit(5126, 37);
        dDMRequestDataStream.set16bit(3, 39);
        dDMRequestDataStream.set16bit(5127, 41);
        dDMRequestDataStream.set16bit(3, 43);
        if (string.equalsIgnoreCase("PREV4R2")) {
            dDMRequestDataStream.set16bit(5188, 45);
            dDMRequestDataStream.set16bit(3, 47);
        } else {
            dDMRequestDataStream.set16bit(5236, 45);
            dDMRequestDataStream.set16bit(5, 47);
        }
        dDMRequestDataStream.set16bit(5208, 49);
        dDMRequestDataStream.set16bit(1, 51);
        dDMRequestDataStream.set16bit(5207, 53);
        dDMRequestDataStream.set16bit(3, 55);
        dDMRequestDataStream.set16bit(5132, 57);
        dDMRequestDataStream.set16bit(3, 59);
        dDMRequestDataStream.set16bit(5145, 61);
        dDMRequestDataStream.set16bit(3, 63);
        dDMRequestDataStream.set16bit(5150, 65);
        dDMRequestDataStream.set16bit(3, 67);
        dDMRequestDataStream.set16bit(5154, 69);
        dDMRequestDataStream.set16bit(3, 71);
        dDMRequestDataStream.set16bit(9231, 73);
        dDMRequestDataStream.set16bit(3, 75);
        dDMRequestDataStream.set16bit(5170, 77);
        dDMRequestDataStream.set16bit(3, 79);
        dDMRequestDataStream.set16bit(5171, 81);
        dDMRequestDataStream.set16bit(3, 83);
        dDMRequestDataStream.set16bit(5184, 85);
        dDMRequestDataStream.set16bit(1, 87);
        dDMRequestDataStream.set16bit(5179, 89);
        dDMRequestDataStream.set16bit(3, 91);
        dDMRequestDataStream.set16bit(9223, 93);
        dDMRequestDataStream.set16bit(3, 95);
        dDMRequestDataStream.set16bit(5219, 97);
        dDMRequestDataStream.set16bit(3, 99);
        dDMRequestDataStream.set16bit(5221, 101);
        dDMRequestDataStream.set16bit(3, 103);
        dDMRequestDataStream.set16bit(5180, 105);
        dDMRequestDataStream.set16bit(3, 107);
        dDMRequestDataStream.set16bit(5247, 109);
        dDMRequestDataStream.set16bit(4, 111);
        dDMRequestDataStream.set16bit(5280, 113);
        dDMRequestDataStream.set16bit(4, 115);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestRLLBCKUOW() {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(15);
        dDMRequestDataStream.set16bit(9, 6);
        dDMRequestDataStream.set16bit(4187, 8);
        dDMRequestDataStream.set16bit(5, 10);
        dDMRequestDataStream.set16bit(4533, 12);
        dDMRequestDataStream.data_[14] = -15;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestSTRCMMCTL(int n) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(22);
        dDMRequestDataStream.set16bit(16, 6);
        dDMRequestDataStream.set16bit(4188, 8);
        dDMRequestDataStream.set16bit(6, 10);
        dDMRequestDataStream.set16bit(4538, 12);
        dDMRequestDataStream.data_[14] = 0;
        dDMRequestDataStream.data_[15] = 1;
        dDMRequestDataStream.set16bit(6, 16);
        dDMRequestDataStream.set16bit(5234, 18);
        dDMRequestDataStream.data_[20] = 36;
        switch (n) {
            case 1: {
                dDMRequestDataStream.data_[21] = 65;
                break;
            }
            case 2: {
                dDMRequestDataStream.data_[21] = 66;
                break;
            }
            case 0: {
                dDMRequestDataStream.data_[21] = 67;
                break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("lockLevel", 2);
            }
        }
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38ALCOB(byte by, String string, String string2, String string3, int n, AS400ImplRemote aS400ImplRemote) throws AS400SecurityException, InterruptedException, IOException {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(34 + string.length() + string2.length() + string3.length());
        int n2 = 3 + string.length() + string2.length() + string3.length();
        int n3 = 4 + n2;
        int n4 = 5;
        int n5 = 8;
        int n6 = 13 + n2;
        dDMRequestDataStream.set16bit(25 + n2, 6);
        dDMRequestDataStream.set16bit(53250, 8);
        dDMRequestDataStream.set16bit(n6, 10);
        dDMRequestDataStream.set16bit(53515, 12);
        dDMRequestDataStream.set16bit(n3, 14);
        dDMRequestDataStream.set16bit(4366, 16);
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
        converterImplRemote.stringToByteArray(string + "/" + string2 + "(" + string3 + ")", dDMRequestDataStream.data_, 18);
        int n7 = 18 + n2;
        dDMRequestDataStream.set16bit(n4, n7);
        dDMRequestDataStream.set16bit(4421, n7 + 2);
        dDMRequestDataStream.data_[n7 + 4] = by;
        dDMRequestDataStream.set16bit(n5, n7 + 5);
        dDMRequestDataStream.set16bit(53516, n7 + 7);
        dDMRequestDataStream.set32bit(n, n7 + 9);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38CLOSE(byte[] byArray) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(27);
        dDMRequestDataStream.set16bit(21, 6);
        dDMRequestDataStream.set16bit(53252, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(5, 22);
        dDMRequestDataStream.set16bit(53537, 24);
        dDMRequestDataStream.data_[26] = 2;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38CMD(String string, AS400ImplRemote aS400ImplRemote) throws AS400SecurityException, InterruptedException, IOException {
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
        byte[] byArray = converterImplRemote.stringToByteArray(string);
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(14 + byArray.length);
        dDMRequestDataStream.set16bit(8 + byArray.length, 6);
        dDMRequestDataStream.set16bit(53254, 8);
        dDMRequestDataStream.set16bit(4 + byArray.length, 10);
        dDMRequestDataStream.set16bit(53507, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, byArray.length);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38DEL(byte[] byArray) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(22);
        dDMRequestDataStream.set16bit(16, 6);
        dDMRequestDataStream.set16bit(53255, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38DLCOB(byte[] byArray, String string, String string2, String string3, AS400ImplRemote aS400ImplRemote) throws AS400SecurityException, InterruptedException, IOException {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(10 + byArray.length * (16 + string.length() + string2.length() + string3.length()));
        int n = 3 + string.length() + string2.length() + string3.length();
        int n2 = 4 + n;
        int n3 = 5;
        int n4 = 13 + n;
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53256, 8);
        byte[] byArray2 = new byte[n];
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
        converterImplRemote.stringToByteArray(string + "/" + string2 + "(" + string3 + ")", byArray2, 0);
        int n5 = 10;
        for (int n6 = 0; n6 < byArray.length; n6 = (int)((short)(n6 + 1))) {
            dDMRequestDataStream.set16bit(n4, n5);
            dDMRequestDataStream.set16bit(53525, n5 + 2);
            dDMRequestDataStream.set16bit(n2, n5 + 4);
            dDMRequestDataStream.set16bit(4366, n5 + 6);
            System.arraycopy(byArray2, 0, dDMRequestDataStream.data_, n5 + 8, byArray2.length);
            int n7 = n5 + 8 + byArray2.length;
            dDMRequestDataStream.set16bit(n3, n7);
            dDMRequestDataStream.set16bit(4419, n7 + 2);
            dDMRequestDataStream.data_[n7 + 4] = byArray[n6];
            n5 = (short)(n5 + n4);
        }
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38FEOD(byte[] byArray, int n, int n2, int n3) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(30);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53259, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 1;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38GET(byte[] byArray, int n, int n2, int n3) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(30);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53260, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 1;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38GETD(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, AS400ImplRemote aS400ImplRemote) throws AS400SecurityException, InterruptedException, IOException {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(60);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53261, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 2;
        dDMRequestDataStream.set16bit(30, 30);
        dDMRequestDataStream.set16bit(53509, 32);
        dDMRequestDataStream.data_[34] = 1;
        dDMRequestDataStream.set16bit(10, 35);
        System.arraycopy(byArray2, 0, dDMRequestDataStream.data_, 37, byArray2.length);
        dDMRequestDataStream.data_[47] = 15;
        dDMRequestDataStream.set16bit(2, 48);
        dDMRequestDataStream.set16bit(0, 50);
        dDMRequestDataStream.data_[52] = 2;
        dDMRequestDataStream.set16bit(4, 53);
        dDMRequestDataStream.set32bit(n4, 55);
        dDMRequestDataStream.data_[59] = -1;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38GETK(byte[] byArray, RecordFormat recordFormat, byte[] byArray2, int n, int n2, int n3, Object[] objectArray, AS400ImplRemote aS400ImplRemote) throws AS400SecurityException, InterruptedException, IOException {
        int n4;
        int n5 = 60;
        int n6 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray3 = new byte[2];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                byte[] byArray4;
                FieldDescription fieldDescription = recordFormat.getKeyFieldDescription(i);
                if (fieldDescription instanceof VariableLengthFieldDescription) {
                    int n7;
                    Object object;
                    n4 = ((VariableLengthFieldDescription)((Object)fieldDescription)).isVariableLength();
                    if (fieldDescription instanceof HexFieldDescription) {
                        object = (byte[])objectArray[i];
                        if (n4 != 0) {
                            BinaryConverter.shortToByteArray((short)((byte[])object).length, byArray3, 0);
                            byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                        }
                        byteArrayOutputStream.write((byte[])object, 0, ((byte[])object).length);
                        if (n4 == 0) continue;
                        int n8 = fieldDescription.getDataType().getByteLength();
                        byte[] byArray5 = new byte[]{0};
                        for (n7 = ((byte[])object).length; n7 < n8; ++n7) {
                            byteArrayOutputStream.write(byArray5, 0, 1);
                        }
                        continue;
                    }
                    object = (String)objectArray[i];
                    AS400Text aS400Text = (AS400Text)fieldDescription.getDataType();
                    int n9 = aS400Text.getByteLength();
                    n7 = aS400Text.getCcsid();
                    ConverterImplRemote converterImplRemote = null;
                    converterImplRemote = n7 != 65535 ? ConverterImplRemote.getConverter(n7, aS400ImplRemote) : ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
                    aS400Text.setConverter(converterImplRemote);
                    byArray4 = aS400Text.toBytes(object);
                    if (n4 != 0) {
                        BinaryConverter.shortToByteArray((short)byArray4.length, byArray3, 0);
                        byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                    }
                    byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                    continue;
                }
                byArray4 = fieldDescription.getDataType().toBytes(objectArray[i]);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new ExtendedIllegalArgumentException("key", 2);
            }
        }
        n6 = byteArrayOutputStream.size();
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(n5 += n6 + 3);
        dDMRequestDataStream.set16bit(n5 - 6, 6);
        dDMRequestDataStream.set16bit(53262, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 3;
        dDMRequestDataStream.set16bit(53509, 32);
        dDMRequestDataStream.data_[34] = 1;
        dDMRequestDataStream.set16bit(10, 35);
        System.arraycopy(byArray2, 0, dDMRequestDataStream.data_, 37, byArray2.length);
        dDMRequestDataStream.data_[47] = 15;
        dDMRequestDataStream.set16bit(2, 48);
        dDMRequestDataStream.set16bit(0, 50);
        dDMRequestDataStream.data_[52] = 8;
        dDMRequestDataStream.set16bit(4, 53);
        dDMRequestDataStream.set32bit(objectArray.length, 55);
        n4 = 59;
        dDMRequestDataStream.data_[n4++] = 7;
        dDMRequestDataStream.set16bit(n6, n4);
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, dDMRequestDataStream.data_, n4 += 2, n6);
        dDMRequestDataStream.data_[n4 += n6] = -1;
        dDMRequestDataStream.set16bit(n4 - 29, 30);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "GETK req: ", dDMRequestDataStream.data_);
        }
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38GETK(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte[] byArray3, AS400ImplRemote aS400ImplRemote, int n4) throws AS400SecurityException, InterruptedException, IOException {
        int n5 = 60;
        int n6 = byArray3.length;
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(n5 += n6 + 3);
        dDMRequestDataStream.set16bit(n5 - 6, 6);
        dDMRequestDataStream.set16bit(53262, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 3;
        dDMRequestDataStream.set16bit(53509, 32);
        dDMRequestDataStream.data_[34] = 1;
        dDMRequestDataStream.set16bit(10, 35);
        System.arraycopy(byArray2, 0, dDMRequestDataStream.data_, 37, byArray2.length);
        dDMRequestDataStream.data_[47] = 15;
        dDMRequestDataStream.set16bit(2, 48);
        dDMRequestDataStream.set16bit(0, 50);
        dDMRequestDataStream.data_[52] = 8;
        dDMRequestDataStream.set16bit(4, 53);
        dDMRequestDataStream.set32bit(n4, 55);
        int n7 = 59;
        dDMRequestDataStream.data_[n7++] = 7;
        dDMRequestDataStream.set16bit(n6, n7);
        System.arraycopy(byArray3, 0, dDMRequestDataStream.data_, n7 += 2, n6);
        dDMRequestDataStream.data_[n7 += n6] = -1;
        dDMRequestDataStream.set16bit(n7 - 29, 30);
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "GETK req: ", dDMRequestDataStream.data_);
        }
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38GETM(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(40);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53263, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n2;
        dDMRequestDataStream.data_[27] = (byte)n3;
        dDMRequestDataStream.data_[28] = (byte)n4;
        dDMRequestDataStream.data_[29] = (byte)n5;
        dDMRequestDataStream.set16bit(10, 30);
        dDMRequestDataStream.set16bit(53509, 32);
        dDMRequestDataStream.data_[34] = 16;
        dDMRequestDataStream.set16bit(2, 35);
        dDMRequestDataStream.set16bit(n, 37);
        dDMRequestDataStream.data_[39] = -1;
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38OPEN(byte[] byArray, byte[] byArray2) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(26 + byArray.length);
        dDMRequestDataStream.set16bit(20 + byArray.length, 6);
        dDMRequestDataStream.set16bit(53265, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray2, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(4 + byArray.length, 22);
        dDMRequestDataStream.set16bit(53535, 24);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 26, byArray.length);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38PUTM(byte[] byArray) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(22);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53267, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        return dDMRequestDataStream;
    }

    static DDMRequestDataStream getRequestS38UPDAT(int n, int n2, int n3, byte[] byArray) {
        DDMRequestDataStream dDMRequestDataStream = new DDMRequestDataStream(30);
        dDMRequestDataStream.set16bit(dDMRequestDataStream.data_.length - 6, 6);
        dDMRequestDataStream.set16bit(53273, 8);
        dDMRequestDataStream.set16bit(12, 10);
        dDMRequestDataStream.set16bit(4406, 12);
        System.arraycopy(byArray, 0, dDMRequestDataStream.data_, 14, 8);
        dDMRequestDataStream.set16bit(8, 22);
        dDMRequestDataStream.set16bit(53529, 24);
        dDMRequestDataStream.data_[26] = (byte)n;
        dDMRequestDataStream.data_[27] = (byte)n2;
        dDMRequestDataStream.data_[28] = (byte)n3;
        dDMRequestDataStream.data_[29] = 7;
        if (Trace.isTraceOn() && Trace.isTraceDiagnosticOn()) {
            Trace.log(1, "getRequestS38UPDAT", dDMRequestDataStream.data_);
        }
        return dDMRequestDataStream;
    }
}

