/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.MFN_M05_MFELOCLCHLRLLDPLCHLCC;
import ca.uhn.hl7v2.model.v231.segment.MFI;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M05
extends AbstractMessage {
    public MFN_M05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public MFN_M05() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M05_MFELOCLCHLRLLDPLCHLCC.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating MFN_M05 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M05_MFELOCLCHLRLLDPLCHLCC getMFELOCLCHLRLLDPLCHLCC() {
        MFN_M05_MFELOCLCHLRLLDPLCHLCC ret = null;
        try {
            ret = (MFN_M05_MFELOCLCHLRLLDPLCHLCC)this.get("MFELOCLCHLRLLDPLCHLCC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M05_MFELOCLCHLRLLDPLCHLCC getMFELOCLCHLRLLDPLCHLCC(int rep) {
        MFN_M05_MFELOCLCHLRLLDPLCHLCC ret = null;
        try {
            ret = (MFN_M05_MFELOCLCHLRLLDPLCHLCC)this.get("MFELOCLCHLRLLDPLCHLCC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMFELOCLCHLRLLDPLCHLCCReps() {
        int reps = -1;
        try {
            reps = this.getAll("MFELOCLCHLRLLDPLCHLCC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMFELOCLCHLRLLDPLCHLCC(MFN_M05_MFELOCLCHLRLLDPLCHLCC structure, int rep) throws HL7Exception {
        super.insertRepetition("MFELOCLCHLRLLDPLCHLCC", (Structure)structure, rep);
    }

    public MFN_M05_MFELOCLCHLRLLDPLCHLCC insertMFELOCLCHLRLLDPLCHLCC(int rep) throws HL7Exception {
        return (MFN_M05_MFELOCLCHLRLLDPLCHLCC)super.insertRepetition("MFELOCLCHLRLLDPLCHLCC", rep);
    }

    public MFN_M05_MFELOCLCHLRLLDPLCHLCC removeMFELOCLCHLRLLDPLCHLCC(int rep) throws HL7Exception {
        return (MFN_M05_MFELOCLCHLRLLDPLCHLCC)super.removeRepetition("MFELOCLCHLRLLDPLCHLCC", rep);
    }
}

