/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.UIEEObjectRegistery;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEERepositoryUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEESecurity;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEESecurityUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UISecurityRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.SecurityController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurity;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class EESecurityController
extends SecurityController
implements Serializable {
    private static final long serialVersionUID = -4011949721807392436L;
    private static final Class<?> PKG = IUIEEUser.class;
    public static final int ROLE_DECK = 1;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };
    private XulRadio systemRoleRadioButton;
    private XulRadio roleRadioButton;
    private XulRadio userRadioButton;
    private XulTree userDetailTable;
    private XulTree roleDetailTable;
    private XulDialog roleDialog;
    private XulDeck userRoleDeck;
    private XulListbox roleListBox;
    protected XulListbox userListBox;
    private XulListbox availableRoles;
    private XulListbox assignedRoles;
    private XulTextbox rolename;
    private XulTextbox roleDescription;
    private XulListbox availableUsers;
    private XulListbox assignedUsers;
    private XulButton roleEditButton;
    private XulButton roleAddButton;
    private XulButton roleRemoveButton;
    private XulButton addUserToRoleButton;
    private XulButton removeUserFromRoleButton;
    private XulButton addRoleToUserButton;
    private XulButton removeRoleFromUserButton;
    private XulButton assignRoleToUserButton;
    private XulButton unassignRoleFromUserButton;
    private XulButton assignUserToRoleButton;
    private XulButton unassignUserFromRoleButton;
    protected Binding roleDetailBinding;
    protected Binding userDetailBinding;
    protected UIEESecurityUser eeSecurityUser;
    protected UISecurityRole securityRole;
    protected UIEESecurity eeSecurity;
    private XulListbox systemRoleListBox;
    private XulVbox innerRoleVbox;
    private XulHbox roleHbox;
    private XulVbox roleVboxNonManaged;
    private XulLabel instructionalTextLabel;

    protected boolean doLazyInit() {
        boolean superSucceeded = super.doLazyInit();
        if (!superSucceeded) {
            return false;
        }
        if (!this.managed) {
            this.userRadioButton.setVisible(false);
            this.roleHbox.removeChild((Element)this.innerRoleVbox);
            this.roleHbox.addChild((Element)this.roleVboxNonManaged);
        }
        return true;
    }

    protected boolean initService() {
        try {
            if (!this.repository.hasService(IRoleSupportSecurityManager.class)) {
                return false;
            }
            this.service = (RepositorySecurityManager)this.repository.getService(IRoleSupportSecurityManager.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    protected void createModel() throws Exception {
        super.createModel();
        this.securityRole = new UISecurityRole();
    }

    protected void createSecurityUser() throws Exception {
        this.eeSecurityUser = new UIEESecurityUser(this.service);
        this.securityUser = this.eeSecurityUser;
    }

    protected void createSecurity() throws Exception {
        this.eeSecurity = new UIEESecurity(this.service);
        this.security = this.eeSecurity;
    }

    protected void setInitialDeck() {
        if (this.managed) {
            super.setInitialDeck();
        } else {
            this.changeToRoleDeck();
        }
    }

    protected void createBindings() {
        super.createBindings();
        this.systemRoleRadioButton = (XulRadio)this.document.getElementById("system-role-radio-button");
        this.roleRadioButton = (XulRadio)this.document.getElementById("role-radio-button");
        this.userRadioButton = (XulRadio)this.document.getElementById("user-radio-button");
        this.roleAddButton = (XulButton)this.document.getElementById("role-add");
        this.roleEditButton = (XulButton)this.document.getElementById("role-edit");
        this.roleRemoveButton = (XulButton)this.document.getElementById("role-remove");
        this.addUserToRoleButton = (XulButton)this.document.getElementById("add-user-to-role");
        this.removeUserFromRoleButton = (XulButton)this.document.getElementById("remove-user-from-role");
        this.addRoleToUserButton = (XulButton)this.document.getElementById("add-role-to-user");
        this.removeRoleFromUserButton = (XulButton)this.document.getElementById("remove-role-from-user");
        this.roleDialog = (XulDialog)this.document.getElementById("add-role-dialog");
        this.userRoleDeck = (XulDeck)this.document.getElementById("user-role-deck");
        this.roleListBox = (XulListbox)this.document.getElementById("roles-list");
        this.roleDetailTable = (XulTree)this.document.getElementById("role-detail-table");
        this.userListBox = (XulListbox)this.document.getElementById("users-list");
        this.userDetailTable = (XulTree)this.document.getElementById("user-detail-table");
        this.availableRoles = (XulListbox)this.document.getElementById("available-roles-list");
        this.assignedRoles = (XulListbox)this.document.getElementById("selected-roles-list");
        this.assignRoleToUserButton = (XulButton)this.document.getElementById("assign-role-to-user");
        this.unassignRoleFromUserButton = (XulButton)this.document.getElementById("unassign-role-from-user");
        this.systemRoleListBox = (XulListbox)this.document.getElementById("system-roles-list");
        this.innerRoleVbox = (XulVbox)this.document.getElementById("inner-role-vbox");
        this.roleVboxNonManaged = (XulVbox)this.document.getElementById("role-vbox-nonmanaged");
        this.roleHbox = (XulHbox)this.document.getElementById("role-hbox");
        this.instructionalTextLabel = (XulLabel)this.document.getElementById("instructional-text-label");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.eeSecurityUser, "assignedRoles", (Object)this.assignedRoles, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.eeSecurityUser, "availableRoles", (Object)this.availableRoles, "elements", new BindingConvertor[0]);
        BindingConvertor<List<IUIRole>, Object[]> arrayToListRoleConverter = new BindingConvertor<List<IUIRole>, Object[]>(){

            public Object[] sourceToTarget(List<IUIRole> roles) {
                if (roles != null) {
                    Object[] retVal = new Object[roles.size()];
                    int i = 0;
                    for (IUIRole role : roles) {
                        retVal[i++] = role;
                    }
                    return retVal;
                }
                return null;
            }

            public List<IUIRole> targetToSource(Object[] roles) {
                if (roles != null) {
                    ArrayList<IUIRole> retVal = new ArrayList<IUIRole>();
                    for (int i = 0; i < roles.length; ++i) {
                        retVal.add((IUIRole)roles[i]);
                    }
                    return retVal;
                }
                return null;
            }
        };
        BindingConvertor<List<IUIUser>, Object[]> arrayToListUserConverter = new BindingConvertor<List<IUIUser>, Object[]>(){

            public Object[] sourceToTarget(List<IUIUser> users) {
                if (users != null) {
                    Object[] retVal = new Object[users.size()];
                    int i = 0;
                    for (IUIUser user : users) {
                        retVal[i++] = user;
                    }
                    return retVal;
                }
                return null;
            }

            public List<IUIUser> targetToSource(Object[] users) {
                if (users != null) {
                    ArrayList<IUIUser> retVal = new ArrayList<IUIUser>();
                    for (int i = 0; i < users.length; ++i) {
                        retVal.add((IUIUser)users[i]);
                    }
                    return retVal;
                }
                return null;
            }
        };
        this.bf.createBinding((Object)this.eeSecurityUser, "availableSelectedRoles", (Object)this.availableRoles, "selectedItems", new BindingConvertor[]{arrayToListRoleConverter});
        this.bf.createBinding((Object)this.eeSecurityUser, "assignedSelectedRoles", (Object)this.assignedRoles, "selectedItems", new BindingConvertor[]{arrayToListRoleConverter});
        BindingConvertor<Integer, Boolean> accumulatorButtonConverter = new BindingConvertor<Integer, Boolean>(){

            public Boolean sourceToTarget(Integer value) {
                if (value != null && value >= 0) {
                    return true;
                }
                return false;
            }

            public Integer targetToSource(Boolean value) {
                return null;
            }
        };
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.assignedRoles, "selectedIndex", (Object)this.eeSecurityUser, "roleUnassignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.availableRoles, "selectedIndex", (Object)this.eeSecurityUser, "roleAssignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.eeSecurityUser, "roleUnassignmentPossible", (Object)this.unassignRoleFromUserButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.eeSecurityUser, "roleAssignmentPossible", (Object)this.assignRoleToUserButton, "!disabled", new BindingConvertor[0]);
        this.rolename = (XulTextbox)this.document.getElementById("role-name");
        this.roleDescription = (XulTextbox)this.document.getElementById("role-description");
        this.availableUsers = (XulListbox)this.document.getElementById("available-users-list");
        this.assignedUsers = (XulListbox)this.document.getElementById("selected-users-list");
        this.assignUserToRoleButton = (XulButton)this.document.getElementById("assign-user-to-role");
        this.unassignUserFromRoleButton = (XulButton)this.document.getElementById("unassign-user-from-role");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.securityRole, "name", (Object)this.rolename, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityRole, "description", (Object)this.roleDescription, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityRole, "assignedUsers", (Object)this.assignedUsers, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityRole, "availableUsers", (Object)this.availableUsers, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityRole, "availableSelectedUsers", (Object)this.availableUsers, "selectedItems", new BindingConvertor[]{arrayToListUserConverter});
        this.bf.createBinding((Object)this.securityRole, "assignedSelectedUsers", (Object)this.assignedUsers, "selectedItems", new BindingConvertor[]{arrayToListUserConverter});
        this.bf.createBinding((Object)this.eeSecurity, "selectedRoleIndex", (Object)this.roleListBox, "selectedIndex", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.eeSecurity, "selectedSystemRoleIndex", (Object)this.systemRoleListBox, "selectedIndex", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.assignedUsers, "selectedIndex", (Object)this.securityRole, "userUnassignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.availableUsers, "selectedIndex", (Object)this.securityRole, "userAssignmentPossible", new BindingConvertor[]{accumulatorButtonConverter});
        this.bf.createBinding((Object)this.securityRole, "userUnassignmentPossible", (Object)this.unassignUserFromRoleButton, "!disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.securityRole, "userAssignmentPossible", (Object)this.assignUserToRoleButton, "!disabled", new BindingConvertor[0]);
        try {
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.roleListBox, "selectedIndex", (Object)this, "enableButtons", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.roleListBox, "selectedItem", (Object)this.eeSecurity, "selectedRole", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.eeSecurity, "roleList", (Object)this.roleListBox, "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.roleListBox, "selectedItem", (Object)this.eeSecurity, "selectedRole", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.systemRoleListBox, "selectedItem", (Object)this.eeSecurity, "selectedSystemRole", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.eeSecurity, "systemRoleList", (Object)this.systemRoleListBox, "elements", new BindingConvertor[0]).fireSourceChanged();
            this.bf.createBinding((Object)this.systemRoleListBox, "selectedItem", (Object)this.eeSecurity, "selectedSystemRole", new BindingConvertor[0]);
            if (this.managed) {
                this.userDetailBinding = this.bf.createBinding((Object)this.eeSecurity, "selectedUser", (Object)this.userDetailTable, "elements", new BindingConvertor[]{new BindingConvertor<IUIUser, List<IUIRole>>(){

                    public List<IUIRole> sourceToTarget(IUIUser ru) {
                        if (ru instanceof IUIEEUser) {
                            return new ArrayList<IUIRole>(((IUIEEUser)ru).getRoles());
                        }
                        return null;
                    }

                    public IUIUser targetToSource(List<IUIRole> arg0) {
                        return null;
                    }
                }});
                this.roleDetailBinding = this.bf.createBinding((Object)this.eeSecurity, "selectedRole", (Object)this.roleDetailTable, "elements", new BindingConvertor[]{new BindingConvertor<IUIRole, List<IUIUser>>(){

                    public List<IUIUser> sourceToTarget(IUIRole rr) {
                        return new ArrayList<IUIUser>(rr.getUsers());
                    }

                    public IUIRole targetToSource(List<IUIUser> arg0) {
                        return null;
                    }
                }});
            }
            this.bf.createBinding((Object)this.eeSecurity, "selectedDeck", (Object)this.userRoleDeck, "selectedIndex", new BindingConvertor[]{new BindingConvertor<ObjectRecipient.Type, Integer>(){

                public Integer sourceToTarget(ObjectRecipient.Type arg0) {
                    if (arg0 == ObjectRecipient.Type.ROLE) {
                        EESecurityController.this.userRadioButton.setSelected(false);
                        EESecurityController.this.roleRadioButton.setSelected(true);
                        EESecurityController.this.systemRoleRadioButton.setSelected(false);
                        return 1;
                    }
                    if (arg0 == ObjectRecipient.Type.USER) {
                        EESecurityController.this.userRadioButton.setSelected(true);
                        EESecurityController.this.roleRadioButton.setSelected(false);
                        EESecurityController.this.systemRoleRadioButton.setSelected(false);
                        return 0;
                    }
                    if (arg0 == ObjectRecipient.Type.SYSTEM_ROLE) {
                        EESecurityController.this.userRadioButton.setSelected(false);
                        EESecurityController.this.roleRadioButton.setSelected(false);
                        EESecurityController.this.systemRoleRadioButton.setSelected(true);
                        return 2;
                    }
                    return -1;
                }

                public ObjectRecipient.Type targetToSource(Integer arg0) {
                    return null;
                }
            }});
            BindingConvertor<UISecurity.Mode, Boolean> modeBindingConverter = new BindingConvertor<UISecurity.Mode, Boolean>(){

                public Boolean sourceToTarget(UISecurity.Mode arg0) {
                    if (arg0.equals((Object)UISecurity.Mode.ADD)) {
                        return false;
                    }
                    return true;
                }

                public UISecurity.Mode targetToSource(Boolean arg0) {
                    return null;
                }
            };
            BindingConvertor<UISecurity.Mode, Boolean> anotherModeBindingConverter = new BindingConvertor<UISecurity.Mode, Boolean>(){

                public Boolean sourceToTarget(UISecurity.Mode arg0) {
                    if (arg0.equals((Object)UISecurity.Mode.EDIT_MEMBER)) {
                        return true;
                    }
                    return false;
                }

                public UISecurity.Mode targetToSource(Boolean arg0) {
                    return null;
                }
            };
            this.bf.createBinding((Object)this.securityRole, "mode", (Object)this.rolename, "disabled", new BindingConvertor[]{modeBindingConverter});
            this.bf.createBinding((Object)this.securityRole, "mode", (Object)this.roleDescription, "disabled", new BindingConvertor[]{anotherModeBindingConverter});
            this.bf.createBinding((Object)this.securityUser, "mode", (Object)this.userPassword, "disabled", new BindingConvertor[]{anotherModeBindingConverter});
            this.bf.createBinding((Object)this.securityUser, "mode", (Object)this.userDescription, "disabled", new BindingConvertor[]{anotherModeBindingConverter});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assignUsersToRole() {
        this.securityRole.assignUsers(Arrays.asList(this.availableUsers.getSelectedItems()));
    }

    public void unassignUsersFromRole() {
        this.securityRole.unassignUsers(Arrays.asList(this.assignedUsers.getSelectedItems()));
    }

    public void assignRolesToUser() {
        this.eeSecurityUser.assignRoles(Arrays.asList(this.availableRoles.getSelectedItems()));
    }

    public void unassignRolesFromUser() {
        this.eeSecurityUser.unassignRoles(Arrays.asList(this.assignedRoles.getSelectedItems()));
    }

    public void showAddUserDialog() throws Exception {
        block3: {
            try {
                if (this.service != null && ((IRoleSupportSecurityManager)this.service).getRoles() != null) {
                    this.eeSecurityUser.clear();
                    this.eeSecurityUser.setAvailableRoles(this.convertToUIRoleModel(((IRoleSupportSecurityManager)this.service).getRoles()));
                    this.eeSecurityUser.updateAssignedRoles(this.convertToUIRoleModel(((IRoleSupportSecurityManager)this.service).getDefaultRoles()));
                }
                this.eeSecurityUser.setMode(UISecurity.Mode.ADD);
                this.userDialog.setTitle(BaseMessages.getString(PKG, (String)"AddUserDialog.Title", (String[])new String[0]));
                this.userDialog.show();
            }
            catch (KettleException e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"SecurityController.AddUser.UnableToShowAddUser", (String[])new String[]{e.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
    }

    public void cancelAddRoleDialog() throws Exception {
        this.roleDialog.hide();
    }

    protected void addUser() {
        block5: {
            if (this.service != null) {
                try {
                    if (this.eeSecurityUser.getUserInfo().getUsername().isEmpty()) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"CantCreateUserDialog.UsernameIsMandatory", (String[])new String[0]));
                    }
                    if (this.eeSecurityUser.getUserInfo().getPassword().isEmpty()) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"CantCreateUserDialog.PasswordIsMandatory", (String[])new String[0]));
                    }
                    this.service.saveUserInfo(this.eeSecurityUser.getUserInfo());
                    this.eeSecurity.addUser(UIObjectRegistry.getInstance().constructUIRepositoryUser(this.eeSecurityUser.getUserInfo()));
                    this.userDialog.hide();
                }
                catch (Throwable th) {
                    if (this.mainController != null && this.mainController.handleLostRepository(th)) break block5;
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"CantCreateUserDialog.Title", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Close", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"CantCreateUserDialog.Message", (String[])new String[]{th.getLocalizedMessage()}));
                    this.messageBox.open();
                }
            }
        }
    }

    public void showEditUserDialog() throws Exception {
        if (this.service != null && ((IRoleSupportSecurityManager)this.service).getRoles() != null) {
            this.eeSecurityUser.clear();
            this.eeSecurityUser.setUser(this.security.getSelectedUser(), this.convertToUIRoleModel(((IRoleSupportSecurityManager)this.service).getRoles()));
            this.eeSecurityUser.setMode(UISecurity.Mode.EDIT);
            this.userDialog.setTitle(BaseMessages.getString(PKG, (String)"EditUserDialog.Title", (String[])new String[0]));
            this.userDialog.show();
        }
    }

    protected void updateUser() {
        block3: {
            if (this.service != null) {
                try {
                    UIEERepositoryUser uiUser = (UIEERepositoryUser)this.eeSecurity.getSelectedUser();
                    HashSet<IUIRole> previousRoleList = new HashSet<IUIRole>();
                    previousRoleList.addAll(uiUser.getRoles());
                    uiUser.setDescription(this.eeSecurityUser.getDescription());
                    uiUser.setPassword(this.eeSecurityUser.getPassword());
                    uiUser.setRoles(new HashSet<IUIRole>(this.eeSecurityUser.getAssignedRoles()));
                    this.service.updateUser(uiUser.getUserInfo());
                    this.eeSecurity.updateUser(uiUser, previousRoleList);
                    this.userDialog.hide();
                }
                catch (Throwable th) {
                    if (this.mainController != null && this.mainController.handleLostRepository(th)) break block3;
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"UpdateUser.UnableToUpdateUser", (String[])new String[]{th.getLocalizedMessage()}));
                    this.messageBox.open();
                }
            }
        }
    }

    public void showAddRoleDialog() throws Exception {
        block3: {
            try {
                if (this.service != null && this.service.getUsers() != null) {
                    this.securityRole.clear();
                    this.securityRole.setAvailableUsers(this.convertToUIUserModel(this.service.getUsers()));
                }
                this.roleDialog.setTitle(BaseMessages.getString(PKG, (String)"AddRoleDialog.Title", (String[])new String[0]));
                this.roleDialog.show();
            }
            catch (KettleException e) {
                if (this.mainController != null && this.mainController.handleLostRepository((Throwable)e)) break block3;
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"SecurityController.AddRole.UnableToShowAddRole", (String[])new String[]{e.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
    }

    public void showAddUserToRoleDialog() throws Exception {
        if (this.service != null && this.service.getUsers() != null) {
            this.securityRole.clear();
            this.securityRole.setRole(((UIEESecurity)this.security).getSelectedRole(), this.convertToUIUserModel(this.service.getUsers()));
            this.securityRole.setMode(UISecurity.Mode.EDIT_MEMBER);
        }
        this.roleDialog.setTitle(BaseMessages.getString(PKG, (String)"AddUserToRoleDialog.Title", (String[])new String[0]));
        this.roleDialog.show();
    }

    public void showAddRoleToUserDialog() throws Exception {
        if (this.service != null && ((IRoleSupportSecurityManager)this.service).getRoles() != null) {
            this.eeSecurityUser.clear();
            this.eeSecurityUser.setUser(this.security.getSelectedUser(), this.convertToUIRoleModel(((IRoleSupportSecurityManager)this.service).getRoles()));
            this.eeSecurityUser.setMode(UISecurity.Mode.EDIT_MEMBER);
            this.userDialog.setTitle(BaseMessages.getString(PKG, (String)"AddRoleToUserDialog.Title", (String[])new String[0]));
            this.userDialog.show();
        }
    }

    public void removeRolesFromUser() throws Exception {
        ((UIEESecurity)this.security).removeRolesFromSelectedUser(this.userDetailTable.getSelectedItems());
        this.service.updateUser(this.security.getSelectedUser().getUserInfo());
    }

    public void removeUsersFromRole() throws Exception {
        ((UIEESecurity)this.security).removeUsersFromSelectedRole(this.roleDetailTable.getSelectedItems());
        ((IRoleSupportSecurityManager)this.service).updateRole(((UIEESecurity)this.security).getSelectedRole().getRole());
    }

    private void addRole() {
        block4: {
            if (this.service != null) {
                try {
                    if (this.securityRole.getName().isEmpty()) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"CantCreateRoleDialog.RoleNameIsMandatory", (String[])new String[0]));
                    }
                    IRole role = this.securityRole.getRole((IRoleSupportSecurityManager)this.service);
                    ((IRoleSupportSecurityManager)this.service).createRole(role);
                    this.eeSecurity.addRole(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(role));
                    this.roleDialog.hide();
                }
                catch (Throwable th) {
                    if (this.mainController != null && this.mainController.handleLostRepository(th)) break block4;
                    this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"CantCreateRoleDialog.Title", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Close", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"CantCreateRoleDialog.Message", (String[])new String[]{th.getLocalizedMessage()}));
                    this.messageBox.open();
                }
            }
        }
    }

    private void updateRole() {
        if (this.service != null) {
            try {
                IUIRole uiRole = this.eeSecurity.getSelectedRole();
                HashSet<IUIUser> previousUserList = new HashSet<IUIUser>();
                previousUserList.addAll(uiRole.getUsers());
                uiRole.setDescription(this.securityRole.getDescription());
                uiRole.setUsers(new HashSet<IUIUser>(this.securityRole.getAssignedUsers()));
                ((IRoleSupportSecurityManager)this.service).updateRole(uiRole.getRole());
                this.eeSecurity.updateRole(uiRole, previousUserList);
                this.roleDialog.hide();
            }
            catch (Throwable th) {
                this.messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PKG, (String)"UpdateRole.UnableToUpdateRole", (String[])new String[]{th.getLocalizedMessage()}));
                this.messageBox.open();
            }
        }
    }

    public void removeRole() throws Exception {
        XulConfirmBox confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
        confirmBox.setTitle(BaseMessages.getString(PKG, (String)"ConfirmDialog.Title", (String[])new String[0]));
        confirmBox.setMessage(BaseMessages.getString(PKG, (String)"RemoveRoleConfirmDialog.Message", (String[])new String[0]));
        confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
        confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
        confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

            public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                if (returnCode == XulDialogCallback.Status.ACCEPT && EESecurityController.this.service != null) {
                    if (EESecurityController.this.eeSecurity != null && EESecurityController.this.eeSecurity.getSelectedRole() != null) {
                        try {
                            ((IRoleSupportSecurityManager)EESecurityController.this.service).deleteRole(EESecurityController.this.eeSecurity.getSelectedRole().getName());
                            EESecurityController.this.eeSecurity.removeRole(EESecurityController.this.eeSecurity.getSelectedRole().getName());
                        }
                        catch (Throwable th) {
                            EESecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                            EESecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                            EESecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveRole.UnableToRemoveRole", (String[])new String[]{th.getLocalizedMessage()}));
                            EESecurityController.this.messageBox.open();
                        }
                    } else {
                        EESecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                        EESecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                        EESecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveRole.NoRoleSelected", (String[])new String[0]));
                        EESecurityController.this.messageBox.open();
                    }
                }
            }

            public void onError(XulComponent sender, Throwable t) {
                if (EESecurityController.this.mainController == null || !EESecurityController.this.mainController.handleLostRepository(t)) {
                    EESecurityController.this.messageBox.setTitle(BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]));
                    EESecurityController.this.messageBox.setAcceptLabel(BaseMessages.getString((Class)PKG, (String)"Dialog.Ok", (String[])new String[0]));
                    EESecurityController.this.messageBox.setMessage(BaseMessages.getString((Class)PKG, (String)"RemoveRole.UnableToRemoveRole", (String[])new String[]{t.getLocalizedMessage()}));
                    EESecurityController.this.messageBox.open();
                }
            }
        });
        confirmBox.open();
    }

    public void showEditRoleDialog() throws Exception {
        if (this.service != null && this.service.getUsers() != null) {
            this.securityRole.clear();
            this.securityRole.setRole(this.eeSecurity.getSelectedRole(), this.convertToUIUserModel(this.service.getUsers()));
            this.securityRole.setMode(UISecurity.Mode.EDIT);
            this.roleDialog.setTitle(BaseMessages.getString(PKG, (String)"EditRoleDialog.Title", (String[])new String[0]));
            this.roleDialog.show();
        }
    }

    public void changeToRoleDeck() {
        this.security.setSelectedDeck(ObjectRecipient.Type.ROLE);
        this.instructionalTextLabel.setValue(BaseMessages.getString(PKG, (String)"SecurityTab.RoleInstructionalText", (String[])new String[0]));
    }

    public void changeToSystemRoleDeck() {
        this.security.setSelectedDeck(ObjectRecipient.Type.SYSTEM_ROLE);
        this.instructionalTextLabel.setValue(BaseMessages.getString(PKG, (String)"SecurityTab.SystemRoleInstructionalText", (String[])new String[0]));
    }

    public void saveRole() throws Exception {
        if (this.securityRole.getMode().equals((Object)UISecurity.Mode.ADD)) {
            this.addRole();
        } else {
            this.updateRole();
        }
    }

    private List<IUIRole> convertToUIRoleModel(List<IRole> roles) throws UIObjectCreationException {
        ArrayList<IUIRole> rroles = new ArrayList<IUIRole>();
        for (IRole role : roles) {
            rroles.add(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(role));
        }
        return rroles;
    }

    private List<IUIUser> convertToUIUserModel(List<IUser> users) throws UIObjectCreationException {
        ArrayList<IUIUser> rusers = new ArrayList<IUIUser>();
        for (IUser user : users) {
            rusers.add(UIObjectRegistry.getInstance().constructUIRepositoryUser(user));
        }
        return rusers;
    }

    protected void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        super.enableButtons(enableNew, enableEdit, enableRemove);
        this.roleAddButton.setDisabled(!enableNew);
        this.roleEditButton.setDisabled(!enableEdit);
        this.roleRemoveButton.setDisabled(!enableRemove);
        this.addUserToRoleButton.setDisabled(!enableNew);
        this.removeUserFromRoleButton.setDisabled(!enableNew);
        this.addRoleToUserButton.setDisabled(!enableNew);
        this.removeRoleFromUserButton.setDisabled(!enableNew);
    }

    protected void showButtons(boolean showNew, boolean showEdit, boolean showRemove) {
        super.showButtons(showNew, showEdit, showRemove);
        this.roleAddButton.setVisible(showNew);
        this.roleEditButton.setVisible(showEdit);
        this.roleRemoveButton.setVisible(showRemove);
        this.addUserToRoleButton.setVisible(showNew);
        this.removeUserFromRoleButton.setVisible(showNew);
        this.addRoleToUserButton.setVisible(showNew);
        this.removeRoleFromUserButton.setVisible(showNew);
    }
}

