/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur.model;

import java.io.Serializable;
import java.util.Date;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.PurRepositoryElementMetaInterface;
import org.pentaho.di.repository.pur.model.ILockObject;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;

public class EERepositoryObject
extends RepositoryObject
implements ILockObject,
PurRepositoryElementMetaInterface,
Serializable {
    private static final long serialVersionUID = -566113926064789982L;
    private String lockMessage;
    private RepositoryLock lock;
    private Boolean versioningEnabled;
    private Boolean versionCommentEnabled;

    public EERepositoryObject() {
    }

    public EERepositoryObject(RepositoryFileTree repoTree, RepositoryDirectoryInterface repositoryDirectory, String modifiedUser, RepositoryObjectType objectType, String description, RepositoryLock lock, boolean deleted) {
        this(repoTree.getFile(), repositoryDirectory, modifiedUser, objectType, description, lock, deleted);
        this.setVersioningEnabled(repoTree.getVersioningEnabled());
        this.setVersionCommentEnabled(repoTree.getVersionCommentEnabled());
    }

    public EERepositoryObject(RepositoryFile file, RepositoryDirectoryInterface repositoryDirectory, String modifiedUser, RepositoryObjectType objectType, String description, RepositoryLock lock, boolean deleted) {
        this((ObjectId)new StringObjectId(file.getId().toString()), file.getTitle(), repositoryDirectory, modifiedUser, file.getLastModifiedDate(), objectType, description, lock, deleted);
    }

    public EERepositoryObject(RepositoryFile file, RepositoryDirectoryInterface repositoryDirectory, String modifiedUser, RepositoryObjectType objectType, String description, RepositoryLock lock, boolean deleted, Boolean versioningEnabled, Boolean versionCommentEnabled) {
        this((ObjectId)new StringObjectId(file.getId().toString()), file.getTitle(), repositoryDirectory, modifiedUser, file.getLastModifiedDate(), objectType, description, lock, deleted);
        this.setVersioningEnabled(versioningEnabled);
        this.setVersionCommentEnabled(versionCommentEnabled);
    }

    public EERepositoryObject(ObjectId objectId, String name, RepositoryDirectoryInterface repositoryDirectory, String modifiedUser, Date modifiedDate, RepositoryObjectType objectType, String description, RepositoryLock lock, boolean deleted) {
        super(objectId, name, repositoryDirectory, modifiedUser, modifiedDate, objectType, description, deleted);
        this.setLock(lock);
    }

    @Override
    public boolean isLocked() {
        return this.lock != null;
    }

    @Override
    public String getLockMessage() {
        return this.lockMessage;
    }

    @Override
    public RepositoryLock getLock() {
        return this.lock;
    }

    @Override
    public void setLock(RepositoryLock lock) {
        this.lock = lock;
        this.lockMessage = lock == null ? null : lock.getMessage() + " (" + lock.getLogin() + " since " + XMLHandler.date2string((Date)lock.getLockDate()) + ")";
    }

    @Override
    public Boolean getVersioningEnabled() {
        return this.versioningEnabled;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    @Override
    public Boolean getVersionCommentEnabled() {
        return this.versionCommentEnabled;
    }

    public void setVersionCommentEnabled(Boolean versionCommentEnabled) {
        this.versionCommentEnabled = versionCommentEnabled;
    }
}

