/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryCommonValidations;
import org.pentaho.di.repository.RepositorySecurityUserValidator;
import org.pentaho.di.repository.pur.IUserRoleListChangeListener;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.repository.pur.ServiceManager;
import org.pentaho.di.repository.pur.UserRoleDelegate;
import org.pentaho.di.repository.pur.model.EERoleInfo;
import org.pentaho.di.repository.pur.model.EEUserInfo;
import org.pentaho.di.repository.pur.model.IRole;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.pur.services.RepositorySecurityRoleValidator;
import org.pentaho.platform.security.userroledao.ws.UserRoleException;

public class PurRepositorySecurityManager
implements IRoleSupportSecurityManager,
IUserRoleListChangeListener,
Serializable,
RepositorySecurityUserValidator,
RepositorySecurityRoleValidator {
    private static final long serialVersionUID = 6820830385234412904L;
    private PurRepository repository;
    private UserRoleDelegate userRoleDelegate;
    private static final Log logger = LogFactory.getLog(UserRoleDelegate.class);

    public PurRepositorySecurityManager(PurRepository repository, PurRepositoryMeta repositoryMeta, IUser user, ServiceManager serviceManager) {
        this.repository = repository;
        this.userRoleDelegate = new UserRoleDelegate(this, repositoryMeta, user, logger, serviceManager);
        this.userRoleDelegate.addUserRoleListChangeListener(this);
        this.setUserRoleDelegate(this.userRoleDelegate);
    }

    public UserRoleDelegate getUserRoleDelegate() {
        return this.userRoleDelegate;
    }

    public void setUserRoleDelegate(UserRoleDelegate userRoleDelegate) {
        this.userRoleDelegate = userRoleDelegate;
    }

    public PurRepository getRepository() {
        return this.repository;
    }

    public boolean supportsMetadata() {
        return true;
    }

    public boolean supportsRevisions() {
        return true;
    }

    public boolean supportsUsers() {
        return true;
    }

    public void delUser(ObjectId id_user) throws KettleException {
    }

    public ObjectId getUserID(String login) throws KettleException {
        return null;
    }

    public ObjectId[] getUserIDs() throws KettleException {
        return null;
    }

    public IUser loadUserInfo(String login) throws KettleException {
        IUser user = this.constructUser();
        user.setLogin(login);
        user.setName(login);
        return user;
    }

    public IUser loadUserInfo(String login, String password) throws KettleException {
        IUser user = this.constructUser();
        user.setLogin(login);
        user.setPassword(password);
        user.setName(login);
        return user;
    }

    public void renameUser(ObjectId id_user, String newname) throws KettleException {
    }

    public void saveUserInfo(IUser user) throws KettleException {
        this.normalizeUserInfo(user);
        if (!this.validateUserInfo(user)) {
            throw new KettleException(BaseMessages.getString(PurRepositorySecurityManager.class, (String)"PurRepositorySecurityManager.ERROR_0001_INVALID_NAME", (String[])new String[0]));
        }
        this.userRoleDelegate.createUser(user);
    }

    public boolean validateUserInfo(IUser user) {
        return RepositoryCommonValidations.checkUserInfo((IUser)user);
    }

    public void normalizeUserInfo(IUser user) {
        RepositoryCommonValidations.normalizeUserInfo((IUser)user);
    }

    @Override
    public void createRole(IRole newRole) throws KettleException {
        this.normalizeRoleInfo(newRole);
        if (!this.validateRoleInfo(newRole)) {
            throw new KettleException(BaseMessages.getString(PurRepositorySecurityManager.class, (String)"PurRepositorySecurityManager.ERROR_0001_INVALID_NAME", (String[])new String[0]));
        }
        this.userRoleDelegate.createRole(newRole);
    }

    @Override
    public boolean validateRoleInfo(IRole role) {
        return StringUtils.isNotBlank((String)role.getName());
    }

    @Override
    public void normalizeRoleInfo(IRole role) {
        role.setName(role.getName().trim());
    }

    @Override
    public void deleteRoles(List<IRole> roles) throws KettleException {
        this.userRoleDelegate.deleteRoles(roles);
    }

    public void deleteUsers(List<IUser> users) throws KettleException {
        this.userRoleDelegate.deleteUsers(users);
    }

    @Override
    public IRole getRole(String name) throws KettleException {
        return this.userRoleDelegate.getRole(name);
    }

    @Override
    public List<IRole> getRoles() throws KettleException {
        return this.userRoleDelegate.getRoles();
    }

    @Override
    public List<IRole> getDefaultRoles() throws KettleException {
        return this.userRoleDelegate.getDefaultRoles();
    }

    @Override
    public void updateRole(IRole role) throws KettleException {
        this.userRoleDelegate.updateRole(role);
    }

    public void updateUser(IUser user) throws KettleException {
        this.userRoleDelegate.updateUser(user);
    }

    public void delUser(String name) throws KettleException {
        this.userRoleDelegate.deleteUser(name);
    }

    @Override
    public void deleteRole(String name) throws KettleException {
        this.userRoleDelegate.deleteRole(name);
    }

    public List<IUser> getUsers() throws KettleException {
        return this.userRoleDelegate.getUsers();
    }

    @Override
    public void setRoles(List<IRole> roles) throws KettleException {
        this.userRoleDelegate.setRoles(roles);
    }

    public void setUsers(List<IUser> users) throws KettleException {
        this.userRoleDelegate.setUsers(users);
    }

    @Override
    public IRole constructRole() throws KettleException {
        return new EERoleInfo();
    }

    public IUser constructUser() throws KettleException {
        return new EEUserInfo();
    }

    @Override
    public void onChange() {
        try {
            this.userRoleDelegate.updateUserRoleInfo();
        }
        catch (UserRoleException e) {
            e.printStackTrace();
        }
    }

    public static Log getLogger() {
        return logger;
    }

    public boolean isManaged() throws KettleException {
        return this.userRoleDelegate.isManaged();
    }
}

