/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.purge;

import com.pentaho.di.purge.PurgeUtilityHTMLLayout;
import com.pentaho.di.purge.PurgeUtilityTextLayout;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.WriterAppender;

public class PurgeUtilityLog {
    private Logger logger;
    static final String FILE_KEY = "currentFile";
    private OutputStream outputStream;
    private String currentFilePath;
    private String logName;
    private String purgePath;
    private Level logLevel;
    private WriterAppender writeAppender;
    protected static Class layoutClass = PurgeUtilityTextLayout.class;

    PurgeUtilityLog() {
    }

    PurgeUtilityLog(OutputStream outputStream, String purgePath, Level logLevel) {
        this.outputStream = outputStream;
        this.purgePath = purgePath;
        this.logLevel = logLevel;
        this.init();
    }

    private void init() {
        this.logName = "PurgeUtilityLog." + this.getThreadName();
        this.logger = Logger.getLogger((String)this.logName);
        this.logger.setLevel(this.logLevel);
        Layout layout = layoutClass == PurgeUtilityHTMLLayout.class ? new PurgeUtilityHTMLLayout(this.logLevel) : new PurgeUtilityTextLayout(this.logLevel);
        layout.setTitle("Purge Utility Log");
        this.writeAppender = new WriterAppender(layout, (Writer)new OutputStreamWriter(this.outputStream, Charset.forName("utf-8")));
        this.logger.addAppender((Appender)this.writeAppender);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            return Logger.getLogger((String)Thread.currentThread().getStackTrace()[4].getClassName());
        }
        return this.logger;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public void setCurrentFilePath(String currentFilePath) {
        this.currentFilePath = currentFilePath;
        if (currentFilePath != null) {
            MDC.put((String)FILE_KEY, (Object)currentFilePath);
        }
    }

    public String getPurgePath() {
        return this.purgePath;
    }

    protected void endJob() {
        try {
            this.outputStream.write(this.writeAppender.getLayout().getFooter().getBytes());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.logger.removeAppender(this.logName);
    }

    private String getThreadName() {
        return Thread.currentThread().getName();
    }
}

