/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.extender.requirejs.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.pentaho.requirejs.IRequireJsPackage;
import org.pentaho.webpackage.core.IPentahoWebPackage;

public class RequireJsPackageImpl
implements IRequireJsPackage {
    private final IPentahoWebPackage pentahoWebPackage;
    private final URI resourceRoot;
    private final Map<String, String> modules;
    private final Map<String, String> packages;
    private final Map<String, String> dependencies;
    private final Map<String, String> scripts;
    private final Map<String, Map<String, ?>> config;
    private final Map<String, Map<String, String>> localMap;
    private final Map<String, Map<String, ?>> shim;
    private boolean preferGlobal;

    public RequireJsPackageImpl(IPentahoWebPackage pentahoWebPackage, URI resourceRoot) {
        this.pentahoWebPackage = pentahoWebPackage;
        this.resourceRoot = resourceRoot;
        this.modules = new HashMap<String, String>();
        this.packages = new HashMap<String, String>();
        this.dependencies = new HashMap<String, String>();
        this.scripts = new HashMap<String, String>();
        this.config = new HashMap();
        this.localMap = new HashMap<String, Map<String, String>>();
        this.shim = new HashMap();
        this.init();
    }

    public String getName() {
        return this.pentahoWebPackage.getName();
    }

    public String getVersion() {
        return this.pentahoWebPackage.getVersion();
    }

    public String getWebRootPath() {
        return this.pentahoWebPackage.getWebRootPath();
    }

    public boolean preferGlobal() {
        return this.preferGlobal;
    }

    public Map<String, String> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public String getModuleMainFile(String moduleId) {
        return this.packages.get(moduleId);
    }

    public Map<String, String> getDependencies() {
        return Collections.unmodifiableMap(this.dependencies);
    }

    public boolean hasScript(String name) {
        return this.scripts.containsKey(name);
    }

    public URL getScriptResource(String name) {
        URL url = null;
        try {
            url = this.resourceRoot.resolve(this.scripts.get(name)).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public Map<String, Map<String, ?>> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public Map<String, Map<String, String>> getMap() {
        return Collections.unmodifiableMap(this.localMap);
    }

    public Map<String, Map<String, ?>> getShim() {
        return Collections.unmodifiableMap(this.shim);
    }

    private void init() {
        Map packageJson = this.pentahoWebPackage.getPackageJson();
        this.initFromPackageJson(packageJson);
    }

    private void initFromPackageJson(Map<String, Object> json) {
        if (!json.containsKey("paths")) {
            this.addModule(this.getName(), "/", this.mainFile(json));
        }
        this.preferGlobal = false;
        json.forEach(new BiConsumer<String, Object>(){

            @Override
            public void accept(String key, Object value) {
                switch (key) {
                    case "paths": {
                        Map paths = (Map)value;
                        RequireJsPackageImpl.this.processPaths(paths);
                        break;
                    }
                    case "packages": {
                        List packages = (List)value;
                        RequireJsPackageImpl.this.processPackages(packages);
                        break;
                    }
                    case "dependencies": {
                        Map dependencies = (Map)value;
                        RequireJsPackageImpl.this.processDependencies(dependencies);
                        break;
                    }
                    case "scripts": {
                        Map scripts = (Map)value;
                        RequireJsPackageImpl.this.processScripts(scripts);
                        break;
                    }
                    case "config": {
                        Map config = (Map)value;
                        RequireJsPackageImpl.this.processConfig(config);
                        break;
                    }
                    case "map": {
                        Map mappings = (Map)value;
                        RequireJsPackageImpl.this.processMap(mappings);
                        break;
                    }
                    case "shim": {
                        Map shim = (Map)value;
                        RequireJsPackageImpl.this.processShim(shim);
                        break;
                    }
                    case "preferGlobal": {
                        RequireJsPackageImpl.this.preferGlobal = (Boolean)value;
                        break;
                    }
                }
            }
        });
    }

    private String mainFile(Map<String, Object> json) {
        String pck = null;
        if (json.containsKey("main")) {
            Object value = json.get("main");
            if (value instanceof String) {
                pck = this.processMainField((String)value);
            } else if (value instanceof List) {
                List files = (List)value;
                for (Object file : files) {
                    String pack = this.processMainField((String)file);
                    if (pack == null) continue;
                    pck = pack;
                    break;
                }
            }
        }
        if (json.containsKey("unpkg")) {
            pck = this.processAlternateMainField(json.get("unpkg"));
        } else if (json.containsKey("jsdelivr")) {
            pck = this.processAlternateMainField(json.get("jsdelivr"));
        } else if (json.containsKey("browser")) {
            pck = this.processAlternateMainField(json.get("browser"));
        }
        return pck;
    }

    private String processAlternateMainField(Object value) {
        String pck = null;
        if (value instanceof String) {
            pck = this.processMainField((String)value);
        } else if (value instanceof Map) {
            Map overridePaths = (Map)value;
            for (String overridePath : overridePaths.keySet()) {
                Object replaceRawValue = overridePaths.get(overridePath);
                if (replaceRawValue instanceof String) {
                    String replaceValue = (String)replaceRawValue;
                    if (overridePath.startsWith("./")) {
                        if (replaceValue.startsWith("./")) {
                            replaceValue = replaceValue.substring(2);
                        }
                        this.addModule(this.getName() + this.removeJsExtension(overridePath.substring(1)), "/" + this.removeJsExtension(replaceValue));
                        continue;
                    }
                    if (replaceValue.startsWith("./")) {
                        replaceValue = this.getName() + replaceValue.substring(1);
                    }
                    this.addMap(this.getName(), this.removeJsExtension(overridePath), this.removeJsExtension(replaceValue));
                    continue;
                }
                String toIgnore = overridePath.startsWith("./") ? this.getName() + this.removeJsExtension(overridePath.substring(1)) : this.removeJsExtension(overridePath);
                this.addMap(this.getName(), toIgnore, "no-where-to-be-found");
            }
        }
        return pck;
    }

    private String processMainField(String file) {
        if (file.startsWith("./")) {
            file = file.substring(2);
        } else if (file.startsWith("/")) {
            file = file.substring(1);
        }
        if (file.endsWith(".js")) {
            return this.removeJsExtension(file);
        }
        return null;
    }

    private String removeJsExtension(String filename) {
        if (!filename.endsWith(".js")) {
            return filename;
        }
        return filename.substring(0, filename.length() - 3);
    }

    private void processPaths(Map<String, ?> paths) {
        paths.forEach((moduleId, path) -> {
            if (path instanceof String) {
                this.addModule((String)moduleId, (String)path);
            }
        });
    }

    private void processPackages(List<Object> packages) {
        packages.forEach(packageDefinition -> {
            HashMap packageObj;
            if (packageDefinition instanceof String) {
                String packageName = (String)packageDefinition;
                this.addModule(packageName, this.modules.get(packageName), "main");
            } else if (packageDefinition instanceof HashMap && (packageObj = (HashMap)packageDefinition).containsKey("name")) {
                String packageName = (String)packageObj.get("name");
                String path = packageObj.getOrDefault("location", this.modules.get(packageName));
                String mainScript = packageObj.getOrDefault("main", "main");
                this.addModule(packageName, path, mainScript);
            }
        });
    }

    private void addModule(String moduleId, String path, String main) {
        this.modules.put(moduleId, path);
        if (main != null) {
            this.packages.put(moduleId, main);
        }
    }

    private void addModule(String moduleId, String path) {
        this.addModule(moduleId, path, null);
    }

    private void processDependencies(Map<String, ?> dependencies) {
        dependencies.forEach((packageName, version) -> {
            if (version instanceof String) {
                this.addDependency((String)packageName, (String)version);
            }
        });
    }

    private void addDependency(String packageName, String version) {
        this.dependencies.put(packageName, version);
    }

    private void processScripts(Map<String, ?> scripts) {
        scripts.forEach((name, file) -> {
            if (file instanceof String) {
                this.addScript((String)name, (String)file);
            }
        });
    }

    private void addScript(String name, String file) {
        this.scripts.put(name, file);
    }

    private void processConfig(Map<String, ?> config) {
        config.forEach((moduleId, configuration) -> {
            if (configuration instanceof Map) {
                this.addConfig((String)moduleId, (Map)configuration);
            }
        });
    }

    private void addConfig(String moduleId, Map<String, ?> configuration) {
        this.config.put(moduleId, configuration);
    }

    private void processMap(Map<String, Map<String, ?>> mappings) {
        mappings.forEach((where, map) -> map.forEach((originalModuleId, mappedModuleId) -> {
            if (mappedModuleId instanceof String) {
                this.addMap((String)where, (String)originalModuleId, (String)mappedModuleId);
            }
        }));
    }

    private void addMap(String where, String originalModuleId, String mappedModuleId) {
        this.localMap.computeIfAbsent(where, m -> new HashMap()).put(originalModuleId, mappedModuleId);
    }

    private void processShim(Map<String, ?> shim) {
        shim.forEach((moduleId, configuration) -> {
            if (configuration instanceof Map) {
                this.addShim((String)moduleId, (Map)configuration);
            } else if (configuration instanceof List) {
                HashMap<String, Object> deps = new HashMap<String, Object>();
                deps.put("deps", configuration);
                this.addShim((String)moduleId, (Map<String, ?>)deps);
            }
        });
    }

    private void addShim(String moduleId, Map<String, ?> configuration) {
        this.shim.put(moduleId, configuration);
    }
}

