/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SalesforceInputField
implements Cloneable {
    private static Class<?> PKG = SalesforceInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Both", (String[])new String[0])};
    @Injection(name="NAME", group="FIELDS")
    private String name;
    @Injection(name="FIELD", group="FIELDS")
    private String field;
    private int type;
    @Injection(name="LENGTH", group="FIELDS")
    private int length;
    @Injection(name="FORMAT", group="FIELDS")
    private String format;
    private int trimtype;
    @Injection(name="PRECISION", group="FIELDS")
    private int precision;
    @Injection(name="CURRENCY", group="FIELDS")
    private String currencySymbol;
    @Injection(name="DECIMAL", group="FIELDS")
    private String decimalSymbol;
    @Injection(name="GROUP", group="FIELDS")
    private String groupSymbol;
    @Injection(name="REPEAT", group="FIELDS")
    private boolean repeat;
    @Injection(name="ISIDLOOKUP", group="FIELDS")
    private boolean idlookup;
    private String[] samples;

    public SalesforceInputField(String fieldname) {
        this.name = fieldname;
        this.field = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.idlookup = false;
    }

    public SalesforceInputField() {
        this("");
    }

    public SalesforceInputField(Node fnode) throws KettleStepException {
        this.readData(fnode);
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XMLHandler.openTag((String)"field")).append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.getField()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"idlookup", (boolean)this.isIdLookup()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        retval.append("      ").append(XMLHandler.closeTag((String)"field")).append(Const.CR);
        return retval.toString();
    }

    public void readData(Node fnode) {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setField(XMLHandler.getTagValue((Node)fnode, (String)"field"));
        this.setIdLookup("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"idlookup")));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(SalesforceInputField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, int fieldNr) throws KettleException {
        this.setName(rep.getStepAttributeString(idStep, fieldNr, "field_name"));
        this.setField(rep.getStepAttributeString(idStep, fieldNr, "field_attribut"));
        this.setIdLookup(rep.getStepAttributeBoolean(idStep, fieldNr, "field_idlookup"));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(idStep, fieldNr, "field_type")));
        this.setFormat(rep.getStepAttributeString(idStep, fieldNr, "field_format"));
        this.setCurrencySymbol(rep.getStepAttributeString(idStep, fieldNr, "field_currency"));
        this.setDecimalSymbol(rep.getStepAttributeString(idStep, fieldNr, "field_decimal"));
        this.setGroupSymbol(rep.getStepAttributeString(idStep, fieldNr, "field_group"));
        this.setLength((int)rep.getStepAttributeInteger(idStep, fieldNr, "field_length"));
        this.setPrecision((int)rep.getStepAttributeInteger(idStep, fieldNr, "field_precision"));
        this.setTrimType(SalesforceInputField.getTrimTypeByCode(rep.getStepAttributeString(idStep, fieldNr, "field_trim_type")));
        this.setRepeated(rep.getStepAttributeBoolean(idStep, fieldNr, "field_repeat"));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep, int fieldNr) throws KettleException {
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_name", this.getName());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_attribut", this.getField());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_idlookup", this.isIdLookup());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_type", this.getTypeDesc());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_format", this.getFormat());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_currency", this.getCurrencySymbol());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_decimal", this.getDecimalSymbol());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_group", this.getGroupSymbol());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_length", (long)this.getLength());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_precision", (long)this.getPrecision());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_trim_type", this.getTrimTypeCode());
        rep.saveStepAttribute(idTransformation, idStep, fieldNr, "field_repeat", this.isRepeated());
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return SalesforceInputField.getTrimTypeByCode(tt);
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            return (SalesforceInputField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String fieldvalue) {
        this.field = fieldvalue;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="TYPE", group="FIELDS")
    public void setType(String typeDesc) {
        this.type = ValueMetaFactory.getIdForValueMeta((String)typeDesc);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return SalesforceInputField.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return SalesforceInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    @Injection(name="TRIM_TYPE", group="FIELDS")
    public void setTrimTypeDesc(String trimTypeDesc) {
        this.trimtype = SalesforceInputField.getTrimTypeByDesc(trimTypeDesc);
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isIdLookup() {
        return this.idlookup;
    }

    public void setIdLookup(boolean idlookup) {
        this.idlookup = idlookup;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }
}

