/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.meta;

import com.pentaho.big.data.bundles.impl.shim.hbase.meta.HBaseValueMetaInterfaceImpl;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.w3c.dom.Node;

public class HBaseValueMetaInterfaceFactoryImpl
implements HBaseValueMetaInterfaceFactory {
    private final HBaseBytesUtilShim hBaseBytesUtilShim;

    public HBaseValueMetaInterfaceFactoryImpl(HBaseBytesUtilShim hBaseBytesUtilShim) {
        this.hBaseBytesUtilShim = hBaseBytesUtilShim;
    }

    public HBaseValueMetaInterfaceImpl createHBaseValueMetaInterface(String family, String column, String alias, int type, int length, int precision) throws IllegalArgumentException {
        return this.createHBaseValueMetaInterface(family + "," + column + "," + alias, type, length, precision);
    }

    public HBaseValueMetaInterfaceImpl createHBaseValueMetaInterface(String name, int type, int length, int precision) throws IllegalArgumentException {
        return new HBaseValueMetaInterfaceImpl(name, type, length, precision, this.hBaseBytesUtilShim);
    }

    public List<HBaseValueMetaInterface> createListFromRepository(Repository rep, ObjectId id_step) throws KettleException {
        int nrfields = rep.countNrStepAttributes(id_step, "table_name");
        ArrayList<HBaseValueMetaInterface> m_outputFields = new ArrayList<HBaseValueMetaInterface>(nrfields);
        if (nrfields > 0) {
            for (int i = 0; i < nrfields; ++i) {
                m_outputFields.add(this.createFromRepository(rep, id_step, i));
            }
        }
        return m_outputFields;
    }

    public HBaseValueMetaInterfaceImpl createFromRepository(Repository rep, ObjectId id_step, int i) throws KettleException {
        String indexValues;
        String typeS;
        String alias;
        String colName;
        String colFamily = rep.getStepAttributeString(id_step, i, "family");
        if (!Const.isEmpty((String)colFamily)) {
            colFamily = colFamily.trim();
        }
        if (!Const.isEmpty((String)(colName = rep.getStepAttributeString(id_step, i, "column")))) {
            colName = colName.trim();
        }
        if (!Const.isEmpty((String)(alias = rep.getStepAttributeString(id_step, i, "alias")))) {
            alias = alias.trim();
        }
        if (!Const.isEmpty((String)(typeS = rep.getStepAttributeString(id_step, i, "type")))) {
            typeS = typeS.trim();
        }
        boolean isKey = rep.getStepAttributeBoolean(id_step, i, "key");
        HBaseValueMetaInterfaceImpl vm = this.createHBaseValueMetaInterface(colFamily, colName, alias, ValueMeta.getType((String)typeS), -1, -1);
        vm.setTableName(rep.getStepAttributeString(id_step, i, "table_name"));
        vm.setMappingName(rep.getStepAttributeString(id_step, i, "mapping_name"));
        vm.setKey(isKey);
        String format = rep.getStepAttributeString(id_step, i, "format");
        if (!Const.isEmpty((String)format)) {
            vm.setConversionMask(format);
        }
        if (!Const.isEmpty((String)(indexValues = rep.getStepAttributeString(id_step, i, "index_values")))) {
            Object[] labels = indexValues.replace("{", "").replace("}", "").split(",");
            if (labels.length < 1) {
                throw new KettleXMLException("Indexed/nominal type must have at least one label declared");
            }
            for (int j = 0; j < labels.length; ++j) {
                labels[j] = ((String)labels[j]).trim();
            }
            vm.setIndex(labels);
            vm.setStorageType(2);
        }
        return vm;
    }

    public List<HBaseValueMetaInterface> createListFromNode(Node stepnode) throws KettleXMLException {
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"output_fields");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        ArrayList<HBaseValueMetaInterface> m_outputFields = new ArrayList<HBaseValueMetaInterface>(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            m_outputFields.add(this.createFromNode(XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i)));
        }
        return m_outputFields;
    }

    public HBaseValueMetaInterfaceImpl createFromNode(Node fieldNode) throws KettleXMLException {
        String indexValues;
        String isKey = XMLHandler.getTagValue((Node)fieldNode, (String)"key").trim();
        String alias = XMLHandler.getTagValue((Node)fieldNode, (String)"alias").trim();
        String colFamily = "";
        String colName = alias;
        if (!isKey.equalsIgnoreCase("Y")) {
            if (XMLHandler.getTagValue((Node)fieldNode, (String)"family") != null) {
                colFamily = XMLHandler.getTagValue((Node)fieldNode, (String)"family").trim();
            }
            if (XMLHandler.getTagValue((Node)fieldNode, (String)"column") != null) {
                colName = XMLHandler.getTagValue((Node)fieldNode, (String)"column").trim();
            }
        }
        String typeS = XMLHandler.getTagValue((Node)fieldNode, (String)"type").trim();
        HBaseValueMetaInterfaceImpl vm = this.createHBaseValueMetaInterface(colFamily, colName, alias, ValueMeta.getType((String)typeS), -1, -1);
        vm.setTableName(XMLHandler.getTagValue((Node)fieldNode, (String)"table_name"));
        vm.setMappingName(XMLHandler.getTagValue((Node)fieldNode, (String)"mapping_name"));
        vm.setKey(isKey.equalsIgnoreCase("Y"));
        String format = XMLHandler.getTagValue((Node)fieldNode, (String)"format");
        if (!Const.isEmpty((String)format)) {
            vm.setConversionMask(format);
        }
        if (!Const.isEmpty((String)(indexValues = XMLHandler.getTagValue((Node)fieldNode, (String)"index_values")))) {
            Object[] labels = indexValues.replace("{", "").replace("}", "").split(",");
            if (labels.length < 1) {
                throw new KettleXMLException("Indexed/nominal type must have at least one label declared");
            }
            for (int j = 0; j < labels.length; ++j) {
                labels[j] = ((String)labels[j]).trim();
            }
            vm.setIndex(labels);
            vm.setStorageType(2);
        }
        return vm;
    }

    public HBaseValueMetaInterfaceImpl copy(HBaseValueMetaInterface hBaseValueMetaInterface) {
        HBaseValueMetaInterfaceImpl result = this.createHBaseValueMetaInterface(hBaseValueMetaInterface.getColumnFamily(), hBaseValueMetaInterface.getColumnName(), hBaseValueMetaInterface.getName(), hBaseValueMetaInterface.getType(), hBaseValueMetaInterface.getLength(), hBaseValueMetaInterface.getPrecision());
        result.setTableName(hBaseValueMetaInterface.getTableName());
        result.setMappingName(hBaseValueMetaInterface.getMappingName());
        result.setKey(hBaseValueMetaInterface.isKey());
        result.setConversionMask(hBaseValueMetaInterface.getConversionMask());
        result.setIndex(hBaseValueMetaInterface.getIndex());
        result.setStorageType(hBaseValueMetaInterface.getStorageType());
        result.setIsLongOrDouble(hBaseValueMetaInterface.getIsLongOrDouble());
        return result;
    }

    public HBaseValueMetaInterfaceImpl copy(HBaseValueMeta hBaseValueMeta) {
        HBaseValueMetaInterfaceImpl result = this.createHBaseValueMetaInterface(hBaseValueMeta.getColumnFamily(), hBaseValueMeta.getColumnName(), hBaseValueMeta.getName(), hBaseValueMeta.getType(), hBaseValueMeta.getLength(), hBaseValueMeta.getPrecision());
        result.setTableName(hBaseValueMeta.getTableName());
        result.setMappingName(hBaseValueMeta.getMappingName());
        result.setKey(hBaseValueMeta.isKey());
        result.setConversionMask(hBaseValueMeta.getConversionMask());
        result.setIndex(hBaseValueMeta.getIndex());
        result.setStorageType(hBaseValueMeta.getStorageType());
        result.setIsLongOrDouble(hBaseValueMeta.getIsLongOrDouble());
        return result;
    }
}

