/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase;

public class FilePathModifierUtil {
    private static final String FILE_SCHEME_PREFIX = "file:///";
    private static final String WINDOWS_SPECIFIC_STRING = ":\\";
    private static final String PATH_SCHEME_STRING = "://";

    public static String modifyPathToConfigFileIfNecessary(String pathToFile) {
        String modifiedPathToFile = FilePathModifierUtil.modifyIfNullValue(pathToFile);
        return FilePathModifierUtil.isWindowsSpecificPath(modifiedPathToFile) && !FilePathModifierUtil.hasPathScheme(modifiedPathToFile) ? FilePathModifierUtil.addFileSchemeToPath(modifiedPathToFile) : modifiedPathToFile;
    }

    private static boolean isWindowsSpecificPath(String pathToFile) {
        return pathToFile.contains(WINDOWS_SPECIFIC_STRING);
    }

    private static boolean hasPathScheme(String pathToFile) {
        return pathToFile.contains(PATH_SCHEME_STRING);
    }

    private static String addFileSchemeToPath(String pathToFile) {
        return FILE_SCHEME_PREFIX.concat(pathToFile);
    }

    private static String modifyIfNullValue(String pathToFile) {
        return pathToFile == null ? "" : pathToFile;
    }
}

