/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreFileSystemImpl
extends StateStoreFileBaseImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileSystemImpl.class);
    public static final String FEDERATION_STORE_FS_PATH = "dfs.federation.router.store.driver.fs.path";
    private FileSystem fs;
    private String workPath;

    @Override
    protected boolean exists(String path) {
        try {
            return this.fs.exists(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean mkdir(String path) {
        try {
            return this.fs.mkdirs(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected String getRootDir() {
        if (this.workPath == null) {
            String rootPath = this.getConf().get(FEDERATION_STORE_FS_PATH);
            try {
                URI workUri = new URI(rootPath);
                this.fs = FileSystem.get((URI)workUri, (Configuration)this.getConf());
            }
            catch (Exception ex) {
                return null;
            }
            this.workPath = rootPath;
        }
        return this.workPath;
    }

    @Override
    public void close() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    private Path getPathForClass(Class<? extends BaseRecord> clazz) {
        if (clazz == null) {
            return null;
        }
        String className = StateStoreUtils.getRecordName(clazz);
        return new Path(this.workPath, className);
    }

    @Override
    protected <T extends BaseRecord> void lockRecordRead(Class<T> clazz) {
    }

    @Override
    protected <T extends BaseRecord> void unlockRecordRead(Class<T> clazz) {
    }

    @Override
    protected <T extends BaseRecord> void lockRecordWrite(Class<T> clazz) {
    }

    @Override
    protected <T extends BaseRecord> void unlockRecordWrite(Class<T> clazz) {
    }

    @Override
    protected <T extends BaseRecord> BufferedReader getReader(Class<T> clazz, String sub) {
        Path path = this.getPathForClass(clazz);
        if (sub != null && sub.length() > 0) {
            path = Path.mergePaths((Path)path, (Path)new Path("/" + sub));
        }
        path = Path.mergePaths((Path)path, (Path)new Path("/" + this.getDataFileName()));
        try {
            FSDataInputStream fdis = this.fs.open(path);
            InputStreamReader isr = new InputStreamReader((InputStream)fdis, StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(isr);
            return reader;
        }
        catch (IOException ex) {
            LOG.error("Cannot open write stream for {}  to {}", (Object)clazz.getSimpleName(), (Object)path);
            return null;
        }
    }

    @Override
    protected <T extends BaseRecord> BufferedWriter getWriter(Class<T> clazz, String sub) {
        Path path = this.getPathForClass(clazz);
        if (sub != null && sub.length() > 0) {
            path = Path.mergePaths((Path)path, (Path)new Path("/" + sub));
        }
        path = Path.mergePaths((Path)path, (Path)new Path("/" + this.getDataFileName()));
        try {
            FSDataOutputStream fdos = this.fs.create(path, true);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fdos, StandardCharsets.UTF_8);
            BufferedWriter writer = new BufferedWriter(osw);
            return writer;
        }
        catch (IOException ex) {
            LOG.error("Cannot open write stream for {} to {}", (Object)clazz.getSimpleName(), (Object)path);
            return null;
        }
    }
}

