/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreSerializableImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateStoreFileBaseImpl
extends StateStoreSerializableImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileBaseImpl.class);
    private boolean initialized = false;
    private static final String DATA_FILE_NAME = "records.data";

    protected abstract <T extends BaseRecord> void lockRecordRead(Class<T> var1);

    protected abstract <T extends BaseRecord> void unlockRecordRead(Class<T> var1);

    protected abstract <T extends BaseRecord> void lockRecordWrite(Class<T> var1);

    protected abstract <T extends BaseRecord> void unlockRecordWrite(Class<T> var1);

    protected abstract <T extends BaseRecord> BufferedReader getReader(Class<T> var1, String var2);

    protected abstract <T extends BaseRecord> BufferedWriter getWriter(Class<T> var1, String var2);

    protected abstract boolean exists(String var1);

    protected abstract boolean mkdir(String var1);

    protected abstract String getRootDir();

    public void setInitialized(boolean ini) {
        this.initialized = ini;
    }

    @Override
    public boolean initDriver() {
        String rootDir = this.getRootDir();
        try {
            if (rootDir == null) {
                LOG.error("Invalid root directory, unable to initialize driver.");
                return false;
            }
            if (!this.exists(rootDir) && !this.mkdir(rootDir)) {
                LOG.error("Cannot create State Store root directory {}", (Object)rootDir);
                return false;
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot initialize filesystem using root directory {}", (Object)rootDir, (Object)ex);
            return false;
        }
        this.setInitialized(true);
        return true;
    }

    @Override
    public <T extends BaseRecord> boolean initRecordStorage(String className, Class<T> recordClass) {
        String dataDirPath = this.getRootDir() + "/" + className;
        try {
            if (!this.exists(dataDirPath)) {
                ArrayList emtpyList;
                LOG.info("{} data directory doesn't exist, creating it", (Object)dataDirPath);
                if (!this.mkdir(dataDirPath)) {
                    LOG.error("Cannot create data directory {}", (Object)dataDirPath);
                    return false;
                }
                String dataFilePath = dataDirPath + "/" + DATA_FILE_NAME;
                if (!this.exists(dataFilePath) && !this.writeAll(emtpyList = new ArrayList(), recordClass)) {
                    LOG.error("Cannot create data file {}", (Object)dataFilePath);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Cannot create data directory {}", (Object)dataDirPath, (Object)ex);
            return false;
        }
        return true;
    }

    private <T extends BaseRecord> List<T> getAllFile(BufferedReader reader, Class<T> clazz, boolean includeDates) throws IOException {
        String line;
        ArrayList<T> ret = new ArrayList<T>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.length() <= 0) continue;
            try {
                T record = this.newRecord(line, clazz, includeDates);
                ret.add(record);
            }
            catch (Exception ex) {
                LOG.error("Cannot parse line in data source file: {}", (Object)line, (Object)ex);
            }
        }
        return ret;
    }

    @Override
    public <T extends BaseRecord> QueryResult<T> get(Class<T> clazz) throws IOException {
        return this.get(clazz, (String)null);
    }

    @Override
    public <T extends BaseRecord> QueryResult<T> get(Class<T> clazz, String sub) throws IOException {
        this.verifyDriverReady();
        BufferedReader reader = null;
        this.lockRecordRead(clazz);
        try {
            reader = this.getReader(clazz, sub);
            List<T> data = this.getAllFile(reader, clazz, true);
            QueryResult<T> queryResult = new QueryResult<T>(data, this.getTime());
            return queryResult;
        }
        catch (Exception ex) {
            LOG.error("Cannot fetch records {}", (Object)clazz.getSimpleName());
            throw new IOException("Cannot read from data store " + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error("Failed closing file", (Throwable)e);
                }
            }
            this.unlockRecordRead(clazz);
        }
    }

    private <T extends BaseRecord> boolean writeAllFile(Collection<T> records, BufferedWriter writer) {
        try {
            for (BaseRecord record : records) {
                try {
                    String data = this.serializeString(record);
                    writer.write(data);
                    writer.newLine();
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Cannot write record {} to file", (Object)record, (Object)ex);
                }
            }
            writer.flush();
            return true;
        }
        catch (IOException e) {
            LOG.error("Cannot commit records to file", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseRecord> boolean writeAll(Collection<T> records, Class<T> recordClass) throws StateStoreUnavailableException {
        this.verifyDriverReady();
        this.lockRecordWrite(recordClass);
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(recordClass, null);
            boolean bl = this.writeAllFile(records, writer);
            return bl;
        }
        catch (Exception e) {
            LOG.error("Cannot add records to file for {}", (Object)recordClass.getSimpleName(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close writer for {}", (Object)recordClass.getSimpleName(), (Object)e);
                }
            }
            this.unlockRecordWrite(recordClass);
        }
    }

    protected String getDataFileName() {
        return DATA_FILE_NAME;
    }

    @Override
    public boolean isDriverReady() {
        return this.initialized;
    }

    @Override
    public <T extends BaseRecord> boolean putAll(List<T> records, boolean allowUpdate, boolean errorIfExists) throws StateStoreUnavailableException {
        String key;
        QueryResult<BaseRecord> result;
        this.verifyDriverReady();
        if (records.isEmpty()) {
            return true;
        }
        Class<BaseRecord> clazz = StateStoreUtils.getRecordClass(((BaseRecord)records.get(0)).getClass());
        try {
            result = this.get(clazz);
        }
        catch (IOException e) {
            return false;
        }
        HashMap<String, BaseRecord> writeList = new HashMap<String, BaseRecord>();
        for (BaseRecord existingRecord : result.getRecords()) {
            key = existingRecord.getPrimaryKey();
            writeList.put(key, existingRecord);
        }
        for (BaseRecord updatedRecord : records) {
            try {
                updatedRecord.validate();
                key = updatedRecord.getPrimaryKey();
                if (writeList.containsKey(key) && allowUpdate) {
                    writeList.put(key, updatedRecord);
                    updatedRecord.setDateModified(this.getTime());
                    continue;
                }
                if (!writeList.containsKey(key)) {
                    writeList.put(key, updatedRecord);
                    continue;
                }
                if (!errorIfExists) continue;
                LOG.error("Attempt to insert record {} that already exists", (Object)updatedRecord);
                return false;
            }
            catch (IllegalArgumentException ex) {
                LOG.error("Cannot write invalid record to State Store", (Throwable)ex);
                return false;
            }
        }
        boolean status = this.writeAll(writeList.values(), clazz);
        return status;
    }

    @Override
    public <T extends BaseRecord> int remove(Class<T> clazz, Query<T> query) throws StateStoreUnavailableException {
        this.verifyDriverReady();
        if (query == null) {
            return 0;
        }
        int removed = 0;
        try {
            QueryResult<T> result = this.get(clazz);
            List<T> existingRecords = result.getRecords();
            List<T> recordsToRemove = StateStoreUtils.filterMultiple(query, existingRecords);
            removed = recordsToRemove.size();
            LinkedList<BaseRecord> newRecords = new LinkedList<BaseRecord>();
            for (BaseRecord record : existingRecords) {
                if (recordsToRemove.contains(record)) continue;
                newRecords.add(record);
            }
            if (!this.writeAll(newRecords, clazz)) {
                throw new IOException("Cannot remove record " + clazz + " query " + query);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot remove records {} query {}", new Object[]{clazz, query, e});
        }
        return removed;
    }

    @Override
    public <T extends BaseRecord> boolean removeAll(Class<T> clazz) throws StateStoreUnavailableException {
        this.verifyDriverReady();
        ArrayList emptyList = new ArrayList();
        boolean status = this.writeAll(emptyList, clazz);
        return status;
    }
}

