/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class StateStoreSerializer {
    private static StateStoreSerializer defaultSerializer;

    public static StateStoreSerializer getSerializer() {
        return StateStoreSerializer.getSerializer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateStoreSerializer getSerializer(Configuration conf) {
        if (conf == null) {
            Class<StateStoreSerializer> clazz = StateStoreSerializer.class;
            synchronized (StateStoreSerializer.class) {
                if (defaultSerializer == null) {
                    conf = new Configuration();
                    defaultSerializer = StateStoreSerializer.newSerializer(conf);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultSerializer;
            }
        }
        return StateStoreSerializer.newSerializer(conf);
    }

    private static StateStoreSerializer newSerializer(Configuration conf) {
        Class serializerName = conf.getClass("dfs.federation.router.store.serializer", DFSConfigKeys.FEDERATION_STORE_SERIALIZER_CLASS_DEFAULT, StateStoreSerializer.class);
        return (StateStoreSerializer)ReflectionUtils.newInstance((Class)serializerName, (Configuration)conf);
    }

    public static <T> T newRecord(Class<T> clazz) {
        return StateStoreSerializer.getSerializer(null).newRecordInstance(clazz);
    }

    public abstract <T> T newRecordInstance(Class<T> var1);

    public abstract byte[] serialize(BaseRecord var1);

    public abstract String serializeString(BaseRecord var1);

    public abstract <T extends BaseRecord> T deserialize(byte[] var1, Class<T> var2) throws IOException;

    public abstract <T extends BaseRecord> T deserialize(String var1, Class<T> var2) throws IOException;
}

