/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamenodeHeartbeatService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(NamenodeHeartbeatService.class);
    private Configuration conf;
    private final ActiveNamenodeResolver resolver;
    private final String nameserviceId;
    private final String namenodeId;
    private NNHAServiceTarget localTarget;
    private String rpcAddress;
    private String serviceAddress;
    private String lifelineAddress;
    private String webAddress;

    public NamenodeHeartbeatService(ActiveNamenodeResolver resolver, String nsId, String nnId) {
        super(NamenodeHeartbeatService.class.getSimpleName() + (nsId == null ? "" : " " + nsId) + (nnId == null ? "" : " " + nnId));
        this.resolver = resolver;
        this.nameserviceId = nsId;
        this.namenodeId = nnId;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        String nnDesc = this.nameserviceId;
        if (this.namenodeId != null && !this.namenodeId.isEmpty()) {
            this.localTarget = new NNHAServiceTarget(this.conf, this.nameserviceId, this.namenodeId);
            nnDesc = nnDesc + "-" + this.namenodeId;
        } else {
            this.localTarget = null;
        }
        this.rpcAddress = NamenodeHeartbeatService.getRpcAddress(this.conf, this.nameserviceId, this.namenodeId);
        LOG.info("{} RPC address: {}", (Object)nnDesc, (Object)this.rpcAddress);
        this.serviceAddress = DFSUtil.getNamenodeServiceAddr(this.conf, this.nameserviceId, this.namenodeId);
        if (this.serviceAddress == null) {
            LOG.error("Cannot locate RPC service address for NN {}, using RPC address {}", (Object)nnDesc, (Object)this.rpcAddress);
            this.serviceAddress = this.rpcAddress;
        }
        LOG.info("{} Service RPC address: {}", (Object)nnDesc, (Object)this.serviceAddress);
        this.lifelineAddress = DFSUtil.getNamenodeLifelineAddr(this.conf, this.nameserviceId, this.namenodeId);
        if (this.lifelineAddress == null) {
            this.lifelineAddress = this.serviceAddress;
        }
        LOG.info("{} Lifeline RPC address: {}", (Object)nnDesc, (Object)this.lifelineAddress);
        this.webAddress = DFSUtil.getNamenodeWebAddr(this.conf, this.nameserviceId, this.namenodeId);
        LOG.info("{} Web address: {}", (Object)nnDesc, (Object)this.webAddress);
        this.setIntervalMs(this.conf.getLong("dfs.federation.router.heartbeat.interval", DFSConfigKeys.DFS_ROUTER_HEARTBEAT_INTERVAL_MS_DEFAULT));
        super.serviceInit(configuration);
    }

    @Override
    public void periodicInvoke() {
        this.updateState();
    }

    private static String getRpcAddress(Configuration conf, String nsId, String nnId) {
        String confKey = "dfs.namenode.rpc-address";
        String ret = conf.get(confKey);
        if ((nsId != null || nnId != null) && (ret = conf.get(confKey = DFSUtil.addKeySuffixes(confKey, nsId, nnId))) == null) {
            Map<String, InetSocketAddress> rpcAddresses = DFSUtil.getRpcAddressesForNameserviceId(conf, nsId, null);
            InetSocketAddress sockAddr = null;
            if (nnId != null) {
                sockAddr = rpcAddresses.get(nnId);
            } else if (rpcAddresses.size() == 1) {
                sockAddr = rpcAddresses.values().iterator().next();
            }
            if (sockAddr != null) {
                InetAddress addr = sockAddr.getAddress();
                ret = addr.getHostName() + ":" + sockAddr.getPort();
            }
        }
        return ret;
    }

    private void updateState() {
        NamenodeStatusReport report = this.getNamenodeStatusReport();
        if (!report.registrationValid()) {
            LOG.error("Namenode is not operational: {}", (Object)this.getNamenodeDesc());
        } else if (report.haStateValid()) {
            LOG.debug("Received service state: {} from HA namenode: {}", (Object)report.getState(), (Object)this.getNamenodeDesc());
        } else if (this.localTarget == null) {
            LOG.debug("Reporting non-HA namenode as operational: " + this.getNamenodeDesc());
        } else {
            return;
        }
        try {
            if (!this.resolver.registerNamenode(report)) {
                LOG.warn("Cannot register namenode {}", (Object)report);
            }
        }
        catch (IOException e) {
            LOG.info("Cannot register namenode in the State Store");
        }
        catch (Exception ex) {
            LOG.error("Unhandled exception updating NN registration for {}", (Object)this.getNamenodeDesc(), (Object)ex);
        }
    }

    protected NamenodeStatusReport getNamenodeStatusReport() {
        NamenodeStatusReport report;
        block11: {
            report = new NamenodeStatusReport(this.nameserviceId, this.namenodeId, this.rpcAddress, this.serviceAddress, this.lifelineAddress, this.webAddress);
            try {
                NamespaceInfo info;
                LOG.debug("Probing NN at service address: {}", (Object)this.serviceAddress);
                URI serviceURI = new URI("hdfs://" + this.serviceAddress);
                NamenodeProtocol nn = (NamenodeProtocol)NameNodeProxies.createProxy(this.conf, serviceURI, NamenodeProtocol.class).getProxy();
                if (nn != null && (info = nn.versionRequest()) != null) {
                    report.setNamespaceInfo(info);
                }
                if (!report.registrationValid()) {
                    return report;
                }
                try {
                    ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy(this.conf, serviceURI, ClientProtocol.class).getProxy();
                    if (client != null) {
                        boolean isSafeMode = client.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
                        report.setSafeMode(isSafeMode);
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot fetch safemode state for {}", (Object)this.getNamenodeDesc(), (Object)e);
                }
                this.updateJMXParameters(this.webAddress, report);
                if (this.localTarget == null) break block11;
                try {
                    HAServiceProtocol haProtocol = this.localTarget.getProxy(this.conf, 30000);
                    HAServiceStatus status = haProtocol.getServiceStatus();
                    report.setHAServiceState(status.getState());
                }
                catch (Throwable e) {
                    if (e.getMessage().startsWith("HA for namenode is not enabled")) {
                        LOG.error("HA for {} is not enabled", (Object)this.getNamenodeDesc());
                        this.localTarget = null;
                        break block11;
                    }
                    LOG.error("Cannot fetch HA status for {}: {}", new Object[]{this.getNamenodeDesc(), e.getMessage(), e});
                }
            }
            catch (IOException e) {
                LOG.error("Cannot communicate with {}: {}", (Object)this.getNamenodeDesc(), (Object)e.getMessage());
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception while communicating with {}: {}", new Object[]{this.getNamenodeDesc(), e.getMessage(), e});
            }
        }
        return report;
    }

    public String getNamenodeDesc() {
        if (this.namenodeId != null && !this.namenodeId.isEmpty()) {
            return this.nameserviceId + "-" + this.namenodeId + ":" + this.serviceAddress;
        }
        return this.nameserviceId + ":" + this.serviceAddress;
    }

    private void updateJMXParameters(String address, NamenodeStatusReport report) {
        try {
            String query = "Hadoop:service=NameNode,name=FSNamesystem*";
            JSONArray aux = FederationUtil.getJmx(query, address);
            if (aux != null) {
                for (int i = 0; i < aux.length(); ++i) {
                    JSONObject jsonObject = aux.getJSONObject(i);
                    String name = jsonObject.getString("name");
                    if (name.equals("Hadoop:service=NameNode,name=FSNamesystemState")) {
                        report.setDatanodeInfo(jsonObject.getInt("NumLiveDataNodes"), jsonObject.getInt("NumDeadDataNodes"), jsonObject.getInt("NumDecommissioningDataNodes"), jsonObject.getInt("NumDecomLiveDataNodes"), jsonObject.getInt("NumDecomDeadDataNodes"));
                        continue;
                    }
                    if (!name.equals("Hadoop:service=NameNode,name=FSNamesystem")) continue;
                    report.setNamesystemInfo(jsonObject.getLong("CapacityRemaining"), jsonObject.getLong("CapacityTotal"), jsonObject.getLong("FilesTotal"), jsonObject.getLong("BlocksTotal"), jsonObject.getLong("MissingBlocks"), jsonObject.getLong("PendingReplicationBlocks"), jsonObject.getLong("UnderReplicatedBlocks"), jsonObject.getLong("PendingDeletionBlocks"));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get stat from {} using JMX", (Object)this.getNamenodeDesc(), (Object)e);
        }
    }
}

