/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.federation.protocol.proto.HdfsServerFederationProtos;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolPB;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.AddMountTableEntryRequestPBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.AddMountTableEntryResponsePBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.GetMountTableEntriesRequestPBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.GetMountTableEntriesResponsePBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.RemoveMountTableEntryRequestPBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.RemoveMountTableEntryResponsePBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.UpdateMountTableEntryRequestPBImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb.UpdateMountTableEntryResponsePBImpl;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class RouterAdminProtocolServerSideTranslatorPB
implements RouterAdminProtocolPB {
    private final RouterAdminServer server;

    public RouterAdminProtocolServerSideTranslatorPB(RouterAdminServer server) throws IOException {
        this.server = server;
    }

    @Override
    public HdfsServerFederationProtos.AddMountTableEntryResponseProto addMountTableEntry(RpcController controller, HdfsServerFederationProtos.AddMountTableEntryRequestProto request) throws ServiceException {
        try {
            AddMountTableEntryRequestPBImpl req = new AddMountTableEntryRequestPBImpl(request);
            AddMountTableEntryResponse response = this.server.addMountTableEntry(req);
            AddMountTableEntryResponsePBImpl responsePB = (AddMountTableEntryResponsePBImpl)response;
            return responsePB.getProto();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public HdfsServerFederationProtos.RemoveMountTableEntryResponseProto removeMountTableEntry(RpcController controller, HdfsServerFederationProtos.RemoveMountTableEntryRequestProto request) throws ServiceException {
        try {
            RemoveMountTableEntryRequestPBImpl req = new RemoveMountTableEntryRequestPBImpl(request);
            RemoveMountTableEntryResponse response = this.server.removeMountTableEntry(req);
            RemoveMountTableEntryResponsePBImpl responsePB = (RemoveMountTableEntryResponsePBImpl)response;
            return responsePB.getProto();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public HdfsServerFederationProtos.GetMountTableEntriesResponseProto getMountTableEntries(RpcController controller, HdfsServerFederationProtos.GetMountTableEntriesRequestProto request) throws ServiceException {
        try {
            GetMountTableEntriesRequestPBImpl req = new GetMountTableEntriesRequestPBImpl(request);
            GetMountTableEntriesResponse response = this.server.getMountTableEntries(req);
            GetMountTableEntriesResponsePBImpl responsePB = (GetMountTableEntriesResponsePBImpl)response;
            return responsePB.getProto();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public HdfsServerFederationProtos.UpdateMountTableEntryResponseProto updateMountTableEntry(RpcController controller, HdfsServerFederationProtos.UpdateMountTableEntryRequestProto request) throws ServiceException {
        try {
            UpdateMountTableEntryRequestPBImpl req = new UpdateMountTableEntryRequestPBImpl(request);
            UpdateMountTableEntryResponse response = this.server.updateMountTableEntry(req);
            UpdateMountTableEntryResponsePBImpl responsePB = (UpdateMountTableEntryResponsePBImpl)response;
            return responsePB.getProto();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

