/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RSP_Z88_COMMON_ORDER;
import ca.uhn.hl7v2.model.v26.group.RSP_Z88_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Z88_QUERY_RESPONSE
extends AbstractGroup {
    public RSP_Z88_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RSP_Z88_PATIENT.class, false, false);
            this.add(RSP_Z88_COMMON_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating RSP_Z88_QUERY_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public RSP_Z88_PATIENT getPATIENT() {
        RSP_Z88_PATIENT ret = null;
        try {
            ret = (RSP_Z88_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_COMMON_ORDER getCOMMON_ORDER() {
        RSP_Z88_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z88_COMMON_ORDER)this.get("COMMON_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z88_COMMON_ORDER getCOMMON_ORDER(int rep) {
        RSP_Z88_COMMON_ORDER ret = null;
        try {
            ret = (RSP_Z88_COMMON_ORDER)this.get("COMMON_ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCOMMON_ORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("COMMON_ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCOMMON_ORDER(RSP_Z88_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("COMMON_ORDER", (Structure)structure, rep);
    }

    public RSP_Z88_COMMON_ORDER insertCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z88_COMMON_ORDER)super.insertRepetition("COMMON_ORDER", rep);
    }

    public RSP_Z88_COMMON_ORDER removeCOMMON_ORDER(int rep) throws HL7Exception {
        return (RSP_Z88_COMMON_ORDER)super.removeRepetition("COMMON_ORDER", rep);
    }
}

