/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.servlet.ServicesLoader;
import org.apache.oozie.util.XLog;

public class ConfigUtils {
    private static final XLog LOG = XLog.getLog(ConfigUtils.class);
    public static boolean BOOLEAN_DEFAULT = false;
    public static String STRING_DEFAULT = "";
    public static int INT_DEFAULT = 0;
    public static float FLOAT_DEFAULT = 0.0f;
    public static long LONG_DEFAULT = 0L;

    public static String getWithDeprecatedCheck(Configuration conf, String newName, String oldName, String defaultValue) {
        String value = conf.get(oldName, null);
        if (value == null) {
            value = conf.get(newName, defaultValue);
        } else {
            LOG.warn("Using a deprecated configuration property [{0}], should use [{1}].  Please delete the deprecated property in order for the new property to take effect.", oldName, newName);
        }
        return value;
    }

    public static boolean getWithDeprecatedCheck(Configuration conf, String newName, String oldName, boolean defaultValue) {
        String value = ConfigUtils.getWithDeprecatedCheck(conf, newName, oldName, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static String getOozieURL(boolean secure) {
        StringBuilder sb = new StringBuilder();
        if (secure) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(ConfigurationService.get("oozie.http.hostname"));
        sb.append(":");
        if (secure) {
            sb.append(ConfigurationService.get("oozie.https.port"));
        } else {
            sb.append(ConfigurationService.get("oozie.http.port"));
        }
        sb.append("/oozie");
        return sb.toString();
    }

    public static String getOozieEffectiveUrl() {
        return ConfigUtils.getOozieURL(ServicesLoader.isSSLEnabled());
    }

    public static boolean isBackwardSupportForCoordStatus() {
        return ConfigurationService.getBoolean("oozie.service.StatusTransitService.backward.support.for.coord.status");
    }
}

