/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInfoGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInfoGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowsJobGetJPAExecutor;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.GroupsService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class AuthorizationService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.AuthorizationService.";
    public static final String CONF_SECURITY_ENABLED = "oozie.service.AuthorizationService.security.enabled";
    public static final String CONF_AUTHORIZATION_ENABLED = "oozie.service.AuthorizationService.authorization.enabled";
    public static final String CONF_DEFAULT_GROUP_AS_ACL = "oozie.service.AuthorizationService.default.group.as.acl";
    public static final String CONF_ADMIN_GROUPS = "oozie.service.AuthorizationService.admin.groups";
    public static final String ADMIN_USERS_FILE = "adminusers.txt";
    protected static final String INSTRUMENTATION_GROUP = "authorization";
    protected static final String INSTR_FAILED_AUTH_COUNTER = "authorization.failed";
    private Set<String> adminGroups;
    private Set<String> adminUsers;
    private boolean authorizationEnabled;
    private boolean useDefaultGroupAsAcl;
    private final XLog log = XLog.getLog(this.getClass());
    private Instrumentation instrumentation;

    private String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return new String[0];
        }
        return str.trim().split("\\s*,\\s*");
    }

    @Override
    public void init(Services services) throws ServiceException {
        this.authorizationEnabled = ConfigUtils.getWithDeprecatedCheck(services.getConf(), CONF_AUTHORIZATION_ENABLED, CONF_SECURITY_ENABLED, false);
        if (this.authorizationEnabled) {
            this.log.info("Oozie running with authorization enabled");
            this.useDefaultGroupAsAcl = ConfigurationService.getBoolean(CONF_DEFAULT_GROUP_AS_ACL);
            String[] str = this.getTrimmedStrings(Services.get().getConf().get(CONF_ADMIN_GROUPS));
            if (str.length > 0) {
                this.log.info("Admin users will be checked against the defined admin groups");
                this.adminGroups = new HashSet<String>();
                for (String s : str) {
                    this.adminGroups.add(s.trim());
                }
            } else {
                this.log.info("Admin users will be checked against the 'adminusers.txt' file contents");
                this.adminUsers = new HashSet<String>();
                this.loadAdminUsers();
            }
        } else {
            this.log.warn("Oozie running with authorization disabled");
        }
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
    }

    @Deprecated
    public boolean isSecurityEnabled() {
        return this.authorizationEnabled;
    }

    public boolean useDefaultGroupAsAcl() {
        return this.useDefaultGroupAsAcl;
    }

    public boolean isAuthorizationEnabled() {
        return this.isSecurityEnabled();
    }

    private void loadAdminUsers() throws ServiceException {
        block9: {
            String configDir = Services.get().get(ConfigurationService.class).getConfigDir();
            if (configDir != null) {
                File file = new File(configDir, ADMIN_USERS_FILE);
                if (file.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        try {
                            String line = br.readLine();
                            while (line != null) {
                                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                                    this.adminUsers.add(line);
                                }
                                line = br.readLine();
                            }
                            break block9;
                        }
                        catch (IOException ex) {
                            throw new ServiceException(ErrorCode.E0160, file.getAbsolutePath(), ex);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        throw new ServiceException(ErrorCode.E0160, file.getAbsolutePath(), ex);
                    }
                }
                this.log.warn("Admin users file not available in config dir [{0}], running without admin users", configDir);
            } else {
                this.log.warn("Reading configuration from classpath, running without admin users");
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return AuthorizationService.class;
    }

    protected boolean isUserInGroup(String user, String group) throws AuthorizationException {
        GroupsService groupsService = Services.get().get(GroupsService.class);
        try {
            return groupsService.getGroups(user).contains(group);
        }
        catch (IOException ex) {
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
    }

    public void authorizeForGroup(String user, String group) throws AuthorizationException {
        if (this.authorizationEnabled && !this.isUserInGroup(user, group)) {
            throw new AuthorizationException(ErrorCode.E0502, user, group);
        }
    }

    public String getDefaultGroup(String user) throws AuthorizationException {
        try {
            return Services.get().get(GroupsService.class).getGroups(user).get(0);
        }
        catch (IOException ex) {
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
    }

    protected boolean isAdmin(String user) {
        boolean admin = false;
        if (this.adminUsers != null) {
            admin = this.adminUsers.contains(user);
        } else {
            for (String adminGroup : this.adminGroups) {
                try {
                    admin = this.isUserInGroup(user, adminGroup);
                    if (!admin) continue;
                }
                catch (AuthorizationException ex) {
                    this.log.warn((Object)("Admin check failed, " + ex.toString()), ex);
                }
                break;
            }
        }
        return admin;
    }

    public void authorizeForAdmin(String user, boolean write) throws AuthorizationException {
        if (this.authorizationEnabled && write && !this.isAdmin(user)) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0503, user);
        }
    }

    public void authorizeForApp(String user, String group, String appPath, Configuration jobConf) throws AuthorizationException {
        try {
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = new Path(appPath).toUri();
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)fsConf);
            Path path = new Path(appPath);
            try {
                if (!fs.exists(path)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0504, appPath);
                }
                Path wfXml = new Path(path, "workflow.xml");
                if (!fs.exists(wfXml)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0505, appPath);
                }
                if (!fs.isFile(wfXml)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0506, appPath);
                }
                fs.open(wfXml).close();
            }
            catch (AccessControlException ex) {
                this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                throw new AuthorizationException(ErrorCode.E0507, new Object[]{appPath, ex.getMessage(), ex});
            }
        }
        catch (IOException ex) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException e) {
            throw new AuthorizationException(e);
        }
    }

    public void authorizeForApp(String user, String group, String appPath, String fileName, Configuration conf) throws AuthorizationException {
        try {
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            URI uri = new Path(appPath).toUri();
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)fsConf);
            Path path = new Path(appPath);
            try {
                if (!fs.exists(path)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0504, appPath);
                }
                if (conf.get("oozie.proxysubmission") == null && !fs.isFile(path)) {
                    Path appXml = new Path(path, fileName);
                    if (!fs.exists(appXml)) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0505, appPath);
                    }
                    if (!fs.isFile(appXml)) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0506, appPath);
                    }
                    fs.open(appXml).close();
                }
            }
            catch (AccessControlException ex) {
                this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                throw new AuthorizationException(ErrorCode.E0507, new Object[]{appPath, ex.getMessage(), ex});
            }
        }
        catch (IOException ex) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException e) {
            throw new AuthorizationException(e);
        }
    }

    private boolean isUserInAcl(String user, String aclStr) throws IOException {
        boolean userInAcl = false;
        if (aclStr != null && aclStr.trim().length() > 0) {
            GroupsService groupsService = Services.get().get(GroupsService.class);
            String[] acl = aclStr.split(",");
            for (int i = 0; !userInAcl && i < acl.length; ++i) {
                String aclItem = acl[i].trim();
                userInAcl = aclItem.equals(user) || groupsService.getGroups(user).contains(aclItem);
            }
        }
        return userInAcl;
    }

    public void authorizeForJob(String user, String jobId, boolean write) throws AuthorizationException {
        if (this.authorizationEnabled && write && !this.isAdmin(user)) {
            try {
                if (jobId.endsWith("-W")) {
                    WorkflowJobBean jobBean = null;
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_USER_GROUP, jobId);
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInAcl(user, jobBean.getGroup())) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0508, user, jobId);
                    }
                } else if (jobId.endsWith("-B")) {
                    BundleJobBean jobBean = null;
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBean = jpaService.execute(new BundleJobGetJPAExecutor(jobId));
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInAcl(user, jobBean.getGroup())) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0509, user, jobId);
                    }
                } else {
                    CoordinatorJobBean jobBean = null;
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBean = jpaService.execute(new CoordJobGetJPAExecutor(jobId));
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInAcl(user, jobBean.getGroup())) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0509, user, jobId);
                    }
                }
            }
            catch (IOException ex) {
                throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
            }
        }
    }

    public void authorizeForJobs(String user, Map<String, List<String>> filter, String jobType, int start, int len, boolean write) throws AuthorizationException {
        if (this.authorizationEnabled && write && !this.isAdmin(user)) {
            try {
                if (jobType.equals("wf")) {
                    List<Object> jobBeans = new ArrayList();
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBeans = jpaService.execute(new WorkflowsJobGetJPAExecutor(filter, start, len)).getWorkflows();
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    for (WorkflowJobBean workflowJobBean : jobBeans) {
                        if (workflowJobBean == null || workflowJobBean.getUser().equals(user) || this.isUserInAcl(user, workflowJobBean.getGroup())) continue;
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0508, user, workflowJobBean.getId());
                    }
                } else if (jobType.equals("bundle")) {
                    List<Object> jobBeans = new ArrayList();
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBeans = jpaService.execute(new BundleJobInfoGetJPAExecutor(filter, start, len)).getBundleJobs();
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    for (BundleJobBean bundleJobBean : jobBeans) {
                        if (bundleJobBean == null || bundleJobBean.getUser().equals(user) || this.isUserInAcl(user, bundleJobBean.getGroup())) continue;
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0509, user, bundleJobBean.getId());
                    }
                } else {
                    List<Object> jobBeans = new ArrayList();
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            jobBeans = jpaService.execute(new CoordJobInfoGetJPAExecutor(filter, start, len)).getCoordJobs();
                        }
                        catch (JPAExecutorException je) {
                            throw new AuthorizationException(je);
                        }
                    } else {
                        throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                    }
                    for (CoordinatorJobBean coordinatorJobBean : jobBeans) {
                        if (coordinatorJobBean == null || coordinatorJobBean.getUser().equals(user) || this.isUserInAcl(user, coordinatorJobBean.getGroup())) continue;
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0509, user, coordinatorJobBean.getId());
                    }
                }
            }
            catch (IOException ex) {
                throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
            }
        }
    }

    private void incrCounter(String name, int count) {
        if (this.instrumentation != null) {
            this.instrumentation.incr(INSTRUMENTATION_GROUP, name, count);
        }
    }
}

