/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.dependency;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.StringBlob;
import org.apache.oozie.coord.input.dependency.CoordInputDependency;
import org.apache.oozie.coord.input.dependency.CoordOldInputDependency;
import org.apache.oozie.coord.input.dependency.CoordPullInputDependency;
import org.apache.oozie.coord.input.dependency.CoordPushInputDependency;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.util.XLog;

public class CoordInputDependencyFactory {
    private static final byte[] MAGIC_NUMBER = new byte[]{58, 58, 36};
    public static final String CHAR_ENCODING = "ISO-8859-1";
    public static XLog LOG = XLog.getLog(CoordInputDependencyFactory.class);

    public static CoordInputDependency createPullInputDependencies(boolean isInputLogicSpecified) {
        if (!isInputLogicSpecified) {
            return new CoordOldInputDependency();
        }
        return new CoordPullInputDependency();
    }

    public static CoordInputDependency createPushInputDependencies(boolean isInputLogicSpecified) {
        if (!isInputLogicSpecified) {
            return new CoordOldInputDependency();
        }
        return new CoordPushInputDependency();
    }

    public static CoordInputDependency getPullInputDependencies(StringBlob missingDependencies) {
        if (missingDependencies == null) {
            return new CoordOldInputDependency();
        }
        return CoordInputDependencyFactory.getPullInputDependencies(missingDependencies.getString());
    }

    public static CoordInputDependency getPullInputDependencies(String dependencies) {
        if (StringUtils.isEmpty((String)dependencies) || !CoordInputDependencyFactory.hasInputLogic(dependencies)) {
            return new CoordOldInputDependency(dependencies);
        }
        try {
            return WritableUtils.fromByteArray(CoordInputDependencyFactory.getDependenciesWithoutMagicNumber(dependencies).getBytes(CHAR_ENCODING), CoordPullInputDependency.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static CoordInputDependency getPushInputDependencies(StringBlob pushMissingDependencies) {
        if (pushMissingDependencies == null) {
            return new CoordOldInputDependency();
        }
        return CoordInputDependencyFactory.getPushInputDependencies(pushMissingDependencies.getString());
    }

    public static CoordInputDependency getPushInputDependencies(String dependencies) {
        if (StringUtils.isEmpty((String)dependencies) || !CoordInputDependencyFactory.hasInputLogic(dependencies)) {
            return new CoordOldInputDependency(dependencies);
        }
        try {
            return WritableUtils.fromByteArray(CoordInputDependencyFactory.getDependenciesWithoutMagicNumber(dependencies).getBytes(CHAR_ENCODING), CoordPushInputDependency.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasInputLogic(String dependencies) {
        return dependencies.startsWith(CoordInputDependencyFactory.getMagicNumber());
    }

    public static String getMagicNumber() {
        try {
            return new String(MAGIC_NUMBER, CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getDependenciesWithoutMagicNumber(String dependencies) {
        return dependencies.substring(CoordInputDependencyFactory.getMagicNumber().length());
    }
}

