/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.compression;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.oozie.compression.CompressionCodec;

public class GzipCompressionCodec
implements CompressionCodec {
    public static final String CODEC_NAME = "gz";

    @Override
    public byte[] compressBytes(byte[] header, byte[] data) throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(2000);
        byteOutput.write(header);
        GZIPOutputStream gzipOut = new GZIPOutputStream(byteOutput);
        gzipOut.write(data);
        gzipOut.close();
        return byteOutput.toByteArray();
    }

    @Override
    public byte[] compressString(byte[] header, String data) throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(1000);
        byteOutput.write(header);
        GZIPOutputStream gzipOut = new GZIPOutputStream(byteOutput);
        gzipOut.write(data.getBytes("UTF-8"));
        gzipOut.close();
        return byteOutput.toByteArray();
    }

    @Override
    public String decompressToString(DataInputStream dais) throws IOException {
        GZIPInputStream gzipIn = new GZIPInputStream(dais);
        String decompress = IOUtils.toString((InputStream)gzipIn, (String)"UTF-8");
        gzipIn.close();
        return decompress;
    }

    @Override
    public byte[] decompressToBytes(DataInputStream dais) throws IOException {
        GZIPInputStream gzipIn = new GZIPInputStream(dais);
        byte[] decompress = IOUtils.toByteArray((InputStream)gzipIn);
        gzipIn.close();
        return decompress;
    }
}

