/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Quotas;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.common.PathTrie;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.ReferenceCountedACLCache;
import org.apache.zookeeper.server.WatchManager;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.upgrade.DataNodeV1;
import org.apache.zookeeper.txn.CheckVersionTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.MultiTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.Txn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTree {
    private static final Logger LOG = LoggerFactory.getLogger(DataTree.class);
    private final ConcurrentHashMap<String, DataNode> nodes = new ConcurrentHashMap();
    private final WatchManager dataWatches = new WatchManager();
    private final WatchManager childWatches = new WatchManager();
    private static final String rootZookeeper = "/";
    private static final String procZookeeper = "/zookeeper";
    private static final String procChildZookeeper = "/zookeeper".substring(1);
    private static final String quotaZookeeper = "/zookeeper/quota";
    private static final String quotaChildZookeeper = "/zookeeper/quota".substring("/zookeeper".length() + 1);
    private final PathTrie pTrie = new PathTrie();
    private final Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private final ReferenceCountedACLCache aclCache = new ReferenceCountedACLCache();
    private DataNode root = new DataNode(null, new byte[0], -1L, new StatPersisted());
    private DataNode procDataNode = new DataNode(this.root, new byte[0], -1L, new StatPersisted());
    private DataNode quotaDataNode = new DataNode(this.procDataNode, new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;
    int scount;
    public boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Map<Long, HashSet<String>> getEphemeralsMap() {
        return this.ephemerals;
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public void addDataNode(String path, DataNode node) {
        this.nodes.put(path, node);
    }

    public DataNode getNode(String path) {
        return this.nodes.get(path);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public int getEphemeralsCount() {
        Map<Long, HashSet<String>> map = this.getEphemeralsMap();
        int result = 0;
        for (HashSet<String> set : map.values()) {
            result += set.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approximateDataSize() {
        long result = 0L;
        for (Map.Entry<String, DataNode> entry : this.nodes.entrySet()) {
            DataNode value;
            DataNode dataNode = value = entry.getValue();
            synchronized (dataNode) {
                result += (long)entry.getKey().length();
                result += (long)(value.data == null ? 0 : value.data.length);
            }
        }
        return result;
    }

    public DataTree() {
        this.nodes.put("", this.root);
        this.nodes.put(rootZookeeper, this.root);
        this.root.addChild(procChildZookeeper);
        this.nodes.put(procZookeeper, this.procDataNode);
        this.procDataNode.addChild(quotaChildZookeeper);
        this.nodes.put(quotaZookeeper, this.quotaDataNode);
    }

    boolean isSpecialPath(String path) {
        return rootZookeeper.equals(path) || procZookeeper.equals(path) || quotaZookeeper.equals(path);
    }

    public static void copyStatPersisted(StatPersisted from, StatPersisted to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCount(String lastPrefix, int diff) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node = this.nodes.get(statNode);
        StatsTrack updatedStat = null;
        if (node == null) {
            LOG.error("Missing count node for stat " + statNode);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node.data));
            updatedStat.setCount(updatedStat.getCount() + diff);
            node.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node = this.nodes.get(quotaNode);
        StatsTrack thisStats = null;
        if (node == null) {
            LOG.error("Missing count node for quota " + quotaNode);
            return;
        }
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node.data));
        }
        if (thisStats.getCount() > -1 && thisStats.getCount() < updatedStat.getCount()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " count=" + updatedStat.getCount() + " limit=" + thisStats.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(String lastPrefix, long diff) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node = this.nodes.get(statNode);
        if (node == null) {
            LOG.error("Missing stat node for bytes " + statNode);
            return;
        }
        StatsTrack updatedStat = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node.data));
            updatedStat.setBytes(updatedStat.getBytes() + diff);
            node.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node = this.nodes.get(quotaNode);
        if (node == null) {
            LOG.error("Missing quota node for bytes " + quotaNode);
            return;
        }
        StatsTrack thisStats = null;
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node.data));
        }
        if (thisStats.getBytes() > -1L && thisStats.getBytes() < updatedStat.getBytes()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " bytes=" + updatedStat.getBytes() + " limit=" + thisStats.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        String lastPrefix;
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        StatPersisted stat = new StatPersisted();
        stat.setCtime(time);
        stat.setMtime(time);
        stat.setCzxid(zxid);
        stat.setMzxid(zxid);
        stat.setPzxid(zxid);
        stat.setVersion(0);
        stat.setAversion(0);
        stat.setEphemeralOwner(ephemeralOwner);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            Set<String> children = parent.getChildren();
            if (children != null && children.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            if (parentCVersion == -1) {
                parentCVersion = parent.stat.getCversion();
                ++parentCVersion;
            }
            parent.stat.setCversion(parentCVersion);
            parent.stat.setPzxid(zxid);
            Long longval = this.aclCache.convertAcls(acl);
            DataNode child = new DataNode(parent, data, longval, stat);
            parent.addChild(childName);
            this.nodes.put(path, child);
            if (ephemeralOwner != 0L) {
                HashSet<String> list = this.ephemerals.get(ephemeralOwner);
                if (list == null) {
                    list = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list);
                }
                HashSet<String> hashSet = list;
                synchronized (hashSet) {
                    list.add(path);
                }
            }
        }
        if (parentName.startsWith(quotaZookeeper)) {
            if ("zookeeper_limits".equals(childName)) {
                this.pTrie.addPath(parentName.substring(quotaZookeeper.length()));
            }
            if ("zookeeper_stats".equals(childName)) {
                this.updateQuotaForPath(parentName.substring(quotaZookeeper.length()));
            }
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path)) != null) {
            this.updateCount(lastPrefix, 1);
            this.updateBytes(lastPrefix, data == null ? 0L : (long)data.length);
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path, long zxid) throws KeeperException.NoNodeException {
        String lastPrefix;
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        DataNode node = this.nodes.get(path);
        if (node == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path);
        DataNode dataNode = node;
        synchronized (dataNode) {
            this.aclCache.removeUsage(node.acl);
        }
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = parent;
        synchronized (dataNode2) {
            HashSet<String> nodes;
            parent.removeChild(childName);
            parent.stat.setPzxid(zxid);
            long eowner = node.stat.getEphemeralOwner();
            if (eowner != 0L && (nodes = this.ephemerals.get(eowner)) != null) {
                HashSet<String> hashSet = nodes;
                synchronized (hashSet) {
                    nodes.remove(path);
                }
            }
            node.parent = null;
        }
        if (parentName.startsWith(procZookeeper) && "zookeeper_limits".equals(childName)) {
            this.pTrie.deletePath(parentName.substring(quotaZookeeper.length()));
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path)) != null) {
            this.updateCount(lastPrefix, -1);
            int bytes = 0;
            DataNode dataNode3 = node;
            synchronized (dataNode3) {
                bytes = node.data == null ? 0 : -node.data.length;
            }
            this.updateBytes(lastPrefix, bytes);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + path);
            ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + parentName);
        }
        Set<Watcher> processed = this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
        Stat s = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        byte[] lastdata = null;
        DataNode dataNode = n;
        synchronized (dataNode) {
            lastdata = n.data;
            n.data = data;
            n.stat.setMtime(time);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s);
        }
        String lastPrefix = this.getMaxPrefixWithQuota(path);
        if (lastPrefix != null) {
            this.updateBytes(lastPrefix, (data == null ? 0 : data.length) - (lastdata == null ? 0 : lastdata.length));
        }
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDataChanged);
        return s;
    }

    public String getMaxPrefixWithQuota(String path) {
        String lastPrefix = this.pTrie.findMaxPrefix(path);
        if (!rootZookeeper.equals(lastPrefix) && !"".equals(lastPrefix)) {
            return lastPrefix;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(path, watcher);
            }
            return n.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (watcher != null) {
            this.dataWatches.addWatch(path, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            ArrayList<String> children;
            Set<String> childs;
            if (stat != null) {
                n.copyStat(stat);
            }
            if ((childs = n.getChildren()) != null) {
                children = new ArrayList(childs.size());
                children.addAll(childs);
            } else {
                children = new ArrayList<String>(0);
            }
            if (watcher != null) {
                this.childWatches.addWatch(path, watcher);
            }
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            this.aclCache.removeUsage(n.acl);
            n.stat.setAversion(version);
            n.acl = this.aclCache.convertAcls(acl);
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return new ArrayList<ACL>(this.aclCache.convertLong(n.acl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(DataNode node) {
        DataNode dataNode = node;
        synchronized (dataNode) {
            return this.aclCache.convertLong(node.acl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getACL(DataNodeV1 oldDataNode) {
        DataNodeV1 dataNodeV1 = oldDataNode;
        synchronized (dataNodeV1) {
            return this.aclCache.convertAcls(oldDataNode.acl);
        }
    }

    public int aclCacheSize() {
        return this.aclCache.size();
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        ProcessTxnResult rc;
        block32: {
            rc = new ProcessTxnResult();
            try {
                rc.clientId = header.getClientId();
                rc.cxid = header.getCxid();
                rc.zxid = header.getZxid();
                rc.type = header.getType();
                rc.err = 0;
                rc.multiResult = null;
                switch (header.getType()) {
                    case 1: {
                        CreateTxn createTxn = (CreateTxn)txn;
                        rc.path = createTxn.getPath();
                        this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, createTxn.getParentCVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 2: {
                        DeleteTxn deleteTxn = (DeleteTxn)txn;
                        rc.path = deleteTxn.getPath();
                        this.deleteNode(deleteTxn.getPath(), header.getZxid());
                        break;
                    }
                    case 5: {
                        SetDataTxn setDataTxn = (SetDataTxn)txn;
                        rc.path = setDataTxn.getPath();
                        rc.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 7: {
                        SetACLTxn setACLTxn = (SetACLTxn)txn;
                        rc.path = setACLTxn.getPath();
                        rc.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                        break;
                    }
                    case -11: {
                        this.killSession(header.getClientId(), header.getZxid());
                        break;
                    }
                    case -1: {
                        ErrorTxn errTxn = (ErrorTxn)txn;
                        rc.err = errTxn.getErr();
                        break;
                    }
                    case 13: {
                        CheckVersionTxn checkTxn = (CheckVersionTxn)txn;
                        rc.path = checkTxn.getPath();
                        break;
                    }
                    case 14: {
                        MultiTxn multiTxn = (MultiTxn)txn;
                        List<Txn> txns = multiTxn.getTxns();
                        rc.multiResult = new ArrayList<ProcessTxnResult>();
                        boolean failed = false;
                        for (Txn subtxn : txns) {
                            if (subtxn.getType() != -1) continue;
                            failed = true;
                            break;
                        }
                        boolean post_failed = false;
                        for (Txn subtxn : txns) {
                            ByteBuffer bb = ByteBuffer.wrap(subtxn.getData());
                            Record record = null;
                            switch (subtxn.getType()) {
                                case 1: {
                                    record = new CreateTxn();
                                    break;
                                }
                                case 2: {
                                    record = new DeleteTxn();
                                    break;
                                }
                                case 5: {
                                    record = new SetDataTxn();
                                    break;
                                }
                                case -1: {
                                    record = new ErrorTxn();
                                    post_failed = true;
                                    break;
                                }
                                case 13: {
                                    record = new CheckVersionTxn();
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of op: " + subtxn.getType());
                                }
                            }
                            assert (record != null);
                            ByteBufferInputStream.byteBuffer2Record(bb, record);
                            if (failed && subtxn.getType() != -1) {
                                int ec = post_failed ? KeeperException.Code.RUNTIMEINCONSISTENCY.intValue() : KeeperException.Code.OK.intValue();
                                subtxn.setType(-1);
                                record = new ErrorTxn(ec);
                            }
                            if (failed) assert (subtxn.getType() == -1);
                            TxnHeader subHdr = new TxnHeader(header.getClientId(), header.getCxid(), header.getZxid(), header.getTime(), subtxn.getType());
                            ProcessTxnResult subRc = this.processTxn(subHdr, record);
                            rc.multiResult.add(subRc);
                            if (subRc.err == 0 || rc.err != 0) continue;
                            rc.err = subRc.err;
                        }
                        break;
                    }
                }
            }
            catch (KeeperException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed: " + header + ":" + txn, (Throwable)e);
                }
                rc.err = e.code().intValue();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block32;
                LOG.debug("Failed: " + header + ":" + txn, (Throwable)e);
            }
        }
        if (rc.zxid > this.lastProcessedZxid) {
            this.lastProcessedZxid = rc.zxid;
        }
        if (header.getType() == 1 && rc.err == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.debug("Adjusting parent cversion for Txn: " + header.getType() + " path:" + rc.path + " err: " + rc.err);
            int lastSlash = rc.path.lastIndexOf(47);
            String parentName = rc.path.substring(0, lastSlash);
            CreateTxn cTxn = (CreateTxn)txn;
            try {
                this.setCversionPzxid(parentName, cTxn.getParentCVersion(), header.getZxid());
            }
            catch (KeeperException.NoNodeException e) {
                LOG.error("Failed to set parent cversion for: " + parentName, (Throwable)e);
                rc.err = e.code().intValue();
            }
        } else if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr: " + header.getType() + " : error: " + rc.err);
        }
        return rc;
    }

    void killSession(long session, long zxid) {
        HashSet<String> list = this.ephemerals.remove(session);
        if (list != null) {
            for (String path : list) {
                try {
                    this.deleteNode(path, zxid);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Deleting ephemeral node " + path + " for session 0x" + Long.toHexString(session));
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.warn("Ignoring NoNodeException for path " + path + " while removing ephemeral for dead session 0x" + Long.toHexString(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCounts(String path, Counts counts) {
        String[] node = this.getNode(path);
        if (node == null) {
            return;
        }
        String[] children = null;
        int len = 0;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            if (childs != null) {
                children = childs.toArray(new String[childs.size()]);
            }
            len = node.data == null ? 0 : node.data.length;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            ++counts.count;
            counts.bytes += (long)len;
            if (children == null || children.length == 0) {
                return;
            }
            for (String child : children) {
                this.getCounts(path + rootZookeeper + child, counts);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuotaForPath(String path) {
        Counts c = new Counts();
        this.getCounts(path, c);
        StatsTrack strack = new StatsTrack();
        strack.setBytes(c.bytes);
        strack.setCount(c.count);
        String statPath = quotaZookeeper + path + rootZookeeper + "zookeeper_stats";
        DataNode node = this.getNode(statPath);
        if (node == null) {
            LOG.warn("Missing quota stat node " + statPath);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            node.data = strack.toString().getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseNode(String path) {
        String[] node = this.getNode(path);
        String[] children = null;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            if (childs != null) {
                children = childs.toArray(new String[childs.size()]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (children == null || children.length == 0) {
                String endString = "/zookeeper_limits";
                if (path.endsWith(endString)) {
                    String realPath = path.substring(quotaZookeeper.length(), path.indexOf(endString));
                    this.updateQuotaForPath(realPath);
                    this.pTrie.addPath(realPath);
                }
                return;
            }
            for (String child : children) {
                this.traverseNode(path + rootZookeeper + child);
            }
            return;
        }
    }

    private void setupQuota() {
        String quotaPath = quotaZookeeper;
        DataNode node = this.getNode(quotaPath);
        if (node == null) {
            return;
        }
        this.traverseNode(quotaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path) throws IOException {
        String pathString = path.toString();
        DataNode node = this.getNode(pathString);
        if (node == null) {
            return;
        }
        String[] children = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            ++this.scount;
            oa.writeString(pathString, "path");
            oa.writeRecord(node, "node");
            Set<String> childs = node.getChildren();
            if (childs != null) {
                children = childs.toArray(new String[childs.size()]);
            }
        }
        path.append('/');
        int off = path.length();
        if (children != null) {
            for (String child : children) {
                path.delete(off, Integer.MAX_VALUE);
                path.append(child);
                this.serializeNode(oa, path);
            }
        }
    }

    public void serialize(OutputArchive oa, String tag) throws IOException {
        this.scount = 0;
        this.aclCache.serialize(oa);
        this.serializeNode(oa, new StringBuilder(""));
        if (this.root != null) {
            oa.writeString(rootZookeeper, "path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(InputArchive ia, String tag) throws IOException {
        this.aclCache.deserialize(ia);
        this.nodes.clear();
        this.pTrie.clear();
        String path = ia.readString("path");
        while (!path.equals(rootZookeeper)) {
            DataNode node = new DataNode();
            ia.readRecord(node, "node");
            this.nodes.put(path, node);
            DataNode dataNode = node;
            synchronized (dataNode) {
                this.aclCache.addUsage(node.acl);
            }
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node;
            } else {
                String parentPath = path.substring(0, lastSlash);
                node.parent = this.nodes.get(parentPath);
                if (node.parent == null) {
                    throw new IOException("Invalid Datatree, unable to find parent " + parentPath + " of path " + path);
                }
                node.parent.addChild(path.substring(lastSlash + 1));
                long eowner = node.stat.getEphemeralOwner();
                if (eowner != 0L) {
                    HashSet<String> list = this.ephemerals.get(eowner);
                    if (list == null) {
                        list = new HashSet();
                        this.ephemerals.put(eowner, list);
                    }
                    list.add(path);
                }
            }
            path = ia.readString("path");
        }
        this.nodes.put(rootZookeeper, this.root);
        this.setupQuota();
        this.aclCache.purgeUnused();
    }

    public synchronized void dumpWatchesSummary(PrintWriter pwriter) {
        pwriter.print(this.dataWatches.toString());
    }

    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        this.dataWatches.dumpWatches(pwriter, byPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEphemerals(PrintWriter pwriter) {
        Set<Long> keys = this.ephemerals.keySet();
        pwriter.println("Sessions with Ephemerals (" + keys.size() + "):");
        for (long k : keys) {
            pwriter.print("0x" + Long.toHexString(k));
            pwriter.println(":");
            HashSet<String> tmp = this.ephemerals.get(k);
            if (tmp == null) continue;
            HashSet<String> hashSet = tmp;
            synchronized (hashSet) {
                for (String path : tmp) {
                    pwriter.println("\t" + path);
                }
            }
        }
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void clear() {
        this.root = null;
        this.nodes.clear();
        this.ephemerals.clear();
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        DataNode node;
        for (String path : dataWatches) {
            node = this.getNode(path);
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            if (node.stat.getMzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : existWatches) {
            node = this.getNode(path);
            if (node != null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : childWatches) {
            node = this.getNode(path);
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            if (node.stat.getPzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.childWatches.addWatch(path, watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCversionPzxid(String path, int newCversion, long zxid) throws KeeperException.NoNodeException {
        DataNode node;
        if (path.endsWith(rootZookeeper)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((node = this.nodes.get(path)) == null) {
            throw new KeeperException.NoNodeException(path);
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            if (newCversion == -1) {
                newCversion = node.stat.getCversion() + 1;
            }
            if (newCversion > node.stat.getCversion()) {
                node.stat.setCversion(newCversion);
                node.stat.setPzxid(zxid);
            }
        }
    }

    private static class Counts {
        long bytes;
        int count;

        private Counts() {
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;
        public List<ProcessTxnResult> multiResult;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

