/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.amazon.AmazonSpoonPlugin;
import org.pentaho.amazon.s3.S3CredentialsProvider;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.s3.vfs.S3FileObject;
import org.pentaho.s3n.vfs.S3NFileObject;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public abstract class S3VfsFileChooserBaseDialog
extends CustomVfsUiPanel {
    private static Class<?> PKG = AmazonSpoonPlugin.class;
    private LogChannel log = new LogChannel((Object)this);
    protected FileObject rootFile;
    protected FileObject initialFile;
    protected VfsFileChooserDialog vfsFileChooserDialog;
    private Label wlAccessKey;
    private TextVar wAccessKey;
    private GridData fdlAccessKey;
    private GridData fdAccessKey;
    private Label wlSecretKey;
    private TextVar wSecretKey;
    private GridData fdSecretKey;
    private Label wPlaceHolderLabel;
    private GridData fdlPlaceHolderLabel;
    private Button wConnectionButton;
    private GridData fdConnectionButton;
    private String accessKey;
    private String secretKey;

    public S3VfsFileChooserBaseDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile, String schema, String fileSystemDisplayText) {
        super(schema, fileSystemDisplayText, vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.setLayout((Layout)new GridLayout());
        this.createConnectionPanel();
        this.initializeConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(3, false));
        this.wlAccessKey = new Label(textFieldPanel, 131072);
        this.wlAccessKey.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.AccessKey.Label", (String[])new String[0]));
        this.fdlAccessKey = new GridData();
        this.fdlAccessKey.widthHint = 75;
        this.wlAccessKey.setLayoutData((Object)this.fdlAccessKey);
        this.wAccessKey = new TextVar(this.getVariableSpace(), textFieldPanel, 0x404804);
        this.fdAccessKey = new GridData();
        this.fdAccessKey.widthHint = 150;
        this.wAccessKey.setLayoutData((Object)this.fdAccessKey);
        this.wAccessKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.AccessKey", "")));
        this.wAccessKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                S3VfsFileChooserBaseDialog.this.handleConnectionButton();
            }
        });
        this.wPlaceHolderLabel = new Label(textFieldPanel, 131072);
        this.wPlaceHolderLabel.setText("");
        this.fdlPlaceHolderLabel = new GridData();
        this.fdlPlaceHolderLabel.widthHint = 75;
        this.wPlaceHolderLabel.setLayoutData((Object)this.fdlPlaceHolderLabel);
        this.wlSecretKey = new Label(textFieldPanel, 131072);
        this.wlSecretKey.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.SecretKey.Label", (String[])new String[0]));
        this.wSecretKey = new TextVar(this.getVariableSpace(), textFieldPanel, 0x404804);
        this.fdSecretKey = new GridData();
        this.fdSecretKey.widthHint = 300;
        this.wSecretKey.setLayoutData((Object)this.fdSecretKey);
        this.wSecretKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.SecretKey", "")));
        this.wSecretKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                S3VfsFileChooserBaseDialog.this.handleConnectionButton();
            }
        });
        this.wConnectionButton = new Button(textFieldPanel, 0x1000000);
        this.fdConnectionButton = new GridData();
        this.fdConnectionButton.widthHint = 75;
        this.wConnectionButton.setLayoutData((Object)this.fdConnectionButton);
        this.wConnectionButton.setEnabled(true);
        this.wConnectionButton.setText(BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.ConnectionButton.Label", (String[])new String[0]));
        this.wConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_USE_AWS_DEFAULT_CREDENTIALS"), (String)"N")).booleanValue()) {
                        System.setProperty("aws.accessKeyId", S3VfsFileChooserBaseDialog.this.environmentSubstitute(S3VfsFileChooserBaseDialog.this.wAccessKey.getText()));
                        System.setProperty("aws.secretKey", S3VfsFileChooserBaseDialog.this.environmentSubstitute(S3VfsFileChooserBaseDialog.this.wSecretKey.getText()));
                    }
                    String file = S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.openFileCombo.getText() != null ? S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.openFileCombo.getText() : S3VfsFileChooserBaseDialog.this.buildS3FileSystemUrlString();
                    FileObject root = S3VfsFileChooserBaseDialog.this.resolveFile(file);
                    S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.vfsBrowser.clearFileChildren(root.getPublicURIString());
                    S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.setRootFile(root);
                    S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(root);
                    S3VfsFileChooserBaseDialog.this.vfsFileChooserDialog.setSelectedFile(root);
                    S3VfsFileChooserBaseDialog.this.rootFile = root;
                }
                catch (AmazonS3Exception | FileSystemException ex) {
                    MessageBox box = new MessageBox(S3VfsFileChooserBaseDialog.this.getShell());
                    box.setText(BaseMessages.getString((Class)PKG, (String)"S3VfsFileChooserDialog.error", (String[])new String[0]));
                    box.setMessage(ex.getMessage());
                    S3VfsFileChooserBaseDialog.this.log.logError(ex.getMessage(), ex);
                    box.open();
                    return;
                }
            }
        });
        textFieldPanel.setTabList(new Control[]{this.wAccessKey, this.wSecretKey, this.wConnectionButton});
    }

    private String environmentSubstitute(String str) {
        return this.getVariableSpace().environmentSubstitute(str);
    }

    public String buildS3FileSystemUrlString() {
        return "s3n://s3n/";
    }

    public void activate() {
        this.wAccessKey.setVariables(this.getVariableSpace());
        this.wSecretKey.setVariables(this.getVariableSpace());
        this.wAccessKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.AccessKey", "")));
        this.wSecretKey.setText(Encr.decryptPasswordOptionallyEncrypted((String)Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.SecretKey", "")));
        this.vfsFileChooserDialog.setRootFile(this.rootFile);
        this.vfsFileChooserDialog.setInitialFile(this.initialFile);
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
        try {
            String filename = Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.Filename", this.buildS3FileSystemUrlString());
            FileObject newRoot = this.resolveFile(filename);
            this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    private void initializeConnectionPanel() {
        if (this.initialFile != null && (this.initialFile instanceof S3NFileObject || this.initialFile instanceof S3FileObject)) {
            try {
                GenericFileName genericFileName = (GenericFileName)this.initialFile.getFileSystem().getRoot().getName();
                this.wAccessKey.setText(genericFileName.getUserName() == null ? "" : genericFileName.getUserName());
                this.wSecretKey.setText(genericFileName.getPassword());
            }
            catch (FileSystemException fse) {
                this.showMessageAndLog("S3VfsFileChooserDialog.error", "S3VfsFileChooserDialog.FileSystem.error", fse.getMessage());
            }
        }
        this.handleConnectionButton();
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(BaseMessages.getString(PKG, (String)title, (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)message, (String[])new String[0]));
        this.log.logError(messageToLog);
        box.open();
    }

    private void handleConnectionButton() {
        if (!StringUtils.isEmpty((String)this.wAccessKey.getText()) && !StringUtils.isEmpty((String)this.wSecretKey.getText())) {
            this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.wAccessKey.getText()));
            this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)this.getVariableSpace().environmentSubstitute(this.wSecretKey.getText()));
        } else {
            this.accessKey = null;
            this.secretKey = null;
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        try {
            String accessKey = "";
            String secretKey = "";
            if (!ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_USE_AWS_DEFAULT_CREDENTIALS"), (String)"N")).booleanValue()) {
                accessKey = System.getProperty("aws.accessKeyId");
                secretKey = System.getProperty("aws.secretKey");
            } else {
                AWSCredentials credentials = S3CredentialsProvider.getAWSCredentials();
                if (credentials != null) {
                    accessKey = credentials.getAWSAccessKeyId();
                    secretKey = credentials.getAWSSecretKey();
                }
            }
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, secretKey, accessKey);
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        catch (SdkClientException e) {
            throw new FileSystemException((Throwable)e);
        }
        return opts;
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

