/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import com.cloudera.sqoop.mapreduce.db.DBRecordReader;
import com.cloudera.sqoop.mapreduce.db.OracleDBRecordReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.db.Db2DBRecordReader;

public class DBInputFormat<T extends DBWritable>
extends InputFormat<LongWritable, T>
implements Configurable {
    public static final Log LOG = LogFactory.getLog((String)DBInputFormat.class.getName());
    private String dbProductName = "DEFAULT";
    private String conditions;
    private Connection connection;
    private String tableName;
    private String[] fieldNames;
    private DBConfiguration dbConf;

    public void setConf(Configuration conf) {
        this.setDbConf(new DBConfiguration(conf));
    }

    public void setDbConf(DBConfiguration dbConf) {
        this.dbConf = dbConf;
        try {
            this.getConnection();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.tableName = dbConf.getInputTableName();
        this.fieldNames = dbConf.getInputFieldNames();
        this.conditions = dbConf.getInputConditions();
    }

    private void setTxIsolation(Connection conn) {
        try {
            if (this.getConf().getBoolean("org.apache.sqoop.db.relaxedisolation", false)) {
                if (this.dbProductName.startsWith("ORACLE")) {
                    LOG.info((Object)"Using read committed transaction isolation for Oracle as read uncommitted is not supported");
                    this.connection.setTransactionIsolation(2);
                } else {
                    LOG.info((Object)"Using read uncommited transaction isolation");
                    this.connection.setTransactionIsolation(1);
                }
            } else {
                LOG.info((Object)"Using read commited transaction isolation");
                this.connection.setTransactionIsolation(2);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConf() {
        return this.dbConf.getConf();
    }

    public DBConfiguration getDBConf() {
        return this.dbConf;
    }

    public Connection getConnection() {
        try {
            if (null == this.connection) {
                this.connection = this.dbConf.getConnection();
                this.connection.setAutoCommit(false);
                DatabaseMetaData dbMeta = this.connection.getMetaData();
                this.dbProductName = dbMeta.getDatabaseProductName().toUpperCase();
                this.setTxIsolation(this.connection);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        Class<?> inputClass = this.dbConf.getInputClass();
        try {
            if (this.dbProductName.startsWith("ORACLE")) {
                return new OracleDBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
            }
            if (this.dbProductName.startsWith("DB2")) {
                return new Db2DBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
            }
            return new DBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    public RecordReader<LongWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return this.createDBRecordReader((DBInputFormat.DBInputSplit)split, context.getConfiguration());
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ResultSet results = null;
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            results = statement.executeQuery(this.getCountQuery());
            results.next();
            long count = results.getLong(1);
            int chunks = ConfigurationHelper.getJobNumMaps(job);
            long chunkSize = count / (long)chunks;
            results.close();
            statement.close();
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            for (int i = 0; i < chunks; ++i) {
                DBInputSplit split = i + 1 == chunks ? new DBInputSplit((long)i * chunkSize, count) : new DBInputSplit((long)i * chunkSize, (long)i * chunkSize + chunkSize);
                splits.add(split);
            }
            this.connection.commit();
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException("Got SQLException", e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            this.closeConnection();
        }
    }

    protected String getCountQuery() {
        if (this.dbConf.getInputCountQuery() != null) {
            return this.dbConf.getInputCountQuery();
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM " + this.tableName);
        if (this.conditions != null && this.conditions.length() > 0) {
            query.append(" WHERE " + this.conditions);
        }
        return query.toString();
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String orderBy, String ... fieldNames) {
        job.setInputFormatClass(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        dbConf.setInputClass(inputClass);
        dbConf.setInputTableName(tableName);
        dbConf.setInputFieldNames(fieldNames);
        dbConf.setInputConditions(conditions);
        dbConf.setInputOrderBy(orderBy);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String inputQuery, String inputCountQuery) {
        job.setInputFormatClass(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        dbConf.setInputClass(inputClass);
        dbConf.setInputQuery(inputQuery);
        dbConf.setInputCountQuery(inputCountQuery);
    }

    protected void closeConnection() {
        try {
            if (null != this.connection) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Cannot close JDBC connection.", (Throwable)sqlE);
        }
    }

    public static class DBInputSplit
    extends InputSplit
    implements Writable {
        private long end = 0L;
        private long start = 0L;

        public DBInputSplit() {
        }

        public DBInputSplit(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() throws IOException {
            return this.end - this.start;
        }

        public void readFields(DataInput input) throws IOException {
            this.start = input.readLong();
            this.end = input.readLong();
        }

        public void write(DataOutput output) throws IOException {
            output.writeLong(this.start);
            output.writeLong(this.end);
        }
    }

    public static class NullDBWritable
    implements DBWritable,
    Writable {
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public void readFields(ResultSet arg0) throws SQLException {
        }

        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void write(PreparedStatement arg0) throws SQLException {
        }
    }
}

