/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.hbase.PutTransformer;
import org.apache.sqoop.hbase.ToStringPutTransformer;

public class HBaseBulkImportMapper
extends AutoProgressMapper<LongWritable, SqoopRecord, ImmutableBytesWritable, Put> {
    private LargeObjectLoader lobLoader;
    private PutTransformer putTransformer;
    private Configuration conf;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.lobLoader = new LargeObjectLoader(this.conf, new Path(this.conf.get("sqoop.hbase.lob.extern.dir", "/tmp/sqoop-hbase-" + context.getTaskAttemptID())));
        Class xformerClass = this.conf.getClass("sqoop.hbase.insert.put.transformer.class", ToStringPutTransformer.class);
        this.putTransformer = (PutTransformer)ReflectionUtils.newInstance((Class)xformerClass, (Configuration)this.conf);
        if (null == this.putTransformer) {
            throw new RuntimeException("Could not instantiate PutTransformer.");
        }
        this.putTransformer.init(this.conf);
    }

    public void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            val.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        Map<String, Object> fields = val.getFieldMap();
        List<Mutation> mutationList = this.putTransformer.getMutationCommand(fields);
        for (Mutation mutation : mutationList) {
            if (mutation == null || !(mutation instanceof Put)) continue;
            Put putObject = (Put)mutation;
            context.write((Object)new ImmutableBytesWritable(putObject.getRow()), (Object)putObject);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }
}

