/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.AsyncSqlOutputFormat;
import org.apache.sqoop.mapreduce.AsyncSqlRecordWriter;
import org.apache.sqoop.mapreduce.db.DBConfiguration;

public class ExportCallOutputFormat<K extends SqoopRecord, V>
extends AsyncSqlOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(ExportCallOutputFormat.class);

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(conf);
        if (null == conf.get("mapreduce.jdbc.url")) {
            throw new IOException("Database connection URL is not set.");
        }
        if (null == dbConf.getOutputTableName()) {
            throw new IOException("Procedure name is not set for export");
        }
        if (null == dbConf.getOutputFieldNames() && 0 == dbConf.getOutputFieldCount()) {
            throw new IOException("Output field names are null and zero output field count set.");
        }
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new ExportCallRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class ExportCallRecordWriter
    extends AsyncSqlRecordWriter<K, V> {
        protected String procedureName;
        protected String[] columnNames;
        protected int columnCount;

        public ExportCallRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
            Configuration conf = this.getConf();
            DBConfiguration dbConf = new DBConfiguration(conf);
            this.procedureName = dbConf.getOutputTableName();
            this.columnNames = dbConf.getOutputFieldNames();
            this.columnCount = dbConf.getOutputFieldCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            CallableStatement stmt = null;
            Connection conn = this.getConnection();
            Connection connection = conn;
            synchronized (connection) {
                stmt = conn.prepareCall(this.getCallStatement(userRecords.size()));
            }
            for (SqoopRecord record : userRecords) {
                record.write(stmt, 0);
                stmt.addBatch();
            }
            return stmt;
        }

        @Override
        protected boolean isBatchExec() {
            return true;
        }

        protected String getCallStatement(int numRows) {
            int numSlots;
            StringBuilder sb = new StringBuilder();
            sb.append("{call " + this.procedureName + " (");
            int n = numSlots = this.columnNames == null ? this.columnCount : this.columnNames.length;
            if (numSlots > 0) {
                sb.append("?");
            }
            for (int i = 1; i < numSlots; ++i) {
                sb.append(", ?");
            }
            sb.append(")}");
            return sb.toString();
        }
    }
}

