/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.CatalogQueryManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.cli.RelatedOptions;

public class PostgresqlManager
extends CatalogQueryManager {
    public static final String SCHEMA = "schema";
    public static final Log LOG = LogFactory.getLog((String)PostgresqlManager.class.getName());
    private static final String DRIVER_CLASS = "org.postgresql.Driver";
    private static boolean warningPrinted = false;
    private String schema;

    public PostgresqlManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
        try {
            this.parseExtraArgs(opts.getExtraArgs());
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't parse extra arguments", e);
        }
    }

    @Override
    public String escapeColName(String colName) {
        return this.escapeIdentifier(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        if (this.schema != null && !this.schema.isEmpty()) {
            return this.escapeIdentifier(this.schema) + "." + this.escapeIdentifier(tableName);
        }
        return this.escapeIdentifier(tableName);
    }

    @Override
    public boolean escapeTableNameOnExport() {
        return true;
    }

    protected String escapeIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }

    @Override
    public void close() throws SQLException {
        if (this.hasOpenConnection()) {
            this.getConnection().rollback();
        }
        super.close();
    }

    @Override
    protected String getColNamesQuery(String tableName) {
        return "SELECT t.* FROM " + this.escapeTableName(tableName) + " AS t LIMIT 1";
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        if (!warningPrinted) {
            LOG.warn((Object)"It looks like you are importing from postgresql.");
            LOG.warn((Object)"This transfer can be faster! Use the --direct");
            LOG.warn((Object)"option to exercise a postgresql-specific fast path.");
            warningPrinted = true;
        }
        super.importTable(context);
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT DATNAME FROM PG_CATALOG.PG_DATABASE";
    }

    @Override
    protected String getListTablesQuery() {
        return "SELECT TABLENAME FROM PG_CATALOG.PG_TABLES WHERE SCHEMANAME = " + this.getSchemaSqlFragment();
    }

    @Override
    protected String getListColumnsQuery(String tableName) {
        return "SELECT col.ATTNAME FROM PG_CATALOG.PG_NAMESPACE sch,  PG_CATALOG.PG_CLASS tab, PG_CATALOG.PG_ATTRIBUTE col WHERE sch.OID = tab.RELNAMESPACE   AND tab.OID = col.ATTRELID   AND sch.NSPNAME = " + this.getSchemaSqlFragment() + "  AND tab.RELNAME = '" + this.escapeLiteral(tableName) + "'   AND col.ATTNUM >= 1  AND col.ATTISDROPPED = 'f' ORDER BY col.ATTNUM ASC";
    }

    @Override
    protected String getPrimaryKeyQuery(String tableName) {
        return "SELECT col.ATTNAME FROM PG_CATALOG.PG_NAMESPACE sch,   PG_CATALOG.PG_CLASS tab, PG_CATALOG.PG_ATTRIBUTE col,   PG_CATALOG.PG_INDEX ind WHERE sch.OID = tab.RELNAMESPACE   AND tab.OID = col.ATTRELID   AND tab.OID = ind.INDRELID   AND sch.NSPNAME = " + this.getSchemaSqlFragment() + "  AND tab.RELNAME = '" + this.escapeLiteral(tableName) + "'   AND col.ATTNUM = ANY(ind.INDKEY)   AND ind.INDISPRIMARY";
    }

    private String getSchemaSqlFragment() {
        if (this.schema != null && !this.schema.isEmpty()) {
            return "'" + this.escapeLiteral(this.schema) + "'";
        }
        return "(SELECT CURRENT_SCHEMA())";
    }

    private String escapeLiteral(String literal) {
        return literal.replace("'", "''");
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    private void parseExtraArgs(String[] args) throws ParseException {
        if (args == null || args.length == 0) {
            return;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = parser.parse((Options)this.getExtraOptions(), args, true);
        this.applyExtraArguments(cmdLine);
    }

    protected void applyExtraArguments(CommandLine cmdLine) {
        if (cmdLine.hasOption(SCHEMA)) {
            String schemaName = cmdLine.getOptionValue(SCHEMA);
            LOG.info((Object)("We will use schema " + schemaName));
            this.schema = schemaName;
        }
    }

    protected RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = new RelatedOptions("PostgreSQL extra options:");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional schema name");
        OptionBuilder.withLongOpt((String)SCHEMA);
        extraOptions.addOption(OptionBuilder.create());
        return extraOptions;
    }
}

