/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class HiveConfig {
    public static final Log LOG = LogFactory.getLog((String)HiveConfig.class.getName());
    public static final String HIVE_CONF_CLASS = "org.apache.hadoop.hive.conf.HiveConf";
    public static final String HIVE_SASL_ENABLED = "hive.metastore.sasl.enabled";

    public static Configuration getHiveConf(Configuration conf) throws IOException {
        try {
            Class<?> HiveConfClass = Class.forName(HIVE_CONF_CLASS);
            return (Configuration)HiveConfClass.getConstructor(Configuration.class, Class.class).newInstance(conf, Configuration.class);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Could not load org.apache.hadoop.hive.conf.HiveConf. Make sure HIVE_CONF_DIR is set correctly.");
            throw new IOException(ex);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not instantiate HiveConf instance.", (Throwable)ex);
            throw new IOException(ex);
        }
    }

    public static void addHiveConfigs(Configuration hiveConf, Configuration conf) {
        for (Map.Entry item : hiveConf) {
            conf.setIfUnset((String)item.getKey(), (String)item.getValue());
        }
    }
}

